/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.common.Market;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class BlockStonemason
extends BlockFounder {
    private static final ItemStack sand_4 = new ItemStack((Block)Blocks.field_150354_m, 4);
    private static final ItemStack rawStone_4 = new ItemStack(Blocks.field_150348_b, 4, 0);
    private static final ItemStack rawGranite_4 = new ItemStack(Blocks.field_150348_b, 4, 1);
    private static final ItemStack rawDiorite_4 = new ItemStack(Blocks.field_150348_b, 4, 3);
    private static final ItemStack rawAndesite_4 = new ItemStack(Blocks.field_150348_b, 4, 5);
    private static final ItemStack cobblestone_8 = new ItemStack(Blocks.field_150347_e, 8);
    private static final ItemStack coal = new ItemStack(Items.field_151044_h, 1, 0);
    private static final ItemStack charcoal = new ItemStack(Items.field_151044_h, 1, 1);

    public BlockStonemason() {
        super(3, 0, 8);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175640_z(pos)) {
            return;
        }
        super.func_180645_a(world, pos, state, rand);
        if (this.chance <= 0.1f && !this.eat(world, pos, 1, 0.0f)) {
            return;
        }
        if (world.func_72820_D() % 24000L >= 18000L) {
            return;
        }
        if (UtilInventory.isSlotsFull(this.inventory)) {
            if (showInventoryFullMsg) {
                this.complain(world, "tile.founder.msg.full", new Object[0]);
            }
            return;
        }
        this.findFurnace(world);
        this.smeltStone(world, pos);
        this.craftStone(world, pos, 2);
    }

    @Override
    public boolean canContain(IFounder block) {
        return true;
    }

    @Override
    public boolean canBeContainedIn(IFounder block) {
        return block.isBuilding();
    }

    private void smeltStone(World world, BlockPos pos) {
        BlockFounder.TransactionResult lastCobbleResult = BlockFounder.TransactionResult.SUCCESS;
        BlockFounder.TransactionResult lastFuelResult = BlockFounder.TransactionResult.SUCCESS;
        for (int i = 0; i < this.furnaces.size(); ++i) {
            ItemStack received;
            TileEntityFurnace furnace = (TileEntityFurnace)this.furnaces.get(i);
            if (furnace.func_70301_a(2) != null && !UtilInventory.isSlotsFull(this.inventory)) {
                ItemStack stack = furnace.func_70298_a(2, furnace.func_70301_a((int)2).field_77994_a);
                this.addItemToInventory(stack, this.coinPouch);
            }
            if (furnace.func_145950_i()) continue;
            if (furnace.func_70301_a(1) == null) {
                received = UtilInventory.findItemsMeta(this.inventory, coal, charcoal);
                if (received == null && (received = this.requestItem(world, pos, coal)) == null) {
                    received = this.requestItem(world, pos, charcoal);
                }
                if (received == null) {
                    lastFuelResult = lastResult;
                } else {
                    furnace.func_70299_a(1, received);
                }
            }
            if (furnace.func_70301_a(0) != null) continue;
            received = UtilInventory.findItem(this.inventory, cobblestone_8);
            if (received == null) {
                received = this.requestItem(world, pos, cobblestone_8);
            }
            if (received == null) {
                lastCobbleResult = lastResult;
                continue;
            }
            furnace.func_70299_a(0, received);
        }
        if (lastCobbleResult != BlockFounder.TransactionResult.SUCCESS) {
            this.complainResult(world, lastCobbleResult, Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]);
        }
        if (lastFuelResult != BlockFounder.TransactionResult.SUCCESS) {
            this.complainResult(world, lastFuelResult, Items.field_151044_h.func_77658_a() + ".name", new Object[0]);
        }
    }

    private void craftStone(World world, BlockPos pos, int amount) {
        while (amount > 0) {
            boolean crafted = false;
            if (UtilInventory.isSlotsFull(this.inventory)) {
                return;
            }
            ItemStack received = UtilInventory.findItemMeta(this.inventory, rawGranite_4);
            if (received == null) {
                received = this.requestItem(world, pos, rawGranite_4);
            }
            if (received != null) {
                this.addItemToInventory(new ItemStack(Blocks.field_150348_b, 4, 2), this.coinPouch);
                crafted = true;
            }
            if (UtilInventory.isSlotsFull(this.inventory)) {
                return;
            }
            received = UtilInventory.findItemMeta(this.inventory, rawDiorite_4);
            if (received == null) {
                received = this.requestItem(world, pos, rawDiorite_4);
            }
            if (received != null) {
                this.addItemToInventory(new ItemStack(Blocks.field_150348_b, 4, 4), this.coinPouch);
                crafted = true;
            }
            if (UtilInventory.isSlotsFull(this.inventory)) {
                return;
            }
            received = UtilInventory.findItemMeta(this.inventory, rawAndesite_4);
            if (received == null) {
                received = this.requestItem(world, pos, rawAndesite_4);
            }
            if (received != null) {
                this.addItemToInventory(new ItemStack(Blocks.field_150348_b, 4, 6), this.coinPouch);
                crafted = true;
            }
            if (UtilInventory.isSlotsFull(this.inventory)) {
                return;
            }
            received = UtilInventory.findItemMeta(this.inventory, rawStone_4);
            if (received == null) {
                received = this.requestItem(world, pos, rawStone_4);
            } else if (this.coinPouch != null && !expertMode) {
                this.coinPouch.func_82841_c(Math.max(0, this.coinPouch.func_82838_A() - Market.getPrice(received) * received.field_77994_a));
            }
            if (received != null) {
                this.addItemToInventory(new ItemStack(Blocks.field_150417_aV, 4, 0), this.coinPouch);
                crafted = true;
            }
            if (UtilInventory.isSlotsFull(this.inventory)) {
                return;
            }
            received = UtilInventory.findItem(this.inventory, sand_4);
            if (received == null) {
                received = this.requestItem(world, pos, sand_4);
            }
            if (received != null) {
                this.addItemToInventory(new ItemStack(Blocks.field_150322_A, 1), this.coinPouch);
                crafted = true;
            }
            if (crafted) {
                --amount;
                continue;
            }
            this.complainResult(world, lastResult, "%s/%s", new TextComponentTranslation(Blocks.field_150348_b.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Blocks.field_150354_m.func_149739_a() + ".name", new Object[0]));
            return;
        }
    }
}

