/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.CitiesMod;
import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.inventory.AutoRecipes;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockRoad
extends BlockFounder {
    protected static final float PLAYER_TIME = 1.6f;
    protected static final float TICK_TIME = 68.27f;
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final ItemStack dirt = new ItemStack(Blocks.field_150346_d);
    private static final ItemStack sand = new ItemStack((Block)Blocks.field_150354_m);
    private static final ItemStack torch = new ItemStack(Blocks.field_150478_aa);
    private static final ItemStack glowstone = new ItemStack(Blocks.field_150426_aN);
    private static final ItemStack sea_lantern = new ItemStack(Blocks.field_180398_cJ);
    private static final ItemStack cobblestone = new ItemStack(Blocks.field_150347_e);
    private static final ItemStack stonebrick = new ItemStack(Blocks.field_150417_aV);
    private static final ItemStack stonebrick_stairs = new ItemStack(Blocks.field_150390_bg);
    private static final ItemStack cobblestone_slab = new ItemStack((Block)Blocks.field_150333_U, 1, 3);
    private static final ItemStack oakFence = new ItemStack(Blocks.field_180407_aO);
    private static final ItemStack spruceFence = new ItemStack(Blocks.field_180408_aP);
    private static final ItemStack birchFence = new ItemStack(Blocks.field_180404_aQ);
    private static final ItemStack jungleFence = new ItemStack(Blocks.field_180403_aR);
    private static final ItemStack acaciaFence = new ItemStack(Blocks.field_180405_aT);
    private static final ItemStack darkoakFence = new ItemStack(Blocks.field_180406_aS);
    private static final ItemStack netherbrickFence = new ItemStack(Blocks.field_150386_bk);
    private static final ItemStack ironRod = new ItemStack(Blocks.field_150411_aY);
    private static final ItemStack glassRod = new ItemStack(Blocks.field_150410_aZ);
    private static final ItemStack endRod = new ItemStack(Blocks.field_185764_cQ);
    public static boolean bridgeSupports = true;

    public BlockRoad() {
        super(3, -61, 16);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175640_z(pos)) {
            return;
        }
        super.func_180645_a(world, pos, state, rand);
        if (this.chance <= 0.1f && !this.eat(world, pos, 1, 0.0f)) {
            return;
        }
        this.build(world, pos, 68.27f);
    }

    @Override
    public boolean canRequestFrom() {
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 3);
        super.func_180633_a(world, pos, state, placer, stack);
        if (placer instanceof EntityPlayer) {
            ((EntityPlayer)placer).func_71064_a((StatBase)CitiesMod.cities_achievements[18], 1);
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    private void build(World world, BlockPos pos, float amount) {
        Block block;
        BlockPos blockPos;
        int z;
        int x;
        int y;
        boolean cart;
        if (amount <= 0.0f) {
            return;
        }
        boolean rail = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150448_aq)) >= 0;
        boolean bl = cart = UtilInventory.findItem(this.inventory, Items.field_151143_au) >= 0;
        if (cart) {
            rail = true;
        }
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        int yTop = rail ? pos.func_177956_o() - 6 : pos.func_177956_o() - 3;
        int foundSupport = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.stone);
        if (foundSupport < 0) {
            foundSupport = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_180397_cI));
        }
        if (bridgeSupports) {
            for (y = yTop; y >= this.yStart; --y) {
                for (x = this.xStart; x <= this.xEnd; ++x) {
                    for (z = this.zStart; z <= this.zEnd; ++z) {
                        ItemStack received;
                        ItemStack item;
                        IBlockState state;
                        ItemStack stack;
                        blockPos = new BlockPos(x, y, z);
                        block = world.func_180495_p(blockPos).func_177230_c();
                        if (block instanceof BlockFounder) continue;
                        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                            if ((z - 3) % 16 != 0 && (z - 12) % 16 != 0 || (x - 5) % 16 != 0 && (x - 6) % 16 != 0 && (x - 9) % 16 != 0 && (x - 10) % 16 != 0 || !world.func_180495_p(blockPos).func_185904_a().func_76224_d() && world.func_180495_p(blockPos).func_185904_a() != Material.field_151579_a && !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !Block.func_149680_a((Block)block, (Block)Blocks.field_150362_t) && !Block.func_149680_a((Block)block, (Block)Blocks.field_150361_u)) continue;
                            if (foundSupport >= 0 && y != yTop) {
                                stack = this.inventory.func_70301_a(foundSupport);
                                state = world.func_180495_p(blockPos.func_177984_a());
                                if (Item.func_150898_a((Block)state.func_177230_c()) != stack.func_77973_b() || state.func_177230_c().func_180651_a(state) != stack.func_77960_j()) continue;
                            }
                            if (foundSupport < 0) {
                                this.complain(world, "tile.founder.building.msg.stone", new Object[0]);
                                return;
                            }
                            item = this.inventory.func_70301_a(foundSupport).func_77946_l();
                            item.field_77994_a = 1;
                            received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                            if (received == null) {
                                received = this.requestItem(world, pos, item);
                            }
                            if (received == null) {
                                this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176203_a(received.func_77960_j()));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        if ((x - 3) % 16 != 0 && (x - 12) % 16 != 0 || (z - 5) % 16 != 0 && (z - 6) % 16 != 0 && (z - 9) % 16 != 0 && (z - 10) % 16 != 0 || !world.func_180495_p(blockPos).func_185904_a().func_76224_d() && world.func_180495_p(blockPos).func_185904_a() != Material.field_151579_a && !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !Block.func_149680_a((Block)block, (Block)Blocks.field_150362_t) && !Block.func_149680_a((Block)block, (Block)Blocks.field_150361_u)) continue;
                        if (foundSupport >= 0 && y != yTop) {
                            stack = this.inventory.func_70301_a(foundSupport);
                            state = world.func_180495_p(blockPos.func_177984_a());
                            if (Item.func_150898_a((Block)state.func_177230_c()) != stack.func_77973_b() || state.func_177230_c().func_180651_a(state) != stack.func_77960_j()) continue;
                        }
                        if (foundSupport < 0) {
                            this.complain(world, "tile.founder.building.msg.stone", new Object[0]);
                            return;
                        }
                        item = this.inventory.func_70301_a(foundSupport).func_77946_l();
                        item.field_77994_a = 1;
                        received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                        if (received == null) {
                            received = this.requestItem(world, pos, item);
                        }
                        if (received == null) {
                            this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                            return;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176203_a(received.func_77960_j()));
                        amount -= 1.6f;
                        if (!(amount <= 0.0f)) continue;
                        return;
                    }
                }
            }
        }
        for (y = yTop + 1; y <= this.yEnd; ++y) {
            for (x = this.xStart; x <= this.xEnd; ++x) {
                for (z = this.zStart; z <= this.zEnd; ++z) {
                    ItemStack stack;
                    ItemStack torches;
                    TextComponentTranslation light;
                    ItemStack received;
                    ItemStack item;
                    blockPos = new BlockPos(x, y, z);
                    block = world.func_180495_p(blockPos).func_177230_c();
                    if (block instanceof BlockFounder) continue;
                    if (rail && y == pos.func_177956_o() - 5) {
                        ItemStack target;
                        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                            ItemStack target2;
                            if (x <= this.xStart + 4 || x >= this.xEnd - 4 || OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{target2 = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE)}) || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target2})) continue;
                            int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.plankWood);
                            if (found < 0) {
                                this.complain(world, "tile.founder.building.msg.floor", new Object[0]);
                                return;
                            }
                            item = this.inventory.func_70301_a(found).func_77946_l();
                            item.field_77994_a = 1;
                            received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                            if (received == null) {
                                received = this.requestItem(world, pos, item);
                            }
                            if (received == null) {
                                this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)item.func_77973_b()).func_176203_a(item.func_77960_j()));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        if (z <= this.zStart + 4 || z >= this.zEnd - 4 || OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE)}) || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                        int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.plankWood);
                        if (found < 0) {
                            this.complain(world, "tile.founder.building.msg.floor", new Object[0]);
                            return;
                        }
                        item = this.inventory.func_70301_a(found).func_77946_l();
                        item.field_77994_a = 1;
                        received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                        if (received == null) {
                            received = this.requestItem(world, pos, item);
                        }
                        if (received == null) {
                            this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                            return;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)item.func_77973_b()).func_176203_a(item.func_77960_j()));
                        amount -= 1.6f;
                        if (!(amount <= 0.0f)) continue;
                        return;
                    }
                    if (rail && y == pos.func_177956_o() - 4) {
                        ItemStack target;
                        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                            ItemStack target3;
                            if ((x - 7) % 16 == 0 || (x - 8) % 16 == 0) {
                                ItemStack target4 = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                                if (block == Blocks.field_150448_aq && world.func_180495_p(blockPos).func_177229_b((IProperty)BlockRail.field_176565_b) != BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
                                    world.func_180501_a(blockPos, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH), 2);
                                }
                                if (block == Blocks.field_150448_aq || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target4})) continue;
                                ItemStack received2 = UtilInventory.findItemMetaWithMin(this.inventory, 2, new ItemStack(Blocks.field_150448_aq));
                                if (received2 == null) {
                                    received2 = this.requestItem(world, pos, new ItemStack(Blocks.field_150448_aq));
                                }
                                if (received2 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150448_aq.func_149739_a() + ".name", new Object[0]);
                                    return;
                                }
                                world.func_180501_a(blockPos, Block.func_149634_a((Item)received2.func_77973_b()).func_176203_a(0), 2);
                                amount -= 1.6f;
                                if (!(amount <= 0.0f)) continue;
                                return;
                            }
                            if ((x - 6) % 16 == 0 || (x - 9) % 16 == 0) {
                                ItemStack target5 = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                                if (!world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target5}) || !world.func_175655_b(blockPos, false) || !((amount -= 1.0f) <= 0.0f)) continue;
                                return;
                            }
                            if ((x - 4) % 16 == 0 || (x - 5) % 16 == 0 || (x - 10) % 16 == 0 || (x - 11) % 16 == 0) {
                                ItemStack target6 = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                                if (OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{target6}) || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target6})) continue;
                                int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.plankWood);
                                if (found < 0) {
                                    this.complain(world, "tile.founder.building.msg.floor", new Object[0]);
                                    return;
                                }
                                item = this.inventory.func_70301_a(found).func_77946_l();
                                item.field_77994_a = 1;
                                received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                                if (received == null) {
                                    received = this.requestItem(world, pos, item);
                                }
                                if (received == null) {
                                    this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                                    return;
                                }
                                world.func_175656_a(blockPos, Block.func_149634_a((Item)item.func_77973_b()).func_176203_a(item.func_77960_j()));
                                amount -= 1.6f;
                                if (!(amount <= 0.0f)) continue;
                                return;
                            }
                            if (x >= this.xStart + 4 && x <= this.xEnd - 4 || !cart || OreDictionary.containsMatch((boolean)false, AutoRecipes.stone, (ItemStack[])new ItemStack[]{target3 = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE)}) || block == Blocks.field_180397_cI || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target3})) continue;
                            int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.stone);
                            if (found < 0) {
                                found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_180397_cI));
                            }
                            if (found < 0) {
                                this.complain(world, "tile.founder.building.msg.stone", new Object[0]);
                                return;
                            }
                            item = this.inventory.func_70301_a(found).func_77946_l();
                            item.field_77994_a = 1;
                            received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                            if (received == null) {
                                received = this.requestItem(world, pos, item);
                            }
                            if (received == null) {
                                this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176203_a(received.func_77960_j()));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        if ((z - 7) % 16 == 0 || (z - 8) % 16 == 0) {
                            ItemStack target7 = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (block == Blocks.field_150448_aq && world.func_180495_p(blockPos).func_177229_b((IProperty)BlockRail.field_176565_b) != BlockRailBase.EnumRailDirection.EAST_WEST) {
                                world.func_180501_a(blockPos, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST), 2);
                            }
                            if (block == Blocks.field_150448_aq || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target7})) continue;
                            ItemStack received3 = UtilInventory.findItemMetaWithMin(this.inventory, 2, new ItemStack(Blocks.field_150448_aq));
                            if (received3 == null) {
                                received3 = this.requestItem(world, pos, new ItemStack(Blocks.field_150448_aq));
                            }
                            if (received3 == null) {
                                this.complainResult(world, lastResult, Blocks.field_150448_aq.func_149739_a() + ".name", new Object[0]);
                                return;
                            }
                            world.func_180501_a(blockPos, Block.func_149634_a((Item)received3.func_77973_b()).func_176203_a(1), 2);
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        if ((z - 6) % 16 == 0 || (z - 9) % 16 == 0) {
                            ItemStack target8 = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (!world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target8}) || !world.func_175655_b(blockPos, false) || !((amount -= 1.0f) <= 0.0f)) continue;
                            return;
                        }
                        if ((z - 4) % 16 == 0 || (z - 5) % 16 == 0 || (z - 10) % 16 == 0 || (z - 11) % 16 == 0) {
                            ItemStack target9 = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{target9}) || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target9})) continue;
                            int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.plankWood);
                            if (found < 0) {
                                this.complain(world, "tile.founder.building.msg.floor", new Object[0]);
                                return;
                            }
                            item = this.inventory.func_70301_a(found).func_77946_l();
                            item.field_77994_a = 1;
                            received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                            if (received == null) {
                                received = this.requestItem(world, pos, item);
                            }
                            if (received == null) {
                                this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)item.func_77973_b()).func_176203_a(item.func_77960_j()));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        if (z >= this.zStart + 4 && z <= this.zEnd - 4 || !cart || OreDictionary.containsMatch((boolean)false, AutoRecipes.stone, (ItemStack[])new ItemStack[]{target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE)}) || block == Blocks.field_180397_cI || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                        int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.stone);
                        if (found < 0) {
                            found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_180397_cI));
                        }
                        if (found < 0) {
                            this.complain(world, "tile.founder.building.msg.stone", new Object[0]);
                            return;
                        }
                        item = this.inventory.func_70301_a(found).func_77946_l();
                        item.field_77994_a = 1;
                        received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                        if (received == null) {
                            received = this.requestItem(world, pos, item);
                        }
                        if (received == null) {
                            this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                            return;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176203_a(received.func_77960_j()));
                        amount -= 1.6f;
                        if (!(amount <= 0.0f)) continue;
                        return;
                    }
                    if (rail && y == pos.func_177956_o() - 3) {
                        if (!(cart || (x - 4) % 16 != 0 && (x - 11) % 16 != 0 || (z - 4) % 16 != 0 && (z - 11) % 16 != 0)) {
                            ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (block == Blocks.field_150426_aN || block == Blocks.field_180398_cJ || block == Blocks.field_150478_aa || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                            int found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150426_aN));
                            if (found < 0) {
                                found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_180398_cJ));
                            }
                            if (found < 0) {
                                found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150478_aa));
                            }
                            if (found < 0) {
                                light = new TextComponentTranslation("%s/%s/%s", new Object[]{new TextComponentTranslation(Blocks.field_150426_aN.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Blocks.field_180398_cJ.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Blocks.field_150478_aa.func_149739_a() + ".name", new Object[0])});
                                this.complain(world, "tile.founder.building.msg.light", light);
                                return;
                            }
                            item = this.inventory.func_70301_a(found).func_77946_l();
                            item.field_77994_a = 1;
                            received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                            if (received == null && (received = this.requestItem(world, pos, item)) == null && item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) && (torches = AutoRecipes.make8TorchesFromCoalAndPlanks(world, pos, this, this.inventory)) != null) {
                                received = torches.func_77979_a(1);
                                if (torches.field_77994_a > 0) {
                                    UtilInventory.addItemToInventory(this.inventory, torches);
                                }
                            }
                            if (received == null) {
                                this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176203_a(0));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                            if (x < this.xStart + (cart ? 0 : 4) || x > this.xEnd - (cart ? 0 : 4)) continue;
                            if (x == this.xStart + (cart ? 0 : 4) || x == this.xEnd - (cart ? 0 : 4) || cart && (x < this.xStart + 5 || x > this.xEnd - 5) && (z % 16 == 0 || (z - 15) % 16 == 0)) {
                                ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                                if (block == Blocks.field_150347_e || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                                ItemStack received4 = UtilInventory.findItem(this.inventory, cobblestone);
                                if (received4 == null) {
                                    received4 = this.requestItem(world, pos, cobblestone);
                                }
                                if (received4 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]);
                                    return;
                                }
                                world.func_175656_a(blockPos, Block.func_149634_a((Item)received4.func_77973_b()).func_176203_a(received4.func_77960_j()));
                                amount -= 1.6f;
                                if (!(amount <= 0.0f)) continue;
                                return;
                            }
                            if (cart && (((x - 1) % 16 == 0 || (x - 2) % 16 == 0) && (z - 4) % 16 == 0 || ((x - 14) % 16 == 0 || (x - 13) % 16 == 0) && (z - 11) % 16 == 0)) {
                                if (block == Blocks.field_150390_bg) continue;
                                int dir = z < this.zStart + 8 ? 3 : 2;
                                ItemStack received5 = UtilInventory.findItem(this.inventory, stonebrick_stairs);
                                if (received5 == null && (stack = AutoRecipes.make4StonebrickStairsFromStonebrick(world, pos, this, this.inventory)) != null) {
                                    received5 = stack.func_77979_a(1);
                                    if (stack.field_77994_a > 0) {
                                        UtilInventory.addItemToInventory(this.inventory, stack);
                                    }
                                }
                                if (received5 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                                    return;
                                }
                                world.func_175656_a(blockPos, Block.func_149634_a((Item)received5.func_77973_b()).func_176203_a(dir));
                                amount -= 1.6f;
                                if (!(amount <= 0.0f)) continue;
                                return;
                            }
                            ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (!world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}) || !world.func_175655_b(blockPos, false) || !((amount -= 1.0f) <= 0.0f)) continue;
                            return;
                        }
                        if (z < this.zStart + (cart ? 0 : 4) || z > this.zEnd - (cart ? 0 : 4)) continue;
                        if (z == this.zStart + (cart ? 0 : 4) || z == this.zEnd - (cart ? 0 : 4) || cart && (z < this.zStart + 5 || z > this.zEnd - 5) && (x % 16 == 0 || (x - 15) % 16 == 0)) {
                            ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (block == Blocks.field_150347_e || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                            ItemStack received6 = UtilInventory.findItem(this.inventory, cobblestone);
                            if (received6 == null) {
                                received6 = this.requestItem(world, pos, cobblestone);
                            }
                            if (received6 == null) {
                                this.complainResult(world, lastResult, Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received6.func_77973_b()).func_176203_a(received6.func_77960_j()));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        if (cart && (((z - 1) % 16 == 0 || (z - 2) % 16 == 0) && (x - 4) % 16 == 0 || ((z - 14) % 16 == 0 || (z - 13) % 16 == 0) && (x - 11) % 16 == 0)) {
                            if (block == Blocks.field_150390_bg) continue;
                            int dir = x < this.xStart + 8 ? 1 : 0;
                            ItemStack received7 = UtilInventory.findItem(this.inventory, stonebrick_stairs);
                            if (received7 == null && (stack = AutoRecipes.make4StonebrickStairsFromStonebrick(world, pos, this, this.inventory)) != null) {
                                received7 = stack.func_77979_a(1);
                                if (stack.field_77994_a > 0) {
                                    UtilInventory.addItemToInventory(this.inventory, stack);
                                }
                            }
                            if (received7 == null) {
                                this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received7.func_77973_b()).func_176203_a(dir));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                        if (!world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}) || !world.func_175655_b(blockPos, false) || !((amount -= 1.0f) <= 0.0f)) continue;
                        return;
                    }
                    if (y == pos.func_177956_o() - 2) {
                        IBlockState state;
                        if (rail && (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH)) {
                            if (x <= this.xStart + (cart ? 0 : 4) || x >= this.xEnd - (cart ? 0 : 4) || cart && (x < this.xStart + 5 || x > this.xEnd - 5) && (z % 16 == 0 || (z - 15) % 16 == 0)) {
                                ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                                if (block == Blocks.field_150347_e || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                                ItemStack received8 = UtilInventory.findItem(this.inventory, cobblestone);
                                if (received8 == null) {
                                    received8 = this.requestItem(world, pos, cobblestone);
                                }
                                if (received8 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]);
                                    return;
                                }
                                world.func_175656_a(blockPos, Block.func_149634_a((Item)received8.func_77973_b()).func_176203_a(received8.func_77960_j()));
                                amount -= 1.6f;
                                if (!(amount <= 0.0f)) continue;
                                return;
                            }
                            if (cart && (((x - 1) % 16 == 0 || (x - 2) % 16 == 0) && (z - 3) % 16 == 0 || ((x - 14) % 16 == 0 || (x - 13) % 16 == 0) && (z - 12) % 16 == 0)) {
                                if (block == Blocks.field_150390_bg) continue;
                                int dir = z < this.zStart + 8 ? 3 : 2;
                                ItemStack received9 = UtilInventory.findItem(this.inventory, stonebrick_stairs);
                                if (received9 == null && (stack = AutoRecipes.make4StonebrickStairsFromStonebrick(world, pos, this, this.inventory)) != null) {
                                    received9 = stack.func_77979_a(1);
                                    if (stack.field_77994_a > 0) {
                                        UtilInventory.addItemToInventory(this.inventory, stack);
                                    }
                                }
                                if (received9 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                                    return;
                                }
                                world.func_175656_a(blockPos, Block.func_149634_a((Item)received9.func_77973_b()).func_176203_a(dir));
                                amount -= 1.6f;
                                if (!(amount <= 0.0f)) continue;
                                return;
                            }
                            if (!((cart || (x - 5) % 16 != 0 && (x - 10) % 16 != 0) && (!cart || (z >= this.zStart + 1 && z <= this.zEnd - 1 || (x - 5) % 16 != 0 && (x - 10) % 16 != 0) && (x >= this.xStart + 5 && x <= this.xEnd - 5 || (z - 1) % 16 != 0 && (z - 14) % 16 != 0)))) {
                                if (block == Blocks.field_150390_bg) continue;
                                EnumFacing dir = !cart ? (x < this.xStart + 8 ? EnumFacing.WEST : EnumFacing.EAST) : ((z - 1) % 16 == 0 ? EnumFacing.NORTH : ((z - 14) % 16 == 0 ? EnumFacing.SOUTH : ((x - 5) % 16 == 0 ? EnumFacing.WEST : EnumFacing.EAST)));
                                ItemStack received10 = UtilInventory.findItem(this.inventory, stonebrick_stairs);
                                if (received10 == null && (stack = AutoRecipes.make4StonebrickStairsFromStonebrick(world, pos, this, this.inventory)) != null) {
                                    received10 = stack.func_77979_a(1);
                                    if (stack.field_77994_a > 0) {
                                        UtilInventory.addItemToInventory(this.inventory, stack);
                                    }
                                }
                                if (received10 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                                    return;
                                }
                                state = Block.func_149634_a((Item)received10.func_77973_b()).func_176223_P();
                                state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)dir).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
                                world.func_175656_a(blockPos, state);
                                amount -= 1.6f;
                                if (!(amount <= 0.0f)) continue;
                                return;
                            }
                            if (cart) {
                                ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                                if (!world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}) || !world.func_175655_b(blockPos, false) || !((amount -= 1.0f) <= 0.0f)) continue;
                                return;
                            }
                            ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (block == Blocks.field_150333_U || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                            ItemStack received11 = UtilInventory.findItemMeta(this.inventory, cobblestone_slab);
                            if (received11 == null && (stack = AutoRecipes.make2CobblestoneSlabFromCobblestone(world, pos, this, this.inventory)) != null) {
                                received11 = stack.func_77979_a(1);
                                if (stack.field_77994_a > 0) {
                                    UtilInventory.addItemToInventory(this.inventory, stack);
                                }
                            }
                            if (received11 == null) {
                                this.complainResult(world, lastResult, Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE).func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        if (rail && (facing == EnumFacing.EAST || facing == EnumFacing.WEST)) {
                            if (z <= this.zStart + (cart ? 0 : 4) || z >= this.zEnd - (cart ? 0 : 4) || cart && (z < this.zStart + 5 || z > this.zEnd - 5) && (x % 16 == 0 || (x - 15) % 16 == 0)) {
                                ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                                if (block == Blocks.field_150347_e || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                                ItemStack received12 = UtilInventory.findItem(this.inventory, cobblestone);
                                if (received12 == null) {
                                    received12 = this.requestItem(world, pos, cobblestone);
                                }
                                if (received12 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]);
                                    return;
                                }
                                world.func_175656_a(blockPos, Block.func_149634_a((Item)received12.func_77973_b()).func_176203_a(received12.func_77960_j()));
                                amount -= 1.6f;
                                if (!(amount <= 0.0f)) continue;
                                return;
                            }
                            if (cart && (((z - 1) % 16 == 0 || (z - 2) % 16 == 0) && (x - 3) % 16 == 0 || ((z - 14) % 16 == 0 || (z - 13) % 16 == 0) && (x - 12) % 16 == 0)) {
                                if (block == Blocks.field_150390_bg) continue;
                                int dir = x < this.xStart + 8 ? 1 : 0;
                                ItemStack received13 = UtilInventory.findItem(this.inventory, stonebrick_stairs);
                                if (received13 == null && (stack = AutoRecipes.make4StonebrickStairsFromStonebrick(world, pos, this, this.inventory)) != null) {
                                    received13 = stack.func_77979_a(1);
                                    if (stack.field_77994_a > 0) {
                                        UtilInventory.addItemToInventory(this.inventory, stack);
                                    }
                                }
                                if (received13 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                                    return;
                                }
                                world.func_175656_a(blockPos, Block.func_149634_a((Item)received13.func_77973_b()).func_176203_a(dir));
                                amount -= 1.6f;
                                if (!(amount <= 0.0f)) continue;
                                return;
                            }
                            if (!((cart || (z - 5) % 16 != 0 && (z - 10) % 16 != 0) && (!cart || (x >= this.xStart + 1 && x <= this.xEnd - 1 || (z - 5) % 16 != 0 && (z - 10) % 16 != 0) && (z >= this.zStart + 5 && z <= this.zEnd - 5 || (x - 1) % 16 != 0 && (x - 14) % 16 != 0)))) {
                                if (block == Blocks.field_150390_bg) continue;
                                EnumFacing dir = !cart ? (z < this.zStart + 8 ? EnumFacing.NORTH : EnumFacing.SOUTH) : ((x - 1) % 16 == 0 ? EnumFacing.WEST : ((x - 14) % 16 == 0 ? EnumFacing.EAST : ((z - 5) % 16 == 0 ? EnumFacing.NORTH : EnumFacing.SOUTH)));
                                ItemStack received14 = UtilInventory.findItem(this.inventory, stonebrick_stairs);
                                if (received14 == null && (stack = AutoRecipes.make4StonebrickStairsFromStonebrick(world, pos, this, this.inventory)) != null) {
                                    received14 = stack.func_77979_a(1);
                                    if (stack.field_77994_a > 0) {
                                        UtilInventory.addItemToInventory(this.inventory, stack);
                                    }
                                }
                                if (received14 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                                    return;
                                }
                                state = Block.func_149634_a((Item)received14.func_77973_b()).func_176223_P();
                                state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)dir).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
                                world.func_175656_a(blockPos, state);
                                amount -= 1.6f;
                                if (!(amount <= 0.0f)) continue;
                                return;
                            }
                            if (cart) {
                                ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                                if (!world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}) || !world.func_175655_b(blockPos, false) || !((amount -= 1.0f) <= 0.0f)) continue;
                                return;
                            }
                            ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (block == Blocks.field_150333_U || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                            ItemStack received15 = UtilInventory.findItemMeta(this.inventory, cobblestone_slab);
                            if (received15 == null && (stack = AutoRecipes.make2CobblestoneSlabFromCobblestone(world, pos, this, this.inventory)) != null) {
                                received15 = stack.func_77979_a(1);
                                if (stack.field_77994_a > 0) {
                                    UtilInventory.addItemToInventory(this.inventory, stack);
                                }
                            }
                            if (received15 == null) {
                                this.complainResult(world, lastResult, Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE).func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        if (!world.func_180495_p(blockPos).func_185904_a().func_76224_d() && world.func_180495_p(blockPos).func_185904_a() != Material.field_151579_a && !Block.func_149680_a((Block)block, (Block)Blocks.field_150362_t) && !Block.func_149680_a((Block)block, (Block)Blocks.field_150361_u)) continue;
                        ItemStack received16 = null;
                        int cobble = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150347_e));
                        received16 = cobble < 0 ? this.requestItem(world, pos, cobblestone) : this.inventory.func_70298_a(cobble, 1);
                        if (received16 == null) {
                            this.complainResult(world, lastResult, Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]);
                            return;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)received16.func_77973_b()).func_176203_a(received16.func_77960_j()));
                        amount -= 1.6f;
                        if (!(amount <= 0.0f)) continue;
                        return;
                    }
                    if (y == pos.func_177956_o() - 1) {
                        ItemStack stack2;
                        ItemStack received17;
                        if (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) {
                            if (x % 16 == 0 || (x - 1) % 16 == 0 || (x - 14) % 16 == 0 || (x - 15) % 16 == 0 || cart && z % 16 != 0 && (z - 15) % 16 != 0 && ((x - 2) % 16 == 0 || (x - 3) % 16 == 0 || (x - 12) % 16 == 0 || (x - 13) % 16 == 0)) {
                                if (cart && (((x - 1) % 16 == 0 || (x - 2) % 16 == 0) && z > this.zStart + 1 && z < this.zStart + 7 || ((x - 14) % 16 == 0 || (x - 13) % 16 == 0) && z > this.zEnd - 7 && z < this.zEnd - 1)) {
                                    ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                                    if ((z - 2) % 16 == 0 || (z - 13) % 16 == 0) {
                                        if (block == Blocks.field_150390_bg) continue;
                                        int dir = z < this.zStart + 8 ? 3 : 2;
                                        received17 = UtilInventory.findItem(this.inventory, stonebrick_stairs);
                                        if (received17 == null && (stack2 = AutoRecipes.make4StonebrickStairsFromStonebrick(world, pos, this, this.inventory)) != null) {
                                            received17 = stack2.func_77979_a(1);
                                            if (stack2.field_77994_a > 0) {
                                                UtilInventory.addItemToInventory(this.inventory, stack2);
                                            }
                                        }
                                        if (received17 == null) {
                                            this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                                            return;
                                        }
                                        world.func_175656_a(blockPos, Block.func_149634_a((Item)received17.func_77973_b()).func_176203_a(dir));
                                        amount -= 1.6f;
                                        if (!(amount <= 0.0f)) continue;
                                        return;
                                    }
                                    if (!world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}) || !world.func_175655_b(blockPos, false) || !((amount -= 1.0f) <= 0.0f)) continue;
                                    return;
                                }
                                ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                                if (OreDictionary.containsMatch((boolean)false, AutoRecipes.stone, (ItemStack[])new ItemStack[]{target}) || block == Blocks.field_180397_cI || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                                int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.stone);
                                if (found < 0) {
                                    found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_180397_cI));
                                }
                                if (found < 0) {
                                    this.complain(world, "tile.founder.building.msg.stone", new Object[0]);
                                    return;
                                }
                                item = this.inventory.func_70301_a(found).func_77946_l();
                                item.field_77994_a = 1;
                                received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                                if (received == null) {
                                    received = this.requestItem(world, pos, item);
                                }
                                if (received == null) {
                                    this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                                    return;
                                }
                                world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176203_a(received.func_77960_j()));
                                amount -= 1.6f;
                                if (!(amount <= 0.0f)) continue;
                                return;
                            }
                            if ((x - 4) % 16 == 0 || (x - 11) % 16 == 0) {
                                int dir;
                                if (block == Blocks.field_150390_bg) continue;
                                int n = dir = (x - 4) % 16 == 0 ? 1 : 0;
                                if ((z - 0) % 16 == 0) {
                                    dir = 2;
                                } else if ((z - 15) % 16 == 0) {
                                    dir = 3;
                                }
                                ItemStack received18 = UtilInventory.findItem(this.inventory, stonebrick_stairs);
                                if (received18 == null && (stack = AutoRecipes.make4StonebrickStairsFromStonebrick(world, pos, this, this.inventory)) != null) {
                                    received18 = stack.func_77979_a(1);
                                    if (stack.field_77994_a > 0) {
                                        UtilInventory.addItemToInventory(this.inventory, stack);
                                    }
                                }
                                if (received18 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                                    return;
                                }
                                world.func_175656_a(blockPos, Block.func_149634_a((Item)received18.func_77973_b()).func_176203_a(dir));
                                amount -= 1.6f;
                                if (!(amount <= 0.0f)) continue;
                                return;
                            }
                            if (x > this.xStart + 4 && x < this.xEnd - 4) {
                                ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                                if (block == Blocks.field_150333_U || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                                ItemStack received19 = UtilInventory.findItemMeta(this.inventory, cobblestone_slab);
                                if (received19 == null && (stack = AutoRecipes.make2CobblestoneSlabFromCobblestone(world, pos, this, this.inventory)) != null) {
                                    received19 = stack.func_77979_a(1);
                                    if (stack.field_77994_a > 0) {
                                        UtilInventory.addItemToInventory(this.inventory, stack);
                                    }
                                }
                                if (received19 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]);
                                    return;
                                }
                                world.func_175656_a(blockPos, Block.func_149634_a((Item)received19.func_77973_b()).func_176203_a(received19.func_77960_j()));
                                amount -= 1.6f;
                                if (!(amount <= 0.0f)) continue;
                                return;
                            }
                            if (!((z - 0) % 16 != 0 && (z - 15) % 16 != 0 || (x - 3) % 16 != 0 && (x - 12) % 16 != 0)) {
                                ItemStack stack3;
                                if (block == Blocks.field_150390_bg) continue;
                                ItemStack received20 = UtilInventory.findItem(this.inventory, stonebrick_stairs);
                                if (received20 == null && (stack3 = AutoRecipes.make4StonebrickStairsFromStonebrick(world, pos, this, this.inventory)) != null) {
                                    received20 = stack3.func_77979_a(1);
                                    if (stack3.field_77994_a > 0) {
                                        UtilInventory.addItemToInventory(this.inventory, stack3);
                                    }
                                }
                                if (received20 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                                    return;
                                }
                                world.func_175656_a(blockPos, Block.func_149634_a((Item)received20.func_77973_b()).func_176203_a((x - 3) % 16 == 0 ? 1 : 0));
                                amount -= 1.6f;
                                if (!(amount <= 0.0f)) continue;
                                return;
                            }
                            if (world.func_180495_p(blockPos).func_185904_a() != Material.field_151579_a) continue;
                            ItemStack received21 = UtilInventory.findItems(this.inventory, dirt, sand);
                            if (received21 == null && (received21 = this.requestItem(world, pos, dirt)) == null) {
                                received21 = this.requestItem(world, pos, sand);
                            }
                            if (received21 == null) {
                                this.complainResult(world, lastResult, "%s/%s", new TextComponentTranslation(Blocks.field_150346_d.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Blocks.field_150354_m.func_149739_a() + ".name", new Object[0]));
                                return;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received21.func_77973_b()).func_176223_P());
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        if (z % 16 == 0 || (z - 1) % 16 == 0 || (z - 14) % 16 == 0 || (z - 15) % 16 == 0 || cart && x % 16 != 0 && (x - 15) % 16 != 0 && ((z - 2) % 16 == 0 || (z - 3) % 16 == 0 || (z - 12) % 16 == 0 || (z - 13) % 16 == 0)) {
                            if (cart && (((z - 1) % 16 == 0 || (z - 2) % 16 == 0) && x > this.xStart + 1 && x < this.xStart + 7 || ((z - 14) % 16 == 0 || (z - 13) % 16 == 0) && x > this.xEnd - 7 && x < this.xEnd - 1)) {
                                ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                                if ((x - 2) % 16 == 0 || (x - 13) % 16 == 0) {
                                    if (block == Blocks.field_150390_bg) continue;
                                    int dir = x < this.xStart + 8 ? 1 : 0;
                                    received17 = UtilInventory.findItem(this.inventory, stonebrick_stairs);
                                    if (received17 == null && (stack2 = AutoRecipes.make4StonebrickStairsFromStonebrick(world, pos, this, this.inventory)) != null) {
                                        received17 = stack2.func_77979_a(1);
                                        if (stack2.field_77994_a > 0) {
                                            UtilInventory.addItemToInventory(this.inventory, stack2);
                                        }
                                    }
                                    if (received17 == null) {
                                        this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                                        return;
                                    }
                                    world.func_175656_a(blockPos, Block.func_149634_a((Item)received17.func_77973_b()).func_176203_a(dir));
                                    amount -= 1.6f;
                                    if (!(amount <= 0.0f)) continue;
                                    return;
                                }
                                if (!world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}) || !world.func_175655_b(blockPos, false) || !((amount -= 1.0f) <= 0.0f)) continue;
                                return;
                            }
                            ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (OreDictionary.containsMatch((boolean)false, AutoRecipes.stone, (ItemStack[])new ItemStack[]{target}) || block == Blocks.field_180397_cI || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                            int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.stone);
                            if (found < 0) {
                                found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_180397_cI));
                            }
                            if (found < 0) {
                                this.complain(world, "tile.founder.building.msg.stone", new Object[0]);
                                return;
                            }
                            item = this.inventory.func_70301_a(found).func_77946_l();
                            item.field_77994_a = 1;
                            received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                            if (received == null) {
                                received = this.requestItem(world, pos, item);
                            }
                            if (received == null) {
                                this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176203_a(received.func_77960_j()));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        if ((z - 4) % 16 == 0 || (z - 11) % 16 == 0) {
                            int dir;
                            if (block == Blocks.field_150390_bg) continue;
                            int n = dir = (z - 4) % 16 == 0 ? 3 : 2;
                            if ((x - 0) % 16 == 0) {
                                dir = 0;
                            } else if ((x - 15) % 16 == 0) {
                                dir = 1;
                            }
                            ItemStack received22 = UtilInventory.findItem(this.inventory, stonebrick_stairs);
                            if (received22 == null && (stack = AutoRecipes.make4StonebrickStairsFromStonebrick(world, pos, this, this.inventory)) != null) {
                                received22 = stack.func_77979_a(1);
                                if (stack.field_77994_a > 0) {
                                    UtilInventory.addItemToInventory(this.inventory, stack);
                                }
                            }
                            if (received22 == null) {
                                this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received22.func_77973_b()).func_176203_a(dir));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        if (z > this.zStart + 4 && z < this.zEnd - 4) {
                            ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (block == Blocks.field_150333_U || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                            ItemStack received23 = UtilInventory.findItemMeta(this.inventory, cobblestone_slab);
                            if (received23 == null && (stack = AutoRecipes.make2CobblestoneSlabFromCobblestone(world, pos, this, this.inventory)) != null) {
                                received23 = stack.func_77979_a(1);
                                if (stack.field_77994_a > 0) {
                                    UtilInventory.addItemToInventory(this.inventory, stack);
                                }
                            }
                            if (received23 == null) {
                                this.complainResult(world, lastResult, Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received23.func_77973_b()).func_176203_a(received23.func_77960_j()));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        if (!((x - 0) % 16 != 0 && (x - 15) % 16 != 0 || (z - 3) % 16 != 0 && (z - 12) % 16 != 0)) {
                            ItemStack stack4;
                            if (block == Blocks.field_150390_bg) continue;
                            ItemStack received24 = UtilInventory.findItem(this.inventory, stonebrick_stairs);
                            if (received24 == null && (stack4 = AutoRecipes.make4StonebrickStairsFromStonebrick(world, pos, this, this.inventory)) != null) {
                                received24 = stack4.func_77979_a(1);
                                if (stack4.field_77994_a > 0) {
                                    UtilInventory.addItemToInventory(this.inventory, stack4);
                                }
                            }
                            if (received24 == null) {
                                this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received24.func_77973_b()).func_176203_a((z - 3) % 16 == 0 ? 3 : 2));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        if (world.func_180495_p(blockPos).func_185904_a() != Material.field_151579_a) continue;
                        ItemStack received25 = UtilInventory.findItems(this.inventory, dirt, sand);
                        if (received25 == null && (received25 = this.requestItem(world, pos, dirt)) == null) {
                            received25 = this.requestItem(world, pos, sand);
                        }
                        if (received25 == null) {
                            this.complainResult(world, lastResult, "%s/%s", new TextComponentTranslation(Blocks.field_150346_d.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Blocks.field_150354_m.func_149739_a() + ".name", new Object[0]));
                            return;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)received25.func_77973_b()).func_176223_P());
                        amount -= 1.6f;
                        if (!(amount <= 0.0f)) continue;
                        return;
                    }
                    if (y < pos.func_177956_o()) continue;
                    if (!(y >= this.yEnd || (x - 3) % 16 != 0 && (x - 12) % 16 != 0 || (z - 3) % 16 != 0 && (z - 12) % 16 != 0)) {
                        if (y == this.yEnd - 1) {
                            ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (block == Blocks.field_150426_aN || block == Blocks.field_180398_cJ || block == Blocks.field_150478_aa || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                            int found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150426_aN));
                            if (found < 0) {
                                found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_180398_cJ));
                            }
                            if (found < 0) {
                                found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150478_aa));
                            }
                            if (found < 0) {
                                light = new TextComponentTranslation("%s/%s/%s", new Object[]{new TextComponentTranslation(Blocks.field_150426_aN.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Blocks.field_180398_cJ.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Blocks.field_150478_aa.func_149739_a() + ".name", new Object[0])});
                                this.complain(world, "tile.founder.building.msg.light", light);
                                return;
                            }
                            item = this.inventory.func_70301_a(found).func_77946_l();
                            item.field_77994_a = 1;
                            received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                            if (received == null && (received = this.requestItem(world, pos, item)) == null && item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) && (torches = AutoRecipes.make8TorchesFromCoalAndPlanks(world, pos, this, this.inventory)) != null) {
                                received = torches.func_77979_a(1);
                                if (torches.field_77994_a > 0) {
                                    UtilInventory.addItemToInventory(this.inventory, torches);
                                }
                            }
                            if (received == null) {
                                this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176203_a(0));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return;
                        }
                        ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                        if (block instanceof BlockFence || block == Blocks.field_150411_aY || block == Blocks.field_150410_aZ || block == Blocks.field_185764_cQ || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                        ItemStack received26 = UtilInventory.findItems(this.inventory, oakFence, spruceFence, birchFence, jungleFence, acaciaFence, darkoakFence, netherbrickFence, ironRod, glassRod, endRod);
                        if (received26 == null && (stack = AutoRecipes.make3FenceFromPlanks(world, pos, this, this.inventory)) != null) {
                            received26 = stack.func_77979_a(1);
                            if (stack.field_77994_a > 0) {
                                UtilInventory.addItemToInventory(this.inventory, stack);
                            }
                        }
                        if (received26 == null) {
                            this.complainResult(world, lastResult, "tile.wood.name", new Object[0]);
                            return;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)received26.func_77973_b()).func_176203_a(received26.func_77960_j()));
                        amount -= 1.6f;
                        if (!(amount <= 0.0f)) continue;
                        return;
                    }
                    if (cart && y == pos.func_177956_o() && (facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH) && (x < this.xStart + 4 && z > this.zStart + ((x - 1) % 16 == 0 || (x - 2) % 16 == 0 ? 6 : 3) && z < this.zEnd - 7 || x > this.xEnd - 4 && z < this.zEnd - ((x - 14) % 16 == 0 || (x - 13) % 16 == 0 ? 6 : 3) && z > this.zStart + 7)) {
                        ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                        if (block instanceof BlockFence || block == Blocks.field_150411_aY || block == Blocks.field_150410_aZ || block == Blocks.field_185764_cQ || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                        ItemStack received27 = UtilInventory.findItems(this.inventory, oakFence, spruceFence, birchFence, jungleFence, acaciaFence, darkoakFence, netherbrickFence, ironRod, glassRod, endRod);
                        if (received27 == null && (stack = AutoRecipes.make3FenceFromPlanks(world, pos, this, this.inventory)) != null) {
                            received27 = stack.func_77979_a(1);
                            if (stack.field_77994_a > 0) {
                                UtilInventory.addItemToInventory(this.inventory, stack);
                            }
                        }
                        if (received27 == null) {
                            this.complainResult(world, lastResult, "tile.wood.name", new Object[0]);
                            return;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)received27.func_77973_b()).func_176203_a(received27.func_77960_j()));
                        amount -= 1.6f;
                        if (!(amount <= 0.0f)) continue;
                        return;
                    }
                    if (cart && y == pos.func_177956_o() && (facing == EnumFacing.EAST || facing == EnumFacing.WEST) && (z < this.zStart + 4 && x > this.xStart + ((z - 1) % 16 == 0 || (z - 2) % 16 == 0 ? 6 : 3) && x < this.xEnd - 7 || z > this.zEnd - 4 && x < this.xEnd - ((z - 14) % 16 == 0 || (z - 13) % 16 == 0 ? 6 : 3) && x > this.xStart + 7)) {
                        ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                        if (block instanceof BlockFence || block == Blocks.field_150411_aY || block == Blocks.field_150410_aZ || block == Blocks.field_185764_cQ || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                        ItemStack received28 = UtilInventory.findItems(this.inventory, oakFence, spruceFence, birchFence, jungleFence, acaciaFence, darkoakFence, netherbrickFence, ironRod, glassRod, endRod);
                        if (received28 == null && (stack = AutoRecipes.make3FenceFromPlanks(world, pos, this, this.inventory)) != null) {
                            received28 = stack.func_77979_a(1);
                            if (stack.field_77994_a > 0) {
                                UtilInventory.addItemToInventory(this.inventory, stack);
                            }
                        }
                        if (received28 == null) {
                            this.complainResult(world, lastResult, "tile.wood.name", new Object[0]);
                            return;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)received28.func_77973_b()).func_176203_a(received28.func_77960_j()));
                        amount -= 1.6f;
                        if (!(amount <= 0.0f)) continue;
                        return;
                    }
                    ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                    if (!world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}) || !world.func_175655_b(blockPos, false) || !((amount -= 1.0f) <= 0.0f)) continue;
                    return;
                }
            }
        }
        this.complain(world, "tile.founder.msg.complete", new Object[0]);
    }
}

