/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.inventory.AutoRecipes;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.oredict.OreDictionary;

public class BlockRanch
extends BlockFounder {
    private static final int MIN_FENCE = 15;
    private static final int MAX_FENCE = 20;
    private static final int MIN_HERD = 10;
    private static final int MAX_HERD = 15;
    private static final ItemStack carrot = new ItemStack(Items.field_151172_bF);
    private static final ItemStack wheat = new ItemStack(Items.field_151015_O);
    private static final ItemStack wheat_seeds = new ItemStack(Items.field_151014_N);
    private static final ItemStack oakFence = new ItemStack(Blocks.field_180407_aO);
    private static final ItemStack spruceFence = new ItemStack(Blocks.field_180408_aP);
    private static final ItemStack birchFence = new ItemStack(Blocks.field_180404_aQ);
    private static final ItemStack jungleFence = new ItemStack(Blocks.field_180403_aR);
    private static final ItemStack acaciaFence = new ItemStack(Blocks.field_180405_aT);
    private static final ItemStack darkoakFence = new ItemStack(Blocks.field_180406_aS);
    private static final ItemStack dirt = new ItemStack(Blocks.field_150346_d);
    private static List<String> feed = new ArrayList<String>();

    public BlockRanch() {
        super(8, -8, 32);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180645_a(world, pos, state, rand);
        this.gatherDrops(world);
        if (world.func_175640_z(pos)) {
            return;
        }
        if (this.chance <= 0.1f && !this.eat(world, pos, 2, 0.0f)) {
            return;
        }
        if (world.func_72820_D() % 24000L >= 12000L) {
            return;
        }
        if (UtilInventory.isSlotsFull(this.inventory)) {
            return;
        }
        if (this.buildFence(world, pos, rand.nextInt(6) + 15)) {
            this.herdAnimals(world, pos, rand.nextInt(6) + 10);
            this.breedAnimals(world, pos);
            this.slaughterAnimals(world, pos, 32);
        }
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        ChunkPos p = chunk.func_76632_l();
        AxisAlignedBB bb = BlockRanch.calculateBorders(p, pos, this.lotSize, this.minHeight, this.maxHeight);
        BlockRanch.drawBorders(world, pos, bb);
        int grazable = 0;
        int xStart = p.func_180334_c() + (p.func_180334_c() % 32 == 0 ? 0 : -16);
        int xEnd = p.func_180332_e() + ((p.func_180332_e() + 1) % 32 == 0 ? 0 : 16);
        int zStart = p.func_180333_d() + (p.func_180333_d() % 32 == 0 ? 0 : -16);
        int zEnd = p.func_180330_f() + ((p.func_180330_f() + 1) % 32 == 0 ? 0 : 16);
        for (int y = 255; y >= 1; --y) {
            for (int x = xStart; x <= xEnd; ++x) {
                for (int z = zStart; z <= zEnd; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (block instanceof IFounder) {
                        IFounder lot = (IFounder)block;
                        AxisAlignedBB other = BlockRanch.calculateBorders(world.func_175726_f(blockPos).func_76632_l(), blockPos, lot.getPlotSize(), lot.getPlotMinHeight(), lot.getPlotMaxHeight());
                        if (bb.func_72326_a(other)) {
                            this.complain(world, "tile.founder.msg.occupied", new Object[0]);
                            return false;
                        }
                    }
                    if (x <= (int)bb.field_72340_a || x >= (int)bb.field_72336_d || z <= (int)bb.field_72339_c || z >= (int)bb.field_72334_f || !Block.func_149680_a((Block)block, (Block)Blocks.field_150349_c)) continue;
                    ++grazable;
                }
            }
        }
        if (grazable < 128) {
            this.complain(world, "tile.founder.ranch.msg.noPlace", grazable, 128);
            return false;
        }
        return true;
    }

    private boolean buildFence(World world, BlockPos pos, int amount) {
        if (amount <= 0) {
            return false;
        }
        int cowX = this.xStart + 8;
        int cowZ = this.zStart + 8;
        int sheepX = this.xEnd - 8;
        int sheepZ = this.zStart + 8;
        int chickenX = this.xStart + 8;
        int chickenZ = this.zEnd - 8;
        int horseX = this.xEnd - 8;
        int horseZ = this.zEnd - 8;
        int bottom = Math.max(this.yStart, pos.func_177956_o() - 1);
        int top = Math.min(this.yEnd, pos.func_177956_o() + 4);
        for (int y = bottom; y <= top; ++y) {
            for (int x = this.xStart + 4; x <= this.xEnd - 4; ++x) {
                for (int z = this.zStart + 4; z <= this.zEnd - 4; ++z) {
                    ItemStack received;
                    ItemStack target;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (y > pos.func_177956_o()) {
                        target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                        if (!world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}) || !world.func_175655_b(blockPos, false) || --amount > 0) continue;
                        return false;
                    }
                    if (y < pos.func_177956_o()) {
                        if (!world.func_175623_d(blockPos) && !world.func_180495_p(blockPos).func_185904_a().func_76224_d() && world.func_180495_p(blockPos).func_185904_a().func_76220_a()) continue;
                        received = UtilInventory.findItem(this.inventory, dirt);
                        if (received == null) {
                            received = this.requestItem(world, pos, dirt);
                        }
                        if (received == null) {
                            this.complainResult(world, lastResult, Blocks.field_150346_d.func_149739_a() + ".name", new Object[0]);
                            return false;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176223_P());
                        if (--amount > 0) continue;
                        return false;
                    }
                    if (block instanceof BlockFounder) continue;
                    if (!((x != cowX - 4 && x != cowX + 4 && x != sheepX - 4 && x != sheepX + 4 || z > cowZ + 4 && z < chickenZ - 4) && (z != cowZ - 4 && z != cowZ + 4 && z != chickenZ - 4 && z != chickenZ + 4 || x > cowX + 4 && x < sheepX - 4))) {
                        ItemStack stack;
                        if (amount <= 0 || block instanceof BlockFence || block instanceof BlockFenceGate) continue;
                        received = UtilInventory.findItems(this.inventory, oakFence, spruceFence, birchFence, jungleFence, acaciaFence, darkoakFence);
                        if (received == null && (stack = AutoRecipes.make12FenceFromLogs(world, pos, this, this.inventory)) != null) {
                            received = stack.func_77979_a(1);
                            if (stack.field_77994_a > 0) {
                                UtilInventory.addItemToInventory(this.inventory, stack);
                            }
                        }
                        if (received == null) {
                            this.complainResult(world, lastResult, "tile.log.name", new Object[0]);
                            return false;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176223_P());
                        if (--amount > 0) continue;
                        return false;
                    }
                    target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                    if (!world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}) || !world.func_175655_b(blockPos, false) || --amount > 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void herdAnimals(World world, BlockPos pos, int amount) {
        if (amount <= 0) {
            return;
        }
        int cowX = this.xStart + 8;
        int cowZ = this.zStart + 8;
        int sheepX = this.xEnd - 8;
        int sheepZ = this.zStart + 8;
        int chickenX = this.xStart + 8;
        int chickenZ = this.zEnd - 8;
        int horseX = this.xEnd - 8;
        int horseZ = this.zEnd - 8;
        List list = world.func_72872_a(EntityAnimal.class, new AxisAlignedBB((double)this.xStart, (double)this.yStart, (double)this.zStart, (double)this.xEnd, (double)this.yEnd, (double)this.zEnd));
        int moved = 0;
        for (int i = 0; i < list.size() && moved < amount; ++i) {
            EntityAnimal animal = (EntityAnimal)list.get(i);
            if (animal.func_110167_bD() || animal.func_145818_k_() || animal.func_184207_aI()) continue;
            if (animal instanceof EntityCow || animal instanceof EntityPig) {
                if (!(animal.field_70165_t < (double)(cowX - 4) || animal.field_70165_t > (double)(cowX + 4) || animal.field_70161_v < (double)(cowZ - 4)) && !(animal.field_70161_v > (double)(cowZ + 4))) continue;
                animal.func_174828_a(new BlockPos(cowX, pos.func_177956_o(), cowZ), animal.field_70177_z, animal.field_70125_A);
                ++moved;
                continue;
            }
            if (animal instanceof EntitySheep || animal instanceof EntityRabbit) {
                if (!(animal.field_70165_t < (double)(sheepX - 4) || animal.field_70165_t > (double)(sheepX + 4) || animal.field_70161_v < (double)(sheepZ - 4)) && !(animal.field_70161_v > (double)(sheepZ + 4))) continue;
                animal.func_174828_a(new BlockPos(sheepX, pos.func_177956_o(), sheepZ), animal.field_70177_z, animal.field_70125_A);
                ++moved;
                continue;
            }
            if (animal instanceof EntityChicken) {
                if (!(animal.field_70165_t < (double)(chickenX - 4) || animal.field_70165_t > (double)(chickenX + 4) || animal.field_70161_v < (double)(chickenZ - 4)) && !(animal.field_70161_v > (double)(chickenZ + 4))) continue;
                animal.func_174828_a(new BlockPos(chickenX, pos.func_177956_o(), chickenZ), animal.field_70177_z, animal.field_70125_A);
                ++moved;
                continue;
            }
            if (!(animal instanceof EntityHorse) || !(animal.field_70165_t < (double)(horseX - 4) || animal.field_70165_t > (double)(horseX + 4) || animal.field_70161_v < (double)(horseZ - 4)) && !(animal.field_70161_v > (double)(horseZ + 4))) continue;
            animal.func_174828_a(new BlockPos(horseX, pos.func_177956_o(), horseZ), animal.field_70177_z, animal.field_70125_A);
            ++moved;
        }
    }

    private void breedAnimals(World world, BlockPos pos) {
        int cowX = this.xStart + 8;
        int cowZ = this.zStart + 8;
        int sheepX = this.xEnd - 8;
        int sheepZ = this.zStart + 8;
        int chickenX = this.xStart + 8;
        int chickenZ = this.zEnd - 8;
        int horseX = this.xEnd - 8;
        int horseZ = this.zEnd - 8;
        List[] animals = new List[]{world.func_72872_a(EntityCow.class, new AxisAlignedBB((double)(cowX - 4), (double)this.yStart, (double)(cowZ - 4), (double)(cowX + 4), (double)this.yEnd, (double)(cowZ + 4))), world.func_72872_a(EntitySheep.class, new AxisAlignedBB((double)(sheepX - 4), (double)this.yStart, (double)(sheepZ - 4), (double)(sheepX + 4), (double)this.yEnd, (double)(sheepZ + 4))), world.func_72872_a(EntityPig.class, new AxisAlignedBB((double)(cowX - 4), (double)this.yStart, (double)(cowZ - 4), (double)(cowX + 4), (double)this.yEnd, (double)(cowZ + 4))), world.func_72872_a(EntityRabbit.class, new AxisAlignedBB((double)(sheepX - 4), (double)this.yStart, (double)(sheepZ - 4), (double)(sheepX + 4), (double)this.yEnd, (double)(sheepZ + 4))), world.func_72872_a(EntityChicken.class, new AxisAlignedBB((double)(chickenX - 4), (double)this.yStart, (double)(chickenZ - 4), (double)(chickenX + 4), (double)this.yEnd, (double)(chickenZ + 4)))};
        feed.clear();
        for (int x = 0; x < animals.length; ++x) {
            int eligable;
            if (animals[x].size() <= 1 || animals[x].size() >= 32 || (eligable = BlockRanch.getEligableAdultCount(animals[x])) < 2) continue;
            for (int n = 0; n < animals[x].size() && eligable > 0; ++n) {
                EntityAnimal animal = (EntityAnimal)animals[x].get(n);
                if (animal.func_70874_b() != 0 || animal.func_70880_s()) continue;
                ItemStack received = null;
                if (animal instanceof EntityRabbit || animal instanceof EntityPig) {
                    received = UtilInventory.findItem(this.inventory, carrot);
                    if (received == null) {
                        received = this.requestItem(world, pos, carrot);
                    }
                    if (received == null && !feed.contains(Items.field_151172_bF.func_77658_a() + ".name")) {
                        feed.add(Items.field_151172_bF.func_77658_a() + ".name");
                    }
                } else if (animal instanceof EntityCow || animal instanceof EntitySheep) {
                    received = UtilInventory.findItem(this.inventory, wheat);
                    if (received == null) {
                        received = this.requestItem(world, pos, wheat);
                    }
                    if (received == null && !feed.contains(Items.field_151015_O.func_77658_a() + ".name")) {
                        feed.add(Items.field_151015_O.func_77658_a() + ".name");
                    }
                } else if (animal instanceof EntityChicken) {
                    received = UtilInventory.findItem(this.inventory, wheat_seeds);
                    if (received == null) {
                        received = this.requestItem(world, pos, wheat_seeds);
                    }
                    if (received == null && !feed.contains(Items.field_151014_N.func_77658_a() + ".name")) {
                        feed.add(Items.field_151014_N.func_77658_a() + ".name");
                    }
                }
                if (received == null) continue;
                animal.func_146082_f(null);
                --eligable;
            }
        }
        if (feed.size() > 0) {
            String feedStr = "";
            Object[] args = new Object[feed.size()];
            for (int i = 0; i < feed.size(); ++i) {
                feedStr = feedStr + " %s,";
                args[i] = new TextComponentTranslation(feed.get(i), new Object[0]);
            }
            feedStr = feedStr.substring(1, feedStr.length() - 1);
            this.complainResult(world, lastResult, feedStr, args);
        }
    }

    private void slaughterAnimals(World world, BlockPos pos, int amount) {
        if (amount <= 0) {
            return;
        }
        HashMap<Class, Integer> population = new HashMap<Class, Integer>();
        List animals = world.func_72872_a(EntityAnimal.class, new AxisAlignedBB((double)this.xStart, (double)this.yStart, (double)this.zStart, (double)this.xEnd, (double)this.yEnd, (double)this.zEnd));
        BlockRanch.countPopulation(population, animals);
        for (int n = 0; n < animals.size(); ++n) {
            EntityAnimal animal = (EntityAnimal)animals.get(n);
            if (animal instanceof EntityHorse || animal.func_70874_b() != 0 || animal.func_70880_s() || (Integer)population.get(animal.getClass()) <= 3) continue;
            animal.func_70097_a(DamageSource.field_76377_j, 10.0f);
            int num = (Integer)population.get(animal.getClass()) - 1;
            if (num < 0) {
                num = 0;
            }
            population.put(animal.getClass(), num);
            if (--amount > 0) continue;
            return;
        }
    }

    private static final int getEligableAdultCount(List<EntityAnimal> list) {
        int count = 0;
        for (int i = 0; i < list.size(); ++i) {
            EntityAnimal animal = list.get(i);
            if (animal.func_70874_b() != 0 || animal.func_70880_s()) continue;
            ++count;
        }
        return count;
    }

    private static final void countPopulation(Map<Class, Integer> population, List<EntityAnimal> list) {
        for (int i = 0; i < list.size(); ++i) {
            EntityAnimal animal = list.get(i);
            Integer n = population.get(animal.getClass());
            population.put(animal.getClass(), n == null ? 1 : n + 1);
        }
    }
}

