/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.CitiesMod;
import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.inventory.AutoRecipes;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.stats.StatBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockQuarry
extends BlockFounder {
    private static final float PLAYER_TIME = 0.45f;
    private static final float TICK_TIME = 68.27f;

    public BlockQuarry() {
        super(4, -12, 32);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180645_a(world, pos, state, rand);
        this.gatherDrops(world);
        if (world.func_175640_z(pos)) {
            return;
        }
        if (this.chance <= 0.1f && !this.eat(world, pos, 2, 0.0f)) {
            return;
        }
        if (world.func_72820_D() % 24000L >= 12000L) {
            return;
        }
        if (UtilInventory.isSlotsFull(this.inventory)) {
            return;
        }
        this.digQuarry(world, pos, 68.27f);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (placer instanceof EntityPlayer) {
            ((EntityPlayer)placer).func_71064_a((StatBase)CitiesMod.cities_achievements[6], 1);
        }
    }

    private void digQuarry(World world, BlockPos pos, float amount) {
        if (amount <= 0.0f) {
            return;
        }
        for (int y = this.yEnd; y >= this.yStart; --y) {
            for (int x = this.xStart; x <= this.xEnd; ++x) {
                for (int z = this.zStart; z <= this.zEnd; ++z) {
                    if (x == pos.func_177958_n() && z == pos.func_177952_p()) continue;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (world.func_175623_d(blockPos) || block == Blocks.field_150468_ap || block == Blocks.field_150415_aT || block == Blocks.field_150478_aa) continue;
                    if (Block.func_149680_a((Block)block, (Block)Blocks.field_150355_j)) {
                        this.complain(world, "tile.founder.mine.msg.stop", y, new TextComponentTranslation(block.func_149739_a() + ".name", new Object[0]));
                        return;
                    }
                    if (block.func_176200_f((IBlockAccess)world, blockPos)) {
                        world.func_175655_b(blockPos, false);
                        amount -= 0.45f;
                        if (!(amount <= 0.0f)) continue;
                        return;
                    }
                    Item toolPrim = null;
                    Item toolAlt = null;
                    Item toolAlt2 = null;
                    ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                    if (OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}) || OreDictionary.containsMatch((boolean)false, AutoRecipes.ores, (ItemStack[])new ItemStack[]{target})) {
                        if (block.getHarvestTool(world.func_180495_p(blockPos)) == null || block.getHarvestTool(world.func_180495_p(blockPos)).equals("pickaxe")) {
                            toolPrim = Items.field_151046_w;
                            if (block.getHarvestLevel(world.func_180495_p(blockPos)) <= 2) {
                                toolAlt = Items.field_151035_b;
                            }
                            if (block.getHarvestLevel(world.func_180495_p(blockPos)) <= 1) {
                                toolAlt2 = Items.field_151050_s;
                            }
                        } else if (block.getHarvestTool(world.func_180495_p(blockPos)).equals("shovel")) {
                            toolPrim = Items.field_151047_v;
                            if (block.getHarvestLevel(world.func_180495_p(blockPos)) <= 2) {
                                toolAlt = Items.field_151037_a;
                            }
                            if (block.getHarvestLevel(world.func_180495_p(blockPos)) <= 1) {
                                toolAlt2 = Items.field_151051_r;
                            }
                        }
                    }
                    if (toolPrim == null && toolAlt == null && toolAlt2 == null) {
                        if (y >= pos.func_177956_o() - 1) continue;
                        this.complain(world, "tile.founder.mine.msg.stop", y, new TextComponentTranslation(block.func_149739_a() + ".name", new Object[0]));
                        return;
                    }
                    int found = -1;
                    found = UtilInventory.findItem(this.inventory, toolPrim);
                    if (found < 0 && toolAlt != null && (found = UtilInventory.findItem(this.inventory, toolAlt)) < 0 && toolAlt2 != null) {
                        found = UtilInventory.findItem(this.inventory, toolAlt2);
                    }
                    if (found < 0) {
                        ItemStack received = null;
                        received = this.requestItem(world, pos, new ItemStack(toolPrim));
                        if (received == null && toolAlt != null && (received = this.requestItem(world, pos, new ItemStack(toolAlt))) == null && toolAlt2 != null) {
                            received = this.requestItem(world, pos, new ItemStack(toolAlt2));
                        }
                        if (received != null) {
                            UtilInventory.addItemToInventory(this.inventory, received);
                            found = UtilInventory.findItem(this.inventory, received.func_77973_b());
                        }
                    }
                    if (found < 0) {
                        this.complain(world, "tile.founder.mine.msg.tools", new TextComponentTranslation(block.func_149739_a() + ".name", new Object[0]));
                        return;
                    }
                    float time = world.func_180495_p(blockPos).func_185887_b(world, blockPos) * 1.5f / ((ItemTool)this.inventory.func_70301_a(found).func_77973_b()).func_150913_i().func_77998_b();
                    time += 0.45f;
                    if (this.inventory.func_70301_a(found).func_96631_a(1, world.field_73012_v)) {
                        this.inventory.func_70298_a(found, 1);
                    }
                    world.func_175655_b(blockPos, true);
                    amount -= time;
                    if (!(amount <= 0.0f)) continue;
                    return;
                }
            }
        }
        this.complain(world, "tile.founder.msg.complete", new Object[0]);
    }
}

