/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.CitiesMod;
import com.dooglamoo.citiesmod.block.BlockBuilding;
import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.common.Market;
import com.dooglamoo.citiesmod.inventory.AutoRecipes;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import com.dooglamoo.citiesmod.tileentity.TileEntityFounder;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockOffice
extends BlockBuilding {
    private static final int MIN_INVEST = 1000;

    public BlockOffice() {
        super(15, -1, 8, 1000, 2);
        this.trades.add(Items.field_151014_N);
        this.trades.add(Items.field_151174_bG);
        this.trades.add(Items.field_151172_bF);
        this.trades.add(Items.field_151120_aE);
        this.trades.add(Item.func_150898_a((Block)Blocks.field_150364_r));
        this.trades.add(Item.func_150898_a((Block)Blocks.field_150363_s));
        this.trades.add(Items.field_151034_e);
        this.trades.add(Item.func_150898_a((Block)Blocks.field_150345_g));
        this.trades.add(Items.field_179561_bm);
        this.trades.add(Items.field_179558_bo);
        this.trades.add(Items.field_151076_bf);
        this.trades.add(Items.field_151147_al);
        this.trades.add(Items.field_151082_bd);
        this.trades.add(Items.field_151115_aP);
        this.trades.add(Items.field_151110_aK);
        this.trades.add(Items.field_151008_G);
        this.trades.add(Items.field_151044_h);
        this.trades.add(Item.func_150898_a((Block)Blocks.field_150346_d));
        this.trades.add(Item.func_150898_a((Block)Blocks.field_150351_n));
        this.trades.add(Item.func_150898_a((Block)Blocks.field_150354_m));
        this.trades.add(Item.func_150898_a((Block)Blocks.field_150347_e));
        this.trades.add(Items.field_151007_F);
        this.trades.add(Items.field_151145_ak);
        this.trades.add(Item.func_150898_a((Block)Blocks.field_150327_N));
        this.trades.add(Item.func_150898_a((Block)Blocks.field_150328_O));
        this.trades.add(Item.func_150898_a((Block)Blocks.field_150338_P));
        this.trades.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
        this.trades.add(Items.field_151119_aD);
        this.trades.add(Item.func_150898_a((Block)Blocks.field_150434_aF));
        this.trades.add(Items.field_179555_bs);
        this.trades.add(Items.field_151103_aS);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175640_z(pos)) {
            return;
        }
        super.func_180645_a(world, pos, state, rand);
        this.seller = null;
        this.buyer = null;
        if (this.chance <= 0.1f) {
            if (this.coinPouch == null || this.coinPouch.func_82838_A() < this.MIN_INVESTMENT) {
                // empty if block
            }
            this.collectInvestment(world, pos, this.MIN_INVESTMENT);
            if (!this.eat(world, pos, this.MIN_COMMUNITY, 0.0f)) {
                return;
            }
        }
        if (this.build(world, pos, 68.27f) && !Market.marketDisabled) {
            this.exportGoods(world, pos);
            this.importGoods(world, pos);
        }
    }

    private boolean build(World world, BlockPos pos, float amount) {
        ItemStack woodType = null;
        boolean ladderFill = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150468_ap)) >= 0;
        for (int y = this.yStart; y <= this.yEnd; ++y) {
            for (int x = this.xStart; x <= this.xEnd; ++x) {
                for (int z = this.zStart; z <= this.zEnd; ++z) {
                    ItemStack received;
                    ItemStack item;
                    ItemStack stack;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (y == pos.func_177956_o()) {
                        if (this.seller == null && Block.func_149680_a((Block)block, (Block)CitiesMod.sellerBlock)) {
                            this.seller = (TileEntityFounder)world.func_175625_s(blockPos);
                        }
                        if (this.buyer == null && Block.func_149680_a((Block)block, (Block)CitiesMod.buyerBlock)) {
                            this.buyer = (TileEntityFounder)world.func_175625_s(blockPos);
                        }
                    }
                    if (block instanceof BlockFounder) continue;
                    if (x == this.xStart + 3 || x == this.xStart + 4 || z == this.zStart + 3 || z == this.zStart + 4) {
                        if (y == this.yStart + 1 || y == this.yStart + 2) continue;
                        if (!(y != this.yStart + 3 || x != this.xStart && x != this.xEnd && z != this.zStart && z != this.zEnd || Block.func_149680_a((Block)block, (Block)Blocks.field_150390_bg))) {
                            int dir = 2;
                            if ((x - 15) % 16 == 0 || (x - 7) % 16 == 0) {
                                dir = 1;
                            } else if (x % 16 == 0 || (x - 8) % 16 == 0) {
                                dir = 0;
                            } else if ((z - 15) % 16 == 0 || (z - 7) % 16 == 0) {
                                dir = 3;
                            }
                            ItemStack received2 = UtilInventory.findItem(this.inventory, stonebrick_stairs);
                            if (received2 == null && (stack = AutoRecipes.make4StonebrickStairsFromStonebrick(world, pos, this, this.inventory)) != null) {
                                received2 = stack.func_77979_a(1);
                                if (stack.field_77994_a > 0) {
                                    UtilInventory.addItemToInventory(this.inventory, stack);
                                }
                            }
                            if (received2 == null) {
                                this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                                return false;
                            }
                            world.func_175656_a(blockPos, Blocks.field_150390_bg.func_176203_a(4 | dir));
                            amount -= 1.6f;
                            if (amount <= 0.0f) {
                                return false;
                            }
                        }
                    }
                    if (x < this.xStart + 1 || x > this.xEnd - 1 || z < this.zStart + 1 || z > this.zEnd - 1) continue;
                    if (x == this.xStart + 1 || x == this.xEnd - 1 || z == this.zStart + 1 || z == this.zEnd - 1) {
                        if ((this.yEnd - y) % 4 == 0 || y < this.yStart + 4 || (x - 6) % 16 == 0 || (x - 9) % 16 == 0 || (z - 6) % 16 == 0 || (z - 9) % 16 == 0 || (x == this.xStart + 1 || x == this.xEnd - 1) && (z == this.zStart + 1 || z == this.zEnd - 1)) {
                            ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (block != Blocks.field_150334_T && block != Blocks.field_180388_cO && block != Blocks.field_185770_cW && block != Blocks.field_150373_bw && block != Blocks.field_150322_A && block != Blocks.field_150347_e && block != Blocks.field_150336_V && block != Blocks.field_150417_aV && block != Blocks.field_150385_bj && block != Blocks.field_150371_ca && !OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{target}) && block != Blocks.field_180395_cM && block != Blocks.field_185767_cT && (world.func_180495_p(blockPos).func_185904_a().func_76222_j() || OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}))) {
                                int stone = UtilInventory.findItems(this.inventory, Item.func_150898_a((Block)Blocks.field_150333_U), Item.func_150898_a((Block)Blocks.field_180389_cP), Item.func_150898_a((Block)Blocks.field_185771_cX));
                                int wood = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.slabWood);
                                if (stone < 0 && wood < 0) {
                                    this.complain(world, "tile.founder.building.msg.slab", new Object[0]);
                                    return false;
                                }
                                stone = stone < 0 ? wood : stone;
                                ItemStack itemSlab = this.inventory.func_70301_a(stone);
                                ItemStack received3 = null;
                                List<ItemStack> items = this.getItemFromSlab(world, itemSlab);
                                if (items.isEmpty()) {
                                    this.complain(world, "tile.founder.building.msg.slab", new Object[0]);
                                    return false;
                                }
                                for (ItemStack request : items) {
                                    Block requestBlock = Block.func_149634_a((Item)request.func_77973_b());
                                    if (!Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150348_b) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150322_A) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150347_e) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150336_V) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150417_aV) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150385_bj) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150371_ca) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_180395_cM) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_185767_cT) && !OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{new ItemStack(request.func_77973_b(), 1, Short.MAX_VALUE)})) continue;
                                    received3 = UtilInventory.findItemMetaWithMin(this.inventory, 2, request);
                                    if (received3 == null) {
                                        received3 = this.requestItem(world, pos, request);
                                    }
                                    if (received3 == null) continue;
                                    break;
                                }
                                if (received3 == null) {
                                    this.complainResult(world, lastResult, items.get(0).func_77973_b().func_77667_c(items.get(0)) + ".name", new Object[0]);
                                    return false;
                                }
                                if (received3.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150348_b)) {
                                    world.func_175656_a(blockPos, Blocks.field_150334_T.func_176223_P());
                                } else {
                                    world.func_175656_a(blockPos, Block.func_149634_a((Item)received3.func_77973_b()).func_176203_a(received3.func_77960_j()));
                                }
                                amount -= 1.6f;
                                if (amount <= 0.0f) {
                                    return false;
                                }
                            }
                        } else if (world.func_180495_p(blockPos).func_185904_a() == Material.field_151579_a) {
                            int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.blockGlass);
                            if (found < 0) {
                                this.complain(world, "tile.founder.building.msg.glass", new Object[0]);
                                return false;
                            }
                            ItemStack item2 = this.inventory.func_70301_a(found).func_77946_l();
                            item2.field_77994_a = 1;
                            ItemStack received4 = UtilInventory.findItemMetaWithMin(this.inventory, 2, item2);
                            if (received4 == null) {
                                received4 = this.requestItem(world, pos, item2);
                            }
                            if (received4 == null) {
                                this.complainResult(world, lastResult, item2.func_77973_b().func_77667_c(item2) + ".name", new Object[0]);
                                return false;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received4.func_77973_b()).func_176203_a(received4.func_77960_j()));
                            amount -= 1.6f;
                            if (amount <= 0.0f) {
                                return false;
                            }
                        }
                    }
                    if (x < this.xStart + 2 || x > this.xEnd - 2 || z < this.zStart + 2 || z > this.zEnd - 2) continue;
                    if (!((x - 5) % 16 != 0 && (x - 10) % 16 != 0 || (z - 5) % 16 != 0 && (z - 10) % 16 != 0)) {
                        if (specifyLadder && !ladderFill) continue;
                        ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                        if (block == Blocks.field_150468_ap || block == Blocks.field_150415_aT || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                        ItemStack received5 = UtilInventory.findItemMetaWithMin(this.inventory, 2, ladder);
                        if (received5 == null && (stack = AutoRecipes.make24LaddersFromPlanks(world, pos, this, this.inventory)) != null) {
                            received5 = stack.func_77979_a(1);
                            if (stack.field_77994_a > 0) {
                                UtilInventory.addItemToInventory(this.inventory, stack);
                            }
                        }
                        if (received5 == null) {
                            this.complainResult(world, lastResult, "tile.wood.name", new Object[0]);
                            return false;
                        }
                        world.func_175656_a(blockPos, Blocks.field_150468_ap.func_176203_a((z - 10) % 16 == 0 ? 3 : 2));
                        amount -= 1.6f;
                        if (!(amount <= 0.0f)) continue;
                        return false;
                    }
                    if (y == this.yStart) {
                        ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                        if (!OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{target}) && block != Blocks.field_150468_ap && block != Blocks.field_150415_aT && (world.func_180495_p(blockPos).func_185904_a().func_76222_j() || OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}))) {
                            ItemStack received6;
                            if (woodType == null) {
                                int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.plankWood);
                                if (found < 0) {
                                    this.complain(world, "tile.founder.building.msg.floor", new Object[0]);
                                    return false;
                                }
                                item = this.inventory.func_70301_a(found);
                                woodType = new ItemStack(item.func_77973_b(), 1, item.func_77960_j());
                            }
                            if ((received6 = UtilInventory.findItemMetaWithMin(this.inventory, 2, woodType)) == null) {
                                received6 = this.requestItem(world, pos, woodType);
                            }
                            if (received6 == null) {
                                this.complainResult(world, lastResult, woodType.func_77973_b().func_77667_c(woodType) + ".name", new Object[0]);
                                return false;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)woodType.func_77973_b()).func_176203_a(woodType.func_77960_j()));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return false;
                        }
                        if (woodType != null) continue;
                        woodType = new ItemStack(block, 1, block.func_176201_c(world.func_180495_p(blockPos)));
                        continue;
                    }
                    if ((this.yEnd - y) % 4 == 0) {
                        ItemStack received7;
                        if (!((x - 4) % 16 != 0 && (x - 11) % 16 != 0 || (z - 3) % 16 != 0 && (z - 12) % 16 != 0)) {
                            ItemStack received8;
                            ItemStack item3;
                            int found;
                            ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (OreDictionary.containsMatch((boolean)false, AutoRecipes.blockGlass, (ItemStack[])new ItemStack[]{target}) || block == Blocks.field_150426_aN || block == Blocks.field_180398_cJ || block == Blocks.field_150478_aa || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                            if (y != this.yEnd && world.field_73012_v.nextFloat() <= lightingChance) {
                                ItemStack torches;
                                found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150426_aN));
                                if (found < 0) {
                                    found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_180398_cJ));
                                }
                                if (found < 0) {
                                    found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150478_aa));
                                }
                                if (found < 0) {
                                    TextComponentTranslation light = new TextComponentTranslation("%s/%s/%s", new Object[]{new TextComponentTranslation(Blocks.field_150426_aN.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Blocks.field_180398_cJ.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Blocks.field_150478_aa.func_149739_a() + ".name", new Object[0])});
                                    this.complain(world, "tile.founder.building.msg.light", light);
                                    return false;
                                }
                                item3 = this.inventory.func_70301_a(found).func_77946_l();
                                item3.field_77994_a = 1;
                                received8 = UtilInventory.findItemMetaWithMin(this.inventory, 2, item3);
                                if (received8 == null && (received8 = this.requestItem(world, pos, item3)) == null && item3.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) && (torches = AutoRecipes.make8TorchesFromCoalAndPlanks(world, pos, this, this.inventory)) != null) {
                                    received8 = torches.func_77979_a(1);
                                    if (torches.field_77994_a > 0) {
                                        UtilInventory.addItemToInventory(this.inventory, torches);
                                    }
                                }
                                if (received8 == null) {
                                    this.complainResult(world, lastResult, item3.func_77973_b().func_77667_c(item3) + ".name", new Object[0]);
                                    return false;
                                }
                            } else {
                                found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.blockGlass);
                                if (found < 0) {
                                    this.complain(world, "tile.founder.building.msg.glass", new Object[0]);
                                    return false;
                                }
                                item3 = this.inventory.func_70301_a(found).func_77946_l();
                                item3.field_77994_a = 1;
                                received8 = UtilInventory.findItemMetaWithMin(this.inventory, 2, item3);
                                if (received8 == null) {
                                    received8 = this.requestItem(world, pos, item3);
                                }
                                if (received8 == null) {
                                    this.complainResult(world, lastResult, item3.func_77973_b().func_77667_c(item3) + ".name", new Object[0]);
                                    return false;
                                }
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received8.func_77973_b()).func_176203_a(received8.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) ? 3 : received8.func_77960_j()));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return false;
                        }
                        ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                        if (OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{target}) || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                        if (woodType == null) {
                            int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.plankWood);
                            if (found < 0) {
                                this.complain(world, "tile.founder.building.msg.floor", new Object[0]);
                                return false;
                            }
                            item = this.inventory.func_70301_a(found);
                            woodType = new ItemStack(item.func_77973_b(), 1, item.func_77960_j());
                        }
                        if ((received7 = UtilInventory.findItemMetaWithMin(this.inventory, 2, woodType)) == null) {
                            received7 = this.requestItem(world, pos, woodType);
                        }
                        if (received7 == null) {
                            this.complainResult(world, lastResult, woodType.func_77973_b().func_77667_c(woodType) + ".name", new Object[0]);
                            return false;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)woodType.func_77973_b()).func_176203_a(woodType.func_77960_j()));
                        amount -= 1.6f;
                        if (!(amount <= 0.0f)) continue;
                        return false;
                    }
                    if (y == this.yEnd || y <= this.yStart + 1 || (this.yEnd + 1 - y) % 4 != 0 || (x - 4) % 16 != 0 && (x - 11) % 16 != 0 || (z - 3) % 16 != 0 && (z - 12) % 16 != 0 || !world.func_180495_p(blockPos).func_185904_a().func_76222_j()) continue;
                    if (woodType == null) {
                        int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.plankWood);
                        if (found < 0) {
                            this.complain(world, "tile.founder.building.msg.floor", new Object[0]);
                            return false;
                        }
                        ItemStack item4 = this.inventory.func_70301_a(found);
                        woodType = new ItemStack(item4.func_77973_b(), 1, item4.func_77960_j());
                    }
                    if ((received = UtilInventory.findItemMetaWithMin(this.inventory, 2, woodType)) == null) {
                        received = this.requestItem(world, pos, woodType);
                    }
                    if (received == null) {
                        this.complainResult(world, lastResult, woodType.func_77973_b().func_77667_c(woodType) + ".name", new Object[0]);
                        return false;
                    }
                    world.func_175656_a(blockPos, Block.func_149634_a((Item)woodType.func_77973_b()).func_176203_a(woodType.func_77960_j()));
                    amount -= 1.6f;
                    if (!(amount <= 0.0f)) continue;
                    return false;
                }
            }
        }
        this.addStatsToPlayers(world, 11);
        return true;
    }
}

