/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.CitiesMod;
import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.inventory.AutoRecipes;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.stats.StatBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockMineshaft
extends BlockFounder {
    private static final float PLAYER_TIME = 2.0f;
    private static final float TICK_TIME = 68.27f;
    private static final ItemStack torch = new ItemStack(Blocks.field_150478_aa);
    private static final ItemStack dirt = new ItemStack(Blocks.field_150346_d);
    private static final ItemStack cobblestone = new ItemStack(Blocks.field_150347_e);
    private static final ItemStack ladder = new ItemStack(Blocks.field_150468_ap);

    public BlockMineshaft() {
        super(2, -125, 16);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180645_a(world, pos, state, rand);
        this.gatherDrops(world);
        if (world.func_175640_z(pos)) {
            return;
        }
        if (this.chance <= 0.1f && !this.eat(world, pos, 2, 0.0f)) {
            return;
        }
        if (world.func_72820_D() % 24000L >= 12000L) {
            return;
        }
        if (UtilInventory.isSlotsFull(this.inventory)) {
            return;
        }
        this.digMine(world, pos, 68.27f);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (placer instanceof EntityPlayer) {
            ((EntityPlayer)placer).func_71064_a((StatBase)CitiesMod.cities_achievements[5], 1);
        }
    }

    private void digMine(World world, BlockPos pos, float amount) {
        if (amount <= 0.0f) {
            return;
        }
        for (int y = this.yEnd; y >= this.yStart; --y) {
            for (int x = this.xStart; x <= this.xEnd; ++x) {
                for (int z = this.zStart; z <= this.zEnd; ++z) {
                    ItemStack target;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (block instanceof BlockFounder) continue;
                    if (Block.func_149680_a((Block)block, (Block)Blocks.field_150357_h)) {
                        this.complain(world, "tile.founder.msg.complete", new Object[0]);
                        return;
                    }
                    Item toolPrim = null;
                    Item toolAlt = null;
                    Item toolAlt2 = null;
                    if (((x - 7) % 16 == 0 || (x - 8) % 16 == 0) && (z - 8) % 16 == 0 || y < pos.func_177956_o() && ((pos.func_177956_o() + 1 - y) % 5 == 0 || (pos.func_177956_o() - y) % 5 == 0) && ((x - 9) % 16 == 0 || (z - 1) % 16 == 0 || (z - 5) % 16 == 0 || (z - 9) % 16 == 0 || (z - 13) % 16 == 0)) {
                        if (world.func_180495_p(blockPos).func_185904_a().func_76224_d()) {
                            this.complain(world, "tile.founder.mine.msg.stop", y, new TextComponentTranslation(block.func_149739_a() + "name", new Object[0]));
                            return;
                        }
                        target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                        if (OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}) || OreDictionary.containsMatch((boolean)false, AutoRecipes.ores, (ItemStack[])new ItemStack[]{target})) {
                            if (block.getHarvestTool(world.func_180495_p(blockPos)) == null || block.getHarvestTool(world.func_180495_p(blockPos)).equals("pickaxe")) {
                                toolPrim = Items.field_151046_w;
                                if (block.getHarvestLevel(world.func_180495_p(blockPos)) <= 2) {
                                    toolAlt = Items.field_151035_b;
                                }
                                if (block.getHarvestLevel(world.func_180495_p(blockPos)) <= 1) {
                                    toolAlt2 = Items.field_151050_s;
                                }
                            } else if (block.getHarvestTool(world.func_180495_p(blockPos)).equals("shovel")) {
                                toolPrim = Items.field_151047_v;
                                if (block.getHarvestLevel(world.func_180495_p(blockPos)) <= 2) {
                                    toolAlt = Items.field_151037_a;
                                }
                                if (block.getHarvestLevel(world.func_180495_p(blockPos)) <= 1) {
                                    toolAlt2 = Items.field_151051_r;
                                }
                            }
                        }
                    }
                    if (y < pos.func_177956_o()) {
                        ItemStack received;
                        if (!(y != pos.func_177956_o() - 1 || x < this.xStart + 6 || x > this.xEnd - 6 || z < this.zStart + 6 || z > this.zEnd - 6 || (x - 6) % 16 != 0 && (x - 9) % 16 != 0 && (z - 6) % 16 != 0 && (z - 9) % 16 != 0 || OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE)}))) {
                            ItemStack stack;
                            ItemStack received2 = null;
                            int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.plankWood);
                            if (found >= 0) {
                                received2 = this.inventory.func_70298_a(found, 1);
                            }
                            if (received2 == null && (stack = AutoRecipes.make4PlanksFromLog(world, pos, this, this.inventory)) != null) {
                                received2 = stack.func_77979_a(1);
                                if (stack.field_77994_a > 0) {
                                    UtilInventory.addItemToInventory(this.inventory, stack);
                                }
                            }
                            if (received2 == null) {
                                this.complainResult(world, lastResult, "tile.log.name", new Object[0]);
                                return;
                            }
                            world.func_175656_a(blockPos, Blocks.field_150344_f.func_176203_a(received2.func_77960_j()));
                            amount -= 2.0f;
                            if (amount <= 0.0f) {
                                return;
                            }
                        }
                        if (((x - 7) % 16 == 0 || (x - 8) % 16 == 0) && (z - 7) % 16 == 0) {
                            if (world.func_180495_p(blockPos).func_185904_a().func_76222_j()) {
                                received = UtilInventory.findItems(this.inventory, cobblestone, dirt);
                                if (received == null && (received = this.requestItem(world, pos, cobblestone)) == null) {
                                    received = this.requestItem(world, pos, dirt);
                                }
                                if (received == null) {
                                    this.complainResult(world, lastResult, "%s/%s", new TextComponentTranslation(Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Blocks.field_150346_d.func_149739_a() + ".name", new Object[0]));
                                    return;
                                }
                                world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176223_P());
                                block = world.func_180495_p(blockPos).func_177230_c();
                                amount -= 2.0f;
                                if (amount <= 0.0f) {
                                    return;
                                }
                            }
                        } else if ((x - 8) % 16 == 0 && (z - 8) % 16 == 0) {
                            if (world.func_180495_p(blockPos).func_185904_a().func_76222_j()) {
                                ItemStack stack;
                                received = UtilInventory.findItem(this.inventory, ladder);
                                if (received == null && (stack = AutoRecipes.make24LaddersFromLogs(world, pos, this, this.inventory)) != null) {
                                    received = stack.func_77979_a(1);
                                    if (stack.field_77994_a > 0) {
                                        UtilInventory.addItemToInventory(this.inventory, stack);
                                    }
                                }
                                if (received == null) {
                                    this.complainResult(world, lastResult, "tile.log.name", new Object[0]);
                                    return;
                                }
                                world.func_175656_a(blockPos, Blocks.field_150468_ap.func_176203_a(3));
                                block = world.func_180495_p(blockPos).func_177230_c();
                                amount -= 2.0f;
                                if (amount <= 0.0f) {
                                    return;
                                }
                            }
                        } else if ((x - 7) % 16 == 0 && (z - 8) % 16 == 0 && (pos.func_177956_o() + 1 - y) % 5 == 0 && world.func_180495_p(blockPos).func_185904_a().func_76222_j()) {
                            received = UtilInventory.findItem(this.inventory, torch);
                            if (received == null) {
                                received = AutoRecipes.make32TorchesFromCoalAndLogs(world, pos, this, this.inventory);
                            }
                            if (received == null) {
                                this.complainResult(world, lastResult, "%s/%s", new TextComponentTranslation("tile.log.name", new Object[0]), new TextComponentTranslation(Items.field_151044_h.func_77658_a() + ".name", new Object[0]));
                                return;
                            }
                            world.func_175656_a(blockPos, Blocks.field_150478_aa.func_176203_a(3));
                            block = world.func_180495_p(blockPos).func_177230_c();
                            amount -= 2.0f;
                            if (amount <= 0.0f) {
                                return;
                            }
                        }
                    }
                    if (world.func_175623_d(blockPos)) continue;
                    if (world.func_180495_p(blockPos).func_185904_a().func_76222_j()) {
                        world.func_175698_g(blockPos);
                        continue;
                    }
                    target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                    if (OreDictionary.containsMatch((boolean)false, AutoRecipes.ores, (ItemStack[])new ItemStack[]{target})) {
                        if (block.getHarvestTool(world.func_180495_p(blockPos)) == null || block.getHarvestTool(world.func_180495_p(blockPos)).equals("pickaxe")) {
                            toolPrim = Items.field_151046_w;
                            if (block.getHarvestLevel(world.func_180495_p(blockPos)) <= 2) {
                                toolAlt = Items.field_151035_b;
                            }
                            if (block.getHarvestLevel(world.func_180495_p(blockPos)) <= 1) {
                                toolAlt2 = Items.field_151050_s;
                            }
                        } else if (block.getHarvestTool(world.func_180495_p(blockPos)).equals("shovel")) {
                            toolPrim = Items.field_151047_v;
                            if (block.getHarvestLevel(world.func_180495_p(blockPos)) <= 2) {
                                toolAlt = Items.field_151037_a;
                            }
                            if (block.getHarvestLevel(world.func_180495_p(blockPos)) <= 1) {
                                toolAlt2 = Items.field_151051_r;
                            }
                        }
                    }
                    if (toolPrim == null && toolAlt == null && toolAlt2 == null) {
                        if ((x - 7) % 16 != 0 && (x - 8) % 16 != 0 || (z - 8) % 16 != 0 || Block.func_149680_a((Block)block, (Block)Blocks.field_150468_ap) || Block.func_149680_a((Block)block, (Block)Blocks.field_150415_aT) || Block.func_149680_a((Block)block, (Block)Blocks.field_150478_aa)) continue;
                        this.complain(world, "tile.founder.mine.msg.stop", y, new TextComponentTranslation(block.func_149739_a() + ".name", new Object[0]));
                        return;
                    }
                    int found = -1;
                    found = UtilInventory.findItem(this.inventory, toolPrim);
                    if (found < 0 && toolAlt != null && (found = UtilInventory.findItem(this.inventory, toolAlt)) < 0 && toolAlt2 != null) {
                        found = UtilInventory.findItem(this.inventory, toolAlt2);
                    }
                    if (found < 0) {
                        ItemStack received = null;
                        received = this.requestItem(world, pos, new ItemStack(toolPrim));
                        if (received == null && toolAlt != null && (received = this.requestItem(world, pos, new ItemStack(toolAlt))) == null && toolAlt2 != null) {
                            received = this.requestItem(world, pos, new ItemStack(toolAlt2));
                        }
                        if (received != null) {
                            UtilInventory.addItemToInventory(this.inventory, received);
                            found = UtilInventory.findItem(this.inventory, received.func_77973_b());
                        }
                    }
                    if (found < 0) {
                        this.complain(world, "tile.founder.mine.msg.tools", new TextComponentTranslation(block.func_149739_a() + ".name", new Object[0]));
                        return;
                    }
                    float time = world.func_180495_p(blockPos).func_185887_b(world, blockPos) * 1.5f / ((ItemTool)this.inventory.func_70301_a(found).func_77973_b()).func_150913_i().func_77998_b();
                    time += 2.0f;
                    if (this.inventory.func_70301_a(found).func_96631_a(1, world.field_73012_v)) {
                        this.inventory.func_70298_a(found, 1);
                    }
                    world.func_175655_b(blockPos, true);
                    amount -= time;
                    if (!(amount <= 0.0f)) continue;
                    return;
                }
            }
        }
        this.complain(world, "tile.founder.msg.complete", new Object[0]);
    }
}

