/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.common.Market;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockLumbermill
extends BlockFounder {
    private static final float PLAYER_TIME = 2.0f;
    private static final float TICK_TIME = 68.27f;
    private static final ItemStack log_10 = new ItemStack(Blocks.field_150364_r, 10);
    private static final ItemStack log2_10 = new ItemStack(Blocks.field_150363_s, 10);
    private static final ItemStack log_15 = new ItemStack(Blocks.field_150364_r, 15);
    private static final ItemStack log2_15 = new ItemStack(Blocks.field_150363_s, 15);
    private static final ItemStack sapling = new ItemStack(Blocks.field_150345_g);

    public BlockLumbermill() {
        super(32, -8, 32);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180645_a(world, pos, state, rand);
        this.gatherDrops(world);
        if (world.func_175640_z(pos)) {
            return;
        }
        if (this.chance <= 0.1f && !this.eat(world, pos, 2, 0.0f)) {
            return;
        }
        if (world.func_72820_D() % 24000L >= 12000L) {
            return;
        }
        if (UtilInventory.isSlotsFull(this.inventory)) {
            return;
        }
        this.complained = false;
        this.busy = false;
        this.plantSapling(world, pos, 6.8269997f);
        this.cutLog(world, pos, 54.615997f, this.chance <= fireDisasterChance);
        this.smeltCharcoal(world, pos);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        ChunkPos p = chunk.func_76632_l();
        AxisAlignedBB bb = BlockLumbermill.calculateBorders(p, pos, this.lotSize, this.minHeight, this.maxHeight);
        BlockLumbermill.drawBorders(world, pos, bb);
        int plantable = 0;
        int xStart = p.func_180334_c() + (p.func_180334_c() % 32 == 0 ? 0 : -16);
        int xEnd = p.func_180332_e() + ((p.func_180332_e() + 1) % 32 == 0 ? 0 : 16);
        int zStart = p.func_180333_d() + (p.func_180333_d() % 32 == 0 ? 0 : -16);
        int zEnd = p.func_180330_f() + ((p.func_180330_f() + 1) % 32 == 0 ? 0 : 16);
        for (int y = 255; y >= 1; --y) {
            for (int x = xStart; x <= xEnd; ++x) {
                for (int z = zStart; z <= zEnd; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (block instanceof IFounder) {
                        IFounder lot = (IFounder)block;
                        AxisAlignedBB other = BlockLumbermill.calculateBorders(world.func_175726_f(blockPos).func_76632_l(), blockPos, lot.getPlotSize(), lot.getPlotMinHeight(), lot.getPlotMaxHeight());
                        if (bb.func_72326_a(other)) {
                            this.complain(world, "tile.founder.msg.occupied", new Object[0]);
                            return false;
                        }
                    }
                    if (y > (int)bb.field_72337_e || y < (int)bb.field_72338_b || x < (int)bb.field_72340_a || x > (int)bb.field_72336_d || z < (int)bb.field_72339_c || z > (int)bb.field_72334_f || x % 16 == 0 || (x - 15) % 16 == 0 || z % 16 == 0 || (z - 15) % 16 == 0 || !Block.func_149680_a((Block)block, (Block)Blocks.field_150346_d) && !Block.func_149680_a((Block)block, (Block)Blocks.field_150349_c)) continue;
                    Block above = world.func_180495_p(new BlockPos(x, y + 1, z)).func_177230_c();
                    if (world.func_180495_p(new BlockPos(x, y + 1, z)).func_185904_a().func_76224_d() || !above.func_176200_f((IBlockAccess)world, new BlockPos(x, y + 1, z))) continue;
                    ++plantable;
                }
            }
        }
        if (plantable < 64) {
            this.complain(world, "tile.founder.lumbermill.msg.noPlace", plantable, 64);
            return false;
        }
        return true;
    }

    private void plantSapling(World world, BlockPos pos, float amount) {
        if (amount <= 0.0f) {
            return;
        }
        for (int y = this.yEnd; y >= this.yStart; --y) {
            for (int x = this.xStart; x <= this.xEnd; ++x) {
                if ((x - 2) % 16 != 0 && (x - 6) % 16 != 0 && (x - 9) % 16 != 0 && (x - 13) % 16 != 0) continue;
                for (int z = this.zStart; z <= this.zEnd; ++z) {
                    if ((z - 2) % 16 != 0 && (z - 6) % 16 != 0 && (z - 9) % 16 != 0 && (z - 13) % 16 != 0) continue;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (block == Blocks.field_150345_g) {
                        this.busy = true;
                        continue;
                    }
                    if (!Block.func_149680_a((Block)block, (Block)Blocks.field_150346_d) && !Block.func_149680_a((Block)block, (Block)Blocks.field_150349_c)) continue;
                    BlockPos abovePos = new BlockPos(x, y + 1, z);
                    Block above = world.func_180495_p(abovePos).func_177230_c();
                    if (world.func_180495_p(abovePos).func_185904_a().func_76224_d() || !above.func_176200_f((IBlockAccess)world, abovePos)) continue;
                    ItemStack received = UtilInventory.findItem(this.inventory, sapling);
                    if (received == null && (received = this.requestItem(world, pos, new ItemStack(Blocks.field_150345_g, 1, 0))) == null && (received = this.requestItem(world, pos, new ItemStack(Blocks.field_150345_g, 1, 1))) == null && (received = this.requestItem(world, pos, new ItemStack(Blocks.field_150345_g, 1, 2))) == null) {
                        received = this.requestItem(world, pos, new ItemStack(Blocks.field_150345_g, 1, 4));
                    }
                    if (received == null) {
                        if (!this.complained && !this.busy) {
                            this.complainResult(world, lastResult, "tile.founder.sapling", new Object[0]);
                            this.complained = true;
                        }
                        return;
                    }
                    world.func_175656_a(abovePos, Block.func_149634_a((Item)received.func_77973_b()).func_176203_a(received.func_77960_j()));
                    this.busy = true;
                    amount -= 2.0f;
                    if (!(amount <= 0.0f)) continue;
                    return;
                }
            }
        }
    }

    private void cutLog(World world, BlockPos pos, float amount, boolean disaster) {
        if (amount <= 0.0f) {
            return;
        }
        for (int y = this.yEnd; y >= this.yStart; --y) {
            for (int x = this.xStart; x <= this.xEnd; ++x) {
                for (int z = this.zStart; z <= this.zEnd; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (Block.func_149680_a((Block)block, (Block)Blocks.field_150460_al) || Block.func_149680_a((Block)block, (Block)Blocks.field_150470_am)) {
                        if (this.furnaces.size() >= 6) continue;
                        this.furnaces.add((TileEntityFurnace)world.func_175625_s(blockPos));
                    }
                    if (!(amount > 0.0f) || !Block.func_149680_a((Block)block, (Block)Blocks.field_150364_r) && !Block.func_149680_a((Block)block, (Block)Blocks.field_150363_s)) continue;
                    if (disaster) {
                        world.func_175655_b(blockPos, false);
                        if (Blocks.field_150480_ab.func_176196_c(world, blockPos)) {
                            world.func_175656_a(blockPos, Blocks.field_150480_ab.func_176223_P());
                            this.complainCritical(world, "tile.founder.lumbermill.msg.disaster", new Object[0]);
                            return;
                        }
                    }
                    int found = -1;
                    found = UtilInventory.findItem(this.inventory, Items.field_151056_x);
                    if (found < 0 && (found = UtilInventory.findItem(this.inventory, Items.field_151036_c)) < 0) {
                        found = UtilInventory.findItem(this.inventory, Items.field_151049_t);
                    }
                    if (found < 0) {
                        ItemStack received = null;
                        received = this.requestItem(world, pos, new ItemStack(Items.field_151056_x));
                        if (received == null && (received = this.requestItem(world, pos, new ItemStack(Items.field_151036_c))) == null) {
                            received = this.requestItem(world, pos, new ItemStack(Items.field_151049_t));
                        }
                        if (received != null) {
                            UtilInventory.addItemToInventory(this.inventory, received);
                            found = UtilInventory.findItem(this.inventory, received.func_77973_b());
                        }
                    }
                    if (found < 0) {
                        if (!this.complained && !this.busy) {
                            this.complain(world, "tile.founder.lumbermill.msg.tools", new TextComponentTranslation(block.func_149739_a() + ".name", new Object[0]));
                            this.complained = true;
                        }
                        return;
                    }
                    float time = world.func_180495_p(blockPos).func_185887_b(world, blockPos) * 1.5f / ((ItemTool)this.inventory.func_70301_a(found).func_77973_b()).func_150913_i().func_77998_b();
                    time += 2.0f;
                    if (this.inventory.func_70301_a(found).func_96631_a(1, world.field_73012_v)) {
                        this.inventory.func_70298_a(found, 1);
                    }
                    world.func_175655_b(blockPos, true);
                    this.busy = true;
                    amount -= time;
                }
            }
        }
    }

    private void smeltCharcoal(World world, BlockPos pos) {
        for (int i = 0; i < this.furnaces.size(); ++i) {
            TileEntityFurnace furnace = (TileEntityFurnace)this.furnaces.get(i);
            if (furnace.func_70301_a(2) != null && !UtilInventory.isSlotsFull(this.inventory)) {
                ItemStack stack = furnace.func_70298_a(2, furnace.func_70301_a((int)2).field_77994_a);
                this.addItemToInventory(stack, this.coinPouch);
                this.busy = true;
            }
            if (!furnace.func_145950_i()) {
                ItemStack received;
                if (furnace.func_70301_a(0) == null) {
                    received = UtilInventory.findItems(this.inventory, log_15, log2_15);
                    if (received == null) {
                        received = this.requestItem(world, pos, new ItemStack(Blocks.field_150364_r, 15, 0));
                        if (received == null && (received = this.requestItem(world, pos, new ItemStack(Blocks.field_150364_r, 15, 1))) == null && (received = this.requestItem(world, pos, new ItemStack(Blocks.field_150364_r, 15, 2))) == null) {
                            received = this.requestItem(world, pos, new ItemStack(Blocks.field_150363_s, 15, 0));
                        }
                    } else if (this.coinPouch != null && !expertMode) {
                        this.coinPouch.func_82841_c(Math.max(0, this.coinPouch.func_82838_A() - Market.getPrice(received) * received.field_77994_a));
                    }
                    if (received != null) {
                        furnace.func_70299_a(0, received);
                        this.busy = true;
                    }
                }
                if (furnace.func_70301_a(1) != null) continue;
                received = UtilInventory.findItems(this.inventory, log_10, log2_10);
                if (received == null) {
                    received = this.requestItem(world, pos, new ItemStack(Blocks.field_150364_r, 10, 0));
                    if (received == null && (received = this.requestItem(world, pos, new ItemStack(Blocks.field_150364_r, 10, 1))) == null && (received = this.requestItem(world, pos, new ItemStack(Blocks.field_150364_r, 10, 2))) == null) {
                        received = this.requestItem(world, pos, new ItemStack(Blocks.field_150363_s, 10, 0));
                    }
                } else if (this.coinPouch != null && !expertMode) {
                    this.coinPouch.func_82841_c(Math.max(0, this.coinPouch.func_82838_A() - Market.getPrice(received) * received.field_77994_a));
                }
                if (received == null) continue;
                furnace.func_70299_a(1, received);
                this.busy = true;
                continue;
            }
            this.busy = true;
        }
    }
}

