/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.common.Market;
import com.dooglamoo.citiesmod.inventory.AutoRecipes;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockGarden
extends BlockFounder {
    private static final float PLAYER_TIME = 0.45f;
    private static final float TICK_TIME = 68.27f;
    private static final ItemStack coal = new ItemStack(Items.field_151044_h, 1, 0);
    private static final ItemStack charcoal = new ItemStack(Items.field_151044_h, 1, 1);
    private static final ItemStack cactus8 = new ItemStack((Block)Blocks.field_150434_aF, 8);

    public BlockGarden() {
        super(3, -4, 16);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180645_a(world, pos, state, rand);
        this.gatherDrops(world);
        if (world.func_175640_z(pos)) {
            return;
        }
        if (this.chance <= 0.1f && !this.eat(world, pos, 2, 0.0f)) {
            return;
        }
        if (world.func_72820_D() % 24000L >= 12000L) {
            return;
        }
        if (UtilInventory.isSlotsFull(this.inventory)) {
            return;
        }
        this.complained = false;
        this.busy = false;
        this.makeBonemeal(world, pos, 1);
        this.garden(world, pos, 61.442997f, rand, this.chance < blightDisasterChance);
        this.smeltCactus(world, pos);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        ChunkPos p = chunk.func_76632_l();
        AxisAlignedBB bb = BlockGarden.calculateBorders(p, pos, this.lotSize, this.minHeight, this.maxHeight);
        BlockGarden.drawBorders(world, pos, bb);
        int farmable = 0;
        for (int y = (int)bb.field_72337_e; y >= (int)bb.field_72338_b; --y) {
            for (int x = (int)bb.field_72340_a; x <= (int)bb.field_72336_d; ++x) {
                for (int z = (int)bb.field_72339_c; z <= (int)bb.field_72334_f; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (block instanceof IFounder) {
                        IFounder lot = (IFounder)block;
                        AxisAlignedBB other = BlockGarden.calculateBorders(world.func_175726_f(blockPos).func_76632_l(), blockPos, lot.getPlotSize(), lot.getPlotMinHeight(), lot.getPlotMaxHeight());
                        if (bb.func_72326_a(other)) {
                            this.complain(world, "tile.founder.msg.occupied", new Object[0]);
                            return false;
                        }
                    }
                    if (x % 16 == 0 || (x - 15) % 16 == 0 || z % 16 == 0 || (z - 15) % 16 == 0) continue;
                    Block blockBelow = world.func_180495_p(blockPos.func_177977_b()).func_177230_c();
                    if (block.func_176200_f((IBlockAccess)world, blockPos) && (blockBelow == Blocks.field_150349_c || blockBelow == Blocks.field_150346_d || blockBelow == Blocks.field_150354_m)) {
                        if (world.func_175716_a((Block)Blocks.field_150436_aH, blockPos, false, EnumFacing.UP, (Entity)null, new ItemStack(Items.field_151120_aE)) && Blocks.field_150436_aH.func_176196_c(world, blockPos)) {
                            ++farmable;
                            continue;
                        }
                        if (!Blocks.field_150434_aF.func_176196_c(world, blockPos)) continue;
                        ++farmable;
                        continue;
                    }
                    if (block == Blocks.field_150458_ak) {
                        ++farmable;
                        continue;
                    }
                    if (block == Blocks.field_150364_r && world.func_180495_p(blockPos).func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.JUNGLE) {
                        ++farmable;
                        continue;
                    }
                    if (block == Blocks.field_150436_aH || block == Blocks.field_150434_aF || block == Blocks.field_150375_by || block == Blocks.field_150423_aK || block == Blocks.field_150440_ba) {
                        ++farmable;
                        continue;
                    }
                    if (block != Blocks.field_150398_cm || world.func_180495_p(blockPos).func_177229_b((IProperty)BlockDoublePlant.field_176492_b) != BlockDoublePlant.EnumBlockHalf.UPPER || world.func_180495_p(blockPos).func_177229_b((IProperty)BlockDoublePlant.field_176493_a) != BlockDoublePlant.EnumPlantType.SUNFLOWER && world.func_180495_p(blockPos).func_177229_b((IProperty)BlockDoublePlant.field_176493_a) != BlockDoublePlant.EnumPlantType.ROSE && world.func_180495_p(blockPos).func_177229_b((IProperty)BlockDoublePlant.field_176493_a) != BlockDoublePlant.EnumPlantType.PAEONIA && world.func_180495_p(blockPos).func_177229_b((IProperty)BlockDoublePlant.field_176493_a) != BlockDoublePlant.EnumPlantType.SYRINGA) continue;
                    ++farmable;
                }
            }
        }
        if (farmable < 1) {
            this.complain(world, "tile.founder.garden.msg.noPlace", farmable, 1);
            return false;
        }
        return true;
    }

    private void garden(World world, BlockPos pos, float amount, Random rand, boolean disaster) {
        if (amount <= 0.0f) {
            return;
        }
        boolean needReed = false;
        boolean needCactus = false;
        boolean needCocoa = false;
        boolean needSeeds = false;
        if (disaster) {
            this.complainCritical(world, "tile.founder.garden.msg.disaster", new Object[0]);
        }
        for (int y = this.yEnd; y >= this.yStart; --y) {
            for (int x = this.xStart; x <= this.xEnd; ++x) {
                for (int z = this.zStart; z <= this.zEnd; ++z) {
                    Object received;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (block == Blocks.field_150460_al || block == Blocks.field_150470_am) {
                        if (this.furnaces.size() >= 6) continue;
                        this.furnaces.add((TileEntityFurnace)world.func_175625_s(blockPos));
                    }
                    Block blockBelow = world.func_180495_p(blockPos.func_177977_b()).func_177230_c();
                    if (amount > 0.0f && !world.func_180495_p(blockPos).func_185904_a().func_76224_d() && block != Blocks.field_150330_I && block.func_176200_f((IBlockAccess)world, blockPos) && (blockBelow == Blocks.field_150349_c || blockBelow == Blocks.field_150346_d || blockBelow == Blocks.field_150354_m)) {
                        if (x % 16 == 0 || (x - 15) % 16 == 0 || z % 16 == 0 || (z - 15) % 16 == 0) continue;
                        if (world.func_175716_a((Block)Blocks.field_150436_aH, blockPos, false, EnumFacing.UP, (Entity)null, new ItemStack(Items.field_151120_aE)) && Blocks.field_150436_aH.func_176196_c(world, blockPos)) {
                            received = UtilInventory.findItem(this.inventory, new ItemStack(Items.field_151120_aE));
                            if (received == null) {
                                received = this.requestItem(world, pos, new ItemStack(Items.field_151120_aE));
                            }
                            if (received == null) {
                                needReed = true;
                                continue;
                            }
                            world.func_175656_a(blockPos, Blocks.field_150436_aH.func_176223_P());
                            amount -= 0.45f;
                            this.busy = true;
                            continue;
                        }
                        if (!Blocks.field_150434_aF.func_176196_c(world, blockPos) || world.func_180495_p(blockPos.func_177982_a(1, 0, 1)).func_177230_c() == Blocks.field_150434_aF || world.func_180495_p(blockPos.func_177982_a(-1, 0, -1)).func_177230_c() == Blocks.field_150434_aF || world.func_180495_p(blockPos.func_177982_a(1, 0, -1)).func_177230_c() == Blocks.field_150434_aF || world.func_180495_p(blockPos.func_177982_a(-1, 0, 1)).func_177230_c() == Blocks.field_150434_aF) continue;
                        received = UtilInventory.findItem(this.inventory, new ItemStack((Block)Blocks.field_150434_aF));
                        if (received == null) {
                            received = this.requestItem(world, pos, new ItemStack((Block)Blocks.field_150434_aF));
                        }
                        if (received == null) {
                            needCactus = true;
                            continue;
                        }
                        world.func_175656_a(blockPos, Blocks.field_150434_aF.func_176223_P());
                        amount -= 0.45f;
                        this.busy = true;
                        continue;
                    }
                    if (amount > 0.0f && block == Blocks.field_150458_ak) {
                        if (!world.func_175623_d(blockPos.func_177984_a())) continue;
                        received = UtilInventory.findItem(this.inventory, new ItemStack(Items.field_151080_bb));
                        if (received == null && (received = AutoRecipes.make4PumpkinSeedFromPumpkin(world, blockPos, this, this.inventory)) == null) {
                            received = this.requestItem(world, pos, new ItemStack(Items.field_151080_bb));
                        }
                        if (received == null && (received = UtilInventory.findItem(this.inventory, new ItemStack(Items.field_151081_bc))) == null && (received = AutoRecipes.make1MelonSeedFromMelon(world, blockPos, this, this.inventory)) == null) {
                            received = this.requestItem(world, pos, new ItemStack(Items.field_151081_bc));
                        }
                        if (received == null) {
                            needSeeds = true;
                            continue;
                        }
                        Block stem = received.func_77973_b() == Items.field_151080_bb ? Blocks.field_150393_bb : Blocks.field_150394_bc;
                        world.func_175656_a(blockPos.func_177984_a(), stem.func_176223_P());
                        amount -= 0.45f;
                        this.busy = true;
                        continue;
                    }
                    if (amount > 0.0f && block == Blocks.field_150364_r && world.func_180495_p(blockPos).func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.JUNGLE) {
                        if (x % 16 == 0 || (x - 15) % 16 == 0 || z % 16 == 0 || (z - 15) % 16 == 0) continue;
                        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                            EnumFacing enumfacing1 = enumfacing.func_176734_d();
                            BlockPos p = blockPos.func_177982_a(enumfacing1.func_82601_c(), 0, enumfacing1.func_82599_e());
                            if (!world.func_175623_d(p)) continue;
                            ItemStack received2 = UtilInventory.findItemMeta(this.inventory, new ItemStack(Items.field_151100_aR, 1, 3));
                            if (received2 == null) {
                                received2 = this.requestItem(world, pos, new ItemStack(Items.field_151100_aR, 1, 3));
                            }
                            if (received2 == null) {
                                needCocoa = true;
                                continue;
                            }
                            world.func_180501_a(p, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockCocoa.field_176501_a, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BlockCocoa.field_185512_D, (Comparable)enumfacing), 3);
                            this.busy = true;
                            amount -= 0.45f;
                        }
                        continue;
                    }
                    if (block == Blocks.field_150436_aH) {
                        if (disaster && (blockBelow == Blocks.field_150354_m || blockBelow == Blocks.field_150349_c || blockBelow == Blocks.field_150346_d) && rand.nextFloat() < 0.5f) {
                            world.func_175655_b(blockPos, false);
                            if (blockBelow == Blocks.field_150349_c || blockBelow == Blocks.field_150346_d) {
                                world.func_175656_a(blockPos.func_177977_b(), Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
                            }
                            world.func_175656_a(blockPos, Blocks.field_150330_I.func_176223_P());
                        } else if (amount > 0.0f && blockBelow == Blocks.field_150436_aH && world.func_180495_p(blockPos.func_177984_a()).func_177230_c() == Blocks.field_150436_aH) {
                            world.func_175655_b(blockPos, true);
                            amount -= 0.9f;
                        }
                        this.busy = true;
                        continue;
                    }
                    if (block == Blocks.field_150434_aF) {
                        if (disaster && blockBelow == Blocks.field_150354_m && rand.nextFloat() < 0.5f) {
                            world.func_175655_b(blockPos, false);
                            world.func_175656_a(blockPos, Blocks.field_150330_I.func_176223_P());
                        } else if (amount > 0.0f && blockBelow != Blocks.field_150434_aF && world.func_180495_p(blockPos.func_177981_b(2)).func_177230_c() == Blocks.field_150434_aF) {
                            world.func_175655_b(blockPos, true);
                            amount -= 0.9f;
                        }
                        this.busy = true;
                        continue;
                    }
                    if (block == Blocks.field_150375_by) {
                        if (disaster && rand.nextFloat() < 0.6f) {
                            world.func_175655_b(blockPos, false);
                        } else if (amount > 0.0f && (Integer)world.func_180495_p(blockPos).func_177229_b((IProperty)BlockCocoa.field_176501_a) >= 2) {
                            world.func_175655_b(blockPos, true);
                            amount -= 0.45f;
                        }
                        this.busy = true;
                        continue;
                    }
                    if (amount > 0.0f && block == Blocks.field_150423_aK) {
                        world.func_175655_b(blockPos, true);
                        amount -= 0.45f;
                        this.busy = true;
                        continue;
                    }
                    if (block == Blocks.field_150393_bb) {
                        if (disaster && rand.nextFloat() < 0.3f) {
                            world.func_175655_b(blockPos, false);
                            world.func_175656_a(blockPos.func_177977_b(), Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
                            world.func_175656_a(blockPos, Blocks.field_150330_I.func_176223_P());
                        }
                        this.busy = true;
                        continue;
                    }
                    if (amount > 0.0f && block == Blocks.field_150440_ba) {
                        world.func_175655_b(blockPos, true);
                        amount -= 0.45f;
                        this.busy = true;
                        continue;
                    }
                    if (block == Blocks.field_150394_bc) {
                        if (disaster && rand.nextFloat() < 0.3f) {
                            world.func_175655_b(blockPos, false);
                            world.func_175656_a(blockPos.func_177977_b(), Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
                            world.func_175656_a(blockPos, Blocks.field_150330_I.func_176223_P());
                        }
                        this.busy = true;
                        continue;
                    }
                    if (block != Blocks.field_150398_cm || world.func_180495_p(blockPos).func_177229_b((IProperty)BlockDoublePlant.field_176492_b) != BlockDoublePlant.EnumBlockHalf.UPPER || world.func_180495_p(blockPos).func_177229_b((IProperty)BlockDoublePlant.field_176493_a) != BlockDoublePlant.EnumPlantType.SUNFLOWER && world.func_180495_p(blockPos).func_177229_b((IProperty)BlockDoublePlant.field_176493_a) != BlockDoublePlant.EnumPlantType.ROSE && world.func_180495_p(blockPos).func_177229_b((IProperty)BlockDoublePlant.field_176493_a) != BlockDoublePlant.EnumPlantType.PAEONIA && world.func_180495_p(blockPos).func_177229_b((IProperty)BlockDoublePlant.field_176493_a) != BlockDoublePlant.EnumPlantType.SYRINGA) continue;
                    if (disaster && rand.nextFloat() < 0.2f) {
                        world.func_175655_b(blockPos.func_177977_b(), false);
                        if (world.func_180495_p(blockPos.func_177979_c(2)).func_177230_c() == Blocks.field_150349_c || world.func_180495_p(blockPos.func_177979_c(2)).func_177230_c() == Blocks.field_150346_d) {
                            world.func_175656_a(blockPos.func_177979_c(2), Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
                        }
                        world.func_175656_a(blockPos.func_177977_b(), Blocks.field_150330_I.func_176223_P());
                        continue;
                    }
                    if (!(this.chance <= 0.1f) || !(amount > 0.0f)) continue;
                    received = UtilInventory.findItemMeta(this.inventory, new ItemStack(Items.field_151100_aR, 1, 15));
                    if (received == null) {
                        received = this.requestItem(world, pos, new ItemStack(Items.field_151100_aR, 1, 15));
                    }
                    if (received == null) continue;
                    Blocks.field_150398_cm.func_176474_b(world, world.field_73012_v, blockPos, world.func_180495_p(blockPos));
                    amount -= 0.45f;
                    this.busy = true;
                }
            }
        }
        if (needReed) {
            if (!this.complained && !this.busy) {
                this.complainResult(world, lastResult, Items.field_151120_aE.func_77658_a() + ".name", new Object[0]);
                this.complained = true;
            }
        } else if (needCactus) {
            if (!this.complained && !this.busy) {
                this.complainResult(world, lastResult, Blocks.field_150434_aF.func_149739_a() + ".name", new Object[0]);
                this.complained = true;
            }
        } else if (needCocoa) {
            if (!this.complained && !this.busy) {
                this.complainResult(world, lastResult, Items.field_151100_aR.func_77667_c(new ItemStack(Items.field_151100_aR, 1, 3)) + ".name", new Object[0]);
                this.complained = true;
            }
        } else if (needSeeds && !this.complained && !this.busy) {
            this.complainResult(world, lastResult, "%s/%s", new TextComponentTranslation(Items.field_151080_bb.func_77658_a() + ".name", new Object[0]), new TextComponentTranslation(Items.field_151081_bc.func_77658_a() + ".name", new Object[0]));
            this.complained = true;
        }
    }

    private void makeBonemeal(World world, BlockPos pos, int amount) {
        while (amount > 0) {
            if (UtilInventory.isSlotsFull(this.inventory)) {
                return;
            }
            ItemStack received = AutoRecipes.make3WhiteFrom1Bone(world, pos, this, this.inventory);
            if (received != null) {
                this.addItemToInventory(received, this.coinPouch);
                --amount;
                this.busy = true;
                continue;
            }
            return;
        }
    }

    private void smeltCactus(World world, BlockPos pos) {
        BlockFounder.TransactionResult lastOreResult = BlockFounder.TransactionResult.SUCCESS;
        BlockFounder.TransactionResult lastFuelResult = BlockFounder.TransactionResult.SUCCESS;
        for (int i = 0; i < this.furnaces.size(); ++i) {
            TileEntityFurnace furnace = (TileEntityFurnace)this.furnaces.get(i);
            if (furnace.func_70301_a(2) != null && !UtilInventory.isSlotsFull(this.inventory)) {
                ItemStack stack = furnace.func_70298_a(2, furnace.func_70301_a((int)2).field_77994_a);
                this.addItemToInventory(stack, this.coinPouch);
                this.busy = true;
            }
            if (!furnace.func_145950_i()) {
                ItemStack received;
                if (furnace.func_70301_a(0) == null) {
                    received = UtilInventory.findItem(this.inventory, cactus8);
                    if (received == null) {
                        received = this.requestItem(world, pos, cactus8);
                    } else if (this.coinPouch != null && !expertMode) {
                        this.coinPouch.func_82841_c(Math.max(0, this.coinPouch.func_82838_A() - Market.getPrice(received) * received.field_77994_a));
                    }
                    if (received == null) {
                        lastOreResult = lastResult;
                    } else {
                        furnace.func_70299_a(0, received);
                        this.busy = true;
                    }
                }
                if (furnace.func_70301_a(1) != null) continue;
                received = UtilInventory.findItemsMeta(this.inventory, coal, charcoal);
                if (received == null && (received = this.requestItem(world, pos, coal)) == null) {
                    received = this.requestItem(world, pos, charcoal);
                }
                if (received == null) {
                    lastFuelResult = lastResult;
                    continue;
                }
                furnace.func_70299_a(1, received);
                this.busy = true;
                continue;
            }
            this.busy = true;
        }
        if (lastOreResult != BlockFounder.TransactionResult.SUCCESS && !this.complained && !this.busy) {
            this.complainResult(world, lastOreResult, Blocks.field_150434_aF.func_149739_a() + ".name", new Object[0]);
            this.complained = true;
        }
        if (lastFuelResult != BlockFounder.TransactionResult.SUCCESS && !this.complained && !this.busy) {
            this.complainResult(world, lastFuelResult, Items.field_151044_h.func_77658_a() + ".name", new Object[0]);
            this.complained = true;
        }
    }
}

