/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.CitiesMod;
import com.dooglamoo.citiesmod.tileentity.TileEntityFounder;
import javax.annotation.Nullable;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class BlockFounderContainer
extends BlockContainer {
    protected int maxHeight;
    protected int minHeight;
    protected int lotSize;

    public BlockFounderContainer(Material material) {
        super(material);
        this.func_149647_a(CitiesMod.citiesTab);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFounder();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityFounder) {
            player.func_71007_a((IInventory)((TileEntityFounder)tileentity));
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileentity));
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof TileEntityFounder) {
            ((TileEntityFounder)tileentity).setCustomName(stack.func_82833_r());
        }
    }

    protected static AxisAlignedBB calculateBorders(ChunkPos p, BlockPos pos, int lotSize, int minHeight, int maxHeight) {
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        int minZ = 0;
        int maxZ = 0;
        switch (lotSize) {
            case 8: {
                minX = p.func_180334_c() + (pos.func_177958_n() >= p.func_180334_c() + 8 ? 8 : 0);
                maxX = p.func_180332_e() + (pos.func_177958_n() >= p.func_180334_c() + 8 ? 0 : -8);
                minZ = p.func_180333_d() + (pos.func_177952_p() >= p.func_180333_d() + 8 ? 8 : 0);
                maxZ = p.func_180330_f() + (pos.func_177952_p() >= p.func_180333_d() + 8 ? 0 : -8);
                break;
            }
            case 16: {
                minX = p.func_180334_c();
                maxX = p.func_180332_e();
                minZ = p.func_180333_d();
                maxZ = p.func_180330_f();
                break;
            }
            case 32: {
                minX = p.func_180334_c() + (p.func_180334_c() % 32 == 0 ? 0 : -16);
                maxX = p.func_180332_e() + ((p.func_180332_e() + 1) % 32 == 0 ? 0 : 16);
                minZ = p.func_180333_d() + (p.func_180333_d() % 32 == 0 ? 0 : -16);
                maxZ = p.func_180330_f() + ((p.func_180330_f() + 1) % 32 == 0 ? 0 : 16);
                break;
            }
            default: {
                System.out.println("unsupported lot size: " + lotSize);
            }
        }
        minY = pos.func_177956_o() + minHeight;
        if (minY < 1) {
            minY = 1;
        }
        if ((maxY = pos.func_177956_o() + maxHeight) > 255) {
            maxY = 255;
        }
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    protected static void drawBorders(World world, BlockPos pos, AxisAlignedBB bb) {
        if (world.field_72995_K) {
            for (int x = (int)bb.field_72340_a - 1; x <= (int)bb.field_72336_d + 2; ++x) {
                world.func_175682_a(EnumParticleTypes.BARRIER, true, (double)x, (double)pos.func_177956_o() + 1.5, bb.field_72339_c - 1.0, 0.0, 0.0, 0.0, new int[0]);
                world.func_175682_a(EnumParticleTypes.BARRIER, true, (double)x, (double)pos.func_177956_o() + 1.5, bb.field_72334_f + 2.0, 0.0, 0.0, 0.0, new int[0]);
            }
            for (int z = (int)bb.field_72339_c; z <= (int)bb.field_72334_f + 1; ++z) {
                world.func_175682_a(EnumParticleTypes.BARRIER, true, bb.field_72340_a - 1.0, (double)pos.func_177956_o() + 1.5, (double)z, 0.0, 0.0, 0.0, new int[0]);
                world.func_175682_a(EnumParticleTypes.BARRIER, true, bb.field_72336_d + 2.0, (double)pos.func_177956_o() + 1.5, (double)z, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }
}

