/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.CitiesMod;
import com.dooglamoo.citiesmod.block.BlockFounderContainer;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.common.Market;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import com.dooglamoo.citiesmod.tileentity.TileEntityFounder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockFounder
extends BlockFounderContainer
implements IFounder {
    protected static final float ONCEPERDAY_CHANCE = 0.1f;
    public static float outOfBusinessDisasterChance = 0.01f;
    public static float fireDisasterChance = 0.0025f;
    public static float droughtDisasterChance = 0.0025f;
    public static float blightDisasterChance = 0.0025f;
    public static float invasionDisasterChance = 0.0025f;
    public static boolean showInventoryFullMsg = false;
    public static int feeExemptionThreshold = 50;
    public static boolean expertMode = false;
    protected IInventory inventory;
    protected List<IInventory> distributors;
    protected List<TileEntityFurnace> furnaces = new ArrayList<TileEntityFurnace>();
    protected ItemStack coinPouch;
    protected int xStart;
    protected int xEnd;
    protected int yStart;
    protected int yEnd;
    protected int zStart;
    protected int zEnd;
    protected float chance;
    protected static TransactionResult lastResult = TransactionResult.FAIL_UNKNOWN;
    protected boolean complained;
    protected boolean busy;
    private String tmpCustomName;

    public BlockFounder(int maxHeight, int minHeight, int lotSize) {
        super(Material.field_151575_d);
        this.func_149711_c(0.2f);
        this.func_149752_b(5.0f);
        this.maxHeight = maxHeight;
        this.minHeight = minHeight;
        this.lotSize = lotSize;
        this.func_149675_a(true);
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        this.inventory = (IInventory)world.func_175625_s(pos);
        this.distributors = null;
        this.furnaces.clear();
        ChunkPos p = world.func_175726_f(pos).func_76632_l();
        switch (this.lotSize) {
            case 8: {
                this.xStart = p.func_180334_c() + (pos.func_177958_n() >= p.func_180334_c() + 8 ? 8 : 0);
                this.xEnd = p.func_180332_e() + (pos.func_177958_n() >= p.func_180334_c() + 8 ? 0 : -8);
                this.zStart = p.func_180333_d() + (pos.func_177952_p() >= p.func_180333_d() + 8 ? 8 : 0);
                this.zEnd = p.func_180330_f() + (pos.func_177952_p() >= p.func_180333_d() + 8 ? 0 : -8);
                break;
            }
            case 16: {
                this.xStart = p.func_180334_c();
                this.xEnd = p.func_180332_e();
                this.zStart = p.func_180333_d();
                this.zEnd = p.func_180330_f();
                break;
            }
            case 32: {
                this.xStart = p.func_180334_c() + (p.func_180334_c() % 32 == 0 ? 0 : -16);
                this.xEnd = p.func_180332_e() + ((p.func_180332_e() + 1) % 32 == 0 ? 0 : 16);
                this.zStart = p.func_180333_d() + (p.func_180333_d() % 32 == 0 ? 0 : -16);
                this.zEnd = p.func_180330_f() + ((p.func_180330_f() + 1) % 32 == 0 ? 0 : 16);
                break;
            }
            default: {
                System.out.println("unsupported lot size: " + this.lotSize);
            }
        }
        this.yStart = pos.func_177956_o() + this.minHeight;
        if (this.yStart < 1) {
            this.yStart = 1;
        }
        this.yEnd = pos.func_177956_o() + this.maxHeight;
        if (this.yEnd > 255) {
            this.yEnd = 255;
        }
        this.coinPouch = null;
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != CitiesMod.coinPouch) continue;
            this.coinPouch = stack;
            break;
        }
        this.chance = rand.nextFloat();
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityFounder) {
            TileEntityFounder entity = (TileEntityFounder)tileentity;
            this.tmpCustomName = entity.func_145818_k_() ? entity.func_70005_c_() : null;
        }
        super.func_180663_b(world, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List list = super.getDrops(world, pos, state, fortune);
        if (list.size() > 0 && ((ItemStack)list.get(0)).func_77973_b() == Item.func_150898_a((Block)this) && this.tmpCustomName != null) {
            ((ItemStack)list.get(0)).func_151001_c(this.tmpCustomName);
            this.tmpCustomName = null;
        }
        return list;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        ChunkPos p = chunk.func_76632_l();
        AxisAlignedBB bb = BlockFounder.calculateBorders(p, pos, this.lotSize, this.minHeight, this.maxHeight);
        BlockFounder.drawBorders(world, pos, bb);
        if (!super.func_176196_c(world, pos)) {
            return false;
        }
        int xStart = p.func_180334_c() + (p.func_180334_c() % 32 == 0 ? 0 : -16);
        int xEnd = p.func_180332_e() + ((p.func_180332_e() + 1) % 32 == 0 ? 0 : 16);
        int zStart = p.func_180333_d() + (p.func_180333_d() % 32 == 0 ? 0 : -16);
        int zEnd = p.func_180330_f() + ((p.func_180330_f() + 1) % 32 == 0 ? 0 : 16);
        for (int y = 255; y >= 1; --y) {
            for (int x = xStart; x <= xEnd; ++x) {
                for (int z = zStart; z <= zEnd; ++z) {
                    AxisAlignedBB other;
                    IFounder lot;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (!(block instanceof IFounder) || (lot = (IFounder)block).canContain(this) && this.canBeContainedIn(lot) || !bb.func_72326_a(other = BlockFounder.calculateBorders(world.func_175726_f(blockPos).func_76632_l(), blockPos, lot.getPlotSize(), lot.getPlotMinHeight(), lot.getPlotMaxHeight()))) continue;
                    this.complain(world, "tile.founder.msg.occupied", new Object[0]);
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean gatherDrops(World world) {
        List list = world.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.xStart, (double)this.yStart, (double)this.zStart, (double)this.xEnd, (double)this.yEnd, (double)this.zEnd));
        for (int i = 0; i < list.size(); ++i) {
            EntityItem item = (EntityItem)list.get(i);
            ItemStack stack = item.func_92059_d();
            int cost = Market.getPrice(stack) * stack.field_77994_a;
            if (UtilInventory.addItemToInventory(this.inventory, stack) != null) {
                if (showInventoryFullMsg) {
                    this.complain(world, "tile.founder.msg.full", new Object[0]);
                }
                world.func_72900_e((Entity)item);
                return false;
            }
            if (this.coinPouch != null && !expertMode) {
                this.coinPouch.func_82841_c(this.coinPouch.func_82838_A() + cost);
            }
            world.func_72900_e((Entity)item);
        }
        return true;
    }

    protected boolean eat(World world, BlockPos pos, int amount, float quality) {
        ItemStack stack;
        if (world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return true;
        }
        int food = UtilInventory.findFood(this.inventory, amount + this.minInventory(), quality);
        if (food < 0) {
            lastResult = TransactionResult.FAIL_ITEM_NOT_AVAILABLE;
            stack = this.requestFood(world, pos, amount, quality);
        } else {
            stack = this.inventory.func_70298_a(food, amount);
        }
        if (stack != null && stack.field_77994_a >= amount) {
            return true;
        }
        this.complainResult(world, lastResult, "tile.founder.food.eat", new Object[0]);
        if (this.chance < outOfBusinessDisasterChance) {
            this.complainCritical(world, "tile.founder.msg.disaster", new Object[0]);
            world.func_175655_b(pos, true);
        }
        return false;
    }

    protected void findFurnace(World world) {
        for (int y = this.yEnd; y >= this.yStart; --y) {
            for (int x = this.xStart; x <= this.xEnd; ++x) {
                for (int z = this.zStart; z <= this.zEnd; ++z) {
                    Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                    if (!Block.func_149680_a((Block)block, (Block)Blocks.field_150460_al) && !Block.func_149680_a((Block)block, (Block)Blocks.field_150470_am)) continue;
                    this.furnaces.add((TileEntityFurnace)world.func_175625_s(new BlockPos(x, y, z)));
                    if (this.furnaces.size() < 6) continue;
                    return;
                }
            }
        }
    }

    protected ItemStack addItemToInventory(ItemStack stack, ItemStack cp) {
        if (cp != null && !expertMode) {
            cp.func_82841_c(cp.func_82838_A() + (int)((float)(Market.getPrice(stack) * stack.field_77994_a) * 1.1f));
        }
        return UtilInventory.addItemToInventory(this.inventory, stack);
    }

    protected List<IInventory> getDistributors(World world, BlockPos pos) {
        if (this.distributors == null) {
            this.distributors = new ArrayList<IInventory>();
            ArrayList<IInventory> distributors1 = new ArrayList<IInventory>();
            ArrayList<IInventory> distributors2 = new ArrayList<IInventory>();
            ArrayList<IInventory> distributors3 = new ArrayList<IInventory>();
            List list = world.field_175730_i;
            block5: for (int i = 0; i < list.size(); ++i) {
                Block block;
                TileEntity t = (TileEntity)list.get(i);
                if (t == this.inventory || !(t.func_145835_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= 7225.0) || !((block = t.func_145838_q()) instanceof IFounder) || ((IFounder)block).getDistributorPriority().ordinal() < IFounder.DISTRIBUTOR_PRIORITY.PRIORITY_1.ordinal()) continue;
                switch (((IFounder)block).getDistributorPriority()) {
                    case PRIORITY_1: {
                        distributors1.add((IInventory)t);
                        continue block5;
                    }
                    case PRIORITY_2: {
                        distributors2.add((IInventory)t);
                        continue block5;
                    }
                    case PRIORITY_3: {
                        distributors3.add((IInventory)t);
                        continue block5;
                    }
                }
            }
            if (!distributors1.isEmpty()) {
                Collections.shuffle(distributors1, world.field_73012_v);
                this.distributors.addAll(distributors1);
            }
            if (!distributors2.isEmpty()) {
                Collections.shuffle(distributors2, world.field_73012_v);
                this.distributors.addAll(distributors2);
            }
            if (!distributors3.isEmpty()) {
                Collections.shuffle(distributors3, world.field_73012_v);
                this.distributors.addAll(distributors3);
            }
        }
        return this.distributors;
    }

    public ItemStack requestItem(World world, BlockPos pos, ItemStack item) {
        return this.requestItem(world, pos, item, true);
    }

    public ItemStack requestItem(World world, BlockPos pos, ItemStack item, boolean exact) {
        lastResult = TransactionResult.FAIL_ITEM_NOT_AVAILABLE;
        if (item == null || item.func_77973_b() == CitiesMod.coinPouch) {
            lastResult = TransactionResult.FAIL_UNKNOWN;
            return null;
        }
        List<IInventory> list = this.getDistributors(world, pos);
        for (int i = 0; i < list.size(); ++i) {
            IInventory distributor = list.get(i);
            int vendorMoney = UtilInventory.findItem(distributor, CitiesMod.coinPouch);
            ItemStack vendorStack = null;
            if (vendorMoney >= 0) {
                vendorStack = distributor.func_70301_a(vendorMoney);
            }
            IFounder plot = (IFounder)((TileEntity)distributor).func_145838_q();
            float fee = this.buyModifier() * plot.sellModifier();
            for (int j = 0; j < distributor.func_70302_i_(); ++j) {
                ItemStack stack = distributor.func_70301_a(j);
                if (stack == null || stack.field_77994_a <= plot.minInventory() || stack.func_77973_b() != item.func_77973_b() || item.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != item.func_77960_j()) continue;
                if (stack.field_77994_a - plot.minInventory() >= item.field_77994_a) {
                    return BlockFounder.makeTransaction(distributor, j, item.field_77994_a, this.coinPouch, vendorStack, plot.canAcceptPayment() || expertMode, exact, fee);
                }
                if (exact) continue;
                return BlockFounder.makeTransaction(distributor, j, stack.field_77994_a - plot.minInventory(), this.coinPouch, vendorStack, plot.canAcceptPayment() || expertMode, exact, fee);
            }
        }
        lastResult = TransactionResult.FAIL_ITEM_NOT_AVAILABLE;
        return null;
    }

    protected ItemStack requestFood(World world, BlockPos pos, int amount, float quality) {
        List<IInventory> list = this.getDistributors(world, pos);
        for (int i = 0; i < list.size(); ++i) {
            IInventory distributor = list.get(i);
            int vendorMoney = UtilInventory.findItem(distributor, CitiesMod.coinPouch);
            ItemStack vendorStack = null;
            if (vendorMoney >= 0) {
                vendorStack = distributor.func_70301_a(vendorMoney);
            }
            IFounder plot = (IFounder)((TileEntity)distributor).func_145838_q();
            for (int j = 0; j < distributor.func_70302_i_(); ++j) {
                ItemFood food;
                ItemStack stack = distributor.func_70301_a(j);
                if (stack == null || stack.field_77994_a <= plot.minInventory() || !(stack.func_77973_b() instanceof ItemFood) || (float)(food = (ItemFood)stack.func_77973_b()).func_150905_g(stack) + (float)food.func_150905_g(stack) * food.func_150906_h(stack) * 2.0f < quality) continue;
                ItemStack result = null;
                if (stack.field_77994_a - plot.minInventory() >= amount) {
                    result = BlockFounder.makeTransaction(distributor, j, amount, this.coinPouch, vendorStack, true, true, 1.0f);
                }
                if (result == null) continue;
                return result;
            }
        }
        lastResult = TransactionResult.FAIL_ITEM_NOT_AVAILABLE;
        return null;
    }

    protected static ItemStack makeTransaction(IInventory distributor, int goods, int amount, ItemStack buyerCash, ItemStack sellerCash, boolean complete, boolean exact, float fee) {
        ItemStack received = null;
        if (sellerCash != null) {
            if (buyerCash == null) {
                lastResult = TransactionResult.FAIL_LOW_FUNDS;
                return null;
            }
            float price = (float)Market.getPrice(distributor.func_70301_a(goods)) * fee;
            if (price != 0.0f) {
                if (exact && (int)((float)buyerCash.func_82838_A() / price) < amount) {
                    lastResult = TransactionResult.FAIL_LOW_FUNDS;
                    return null;
                }
                if ((amount = Math.min(amount, (int)((float)buyerCash.func_82838_A() / price))) == 0) {
                    lastResult = TransactionResult.FAIL_LOW_FUNDS;
                    return null;
                }
            }
            int cost = (int)(price * (float)amount);
            if (buyerCash.func_82838_A() - cost >= 0) {
                buyerCash.func_82841_c(buyerCash.func_82838_A() - cost);
                if (complete && sellerCash.func_82838_A() + cost <= Integer.MAX_VALUE) {
                    sellerCash.func_82841_c(sellerCash.func_82838_A() + cost);
                }
                received = distributor.func_70298_a(goods, amount);
                lastResult = TransactionResult.SUCCESS;
            } else {
                lastResult = TransactionResult.FAIL_LOW_FUNDS;
            }
        } else {
            received = distributor.func_70298_a(goods, amount);
            lastResult = TransactionResult.SUCCESS;
        }
        return received;
    }

    protected void complainCritical(World world, String translationKey, Object ... args) {
        this.complain(world, true, null, translationKey, args);
    }

    protected void complain(World world, String translationKey, Object ... args) {
        this.complain(world, false, null, translationKey, args);
    }

    protected void complainResult(World world, TransactionResult result, String translationKey, Object ... args) {
        this.complain(world, false, result, translationKey, args);
    }

    private void complain(World world, boolean critical, TransactionResult result, String translationKey, Object ... args) {
        TextComponentTranslation sender;
        String dst = null;
        BlockPos pos = null;
        if (this.inventory != null && this.inventory instanceof TileEntityFounder) {
            TileEntityFounder entity = (TileEntityFounder)this.inventory;
            if (entity.func_145818_k_()) {
                String[] s = entity.func_70005_c_().split("@");
                sender = new TextComponentString(s[0].trim());
                if (s.length > 1) {
                    dst = s[1].trim();
                }
            } else {
                sender = new TextComponentTranslation(this.func_149739_a() + ".name", new Object[0]);
            }
            pos = entity.func_174877_v();
        } else {
            sender = new TextComponentTranslation(this.func_149739_a() + ".name", new Object[0]);
        }
        MinecraftServer server = world.func_73046_m();
        if (server != null) {
            TextComponentTranslation msg = new TextComponentTranslation(translationKey, args);
            if (critical) {
                msg.func_150256_b().func_150238_a(TextFormatting.YELLOW);
            }
            if (dst != null) {
                EntityPlayerMP player = server.func_184103_al().func_152612_a(dst);
                if (player != null) {
                    this.sendMsg((ITextComponent)sender, (EntityPlayer)player, pos, (ITextComponent)msg, result);
                } else {
                    ScorePlayerTeam team = world.func_96441_U().func_96508_e(dst);
                    if (team != null) {
                        for (String username : team.func_96670_d()) {
                            EntityPlayerMP entityplayermp = server.func_184103_al().func_152612_a(username);
                            if (entityplayermp == null) continue;
                            this.sendMsg((ITextComponent)sender, (EntityPlayer)entityplayermp, pos, (ITextComponent)msg, result);
                        }
                    }
                }
            } else {
                for (EntityPlayerMP entityplayermp : server.func_184103_al().func_181057_v()) {
                    this.sendMsg((ITextComponent)sender, (EntityPlayer)entityplayermp, pos, (ITextComponent)msg, result);
                }
            }
        } else {
            CitiesMod.proxy.clientChat((ITextComponent)sender, pos, translationKey, args);
        }
    }

    private void sendMsg(ITextComponent sender, EntityPlayer player, BlockPos pos, ITextComponent msg, TransactionResult result) {
        TextComponentTranslation component;
        TextComponentTranslation senderComponent = player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() == Items.field_151111_aL && pos != null ? new TextComponentTranslation("<%s %d %d>", new Object[]{sender, pos.func_177958_n(), pos.func_177952_p()}) : new TextComponentTranslation("<%s>", new Object[]{sender});
        if (result != null) {
            switch (result) {
                case FAIL_LOW_FUNDS: {
                    component = new TextComponentTranslation("tile.founder.msg.afford", new Object[]{senderComponent, msg});
                    break;
                }
                default: {
                    component = new TextComponentTranslation("tile.founder.msg.low", new Object[]{senderComponent, msg});
                    break;
                }
            }
        } else {
            component = new TextComponentTranslation("%s %s", new Object[]{senderComponent, msg});
        }
        player.func_145747_a((ITextComponent)component);
    }

    protected void addStatsToPlayers(World world, int stat) {
        if (world != null && !world.field_72995_K) {
            List list = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.xStart, (double)this.yStart, (double)this.zStart, (double)this.xEnd, (double)this.yEnd, (double)this.zEnd));
            for (EntityPlayer entityplayer : list) {
                entityplayer.func_71064_a((StatBase)CitiesMod.cities_achievements[stat], 1);
            }
        }
    }

    @Override
    public boolean canContain(IFounder block) {
        return false;
    }

    @Override
    public boolean canBeContainedIn(IFounder block) {
        return false;
    }

    @Override
    public int getPlotSize() {
        return this.lotSize;
    }

    @Override
    public int getPlotMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public int getPlotMinHeight() {
        return this.minHeight;
    }

    @Override
    public int minInventory() {
        return 0;
    }

    @Override
    public IFounder.DISTRIBUTOR_PRIORITY getDistributorPriority() {
        return IFounder.DISTRIBUTOR_PRIORITY.PRIORITY_0;
    }

    @Override
    public float buyModifier() {
        return 1.0f;
    }

    @Override
    public float sellModifier() {
        return 1.0f;
    }

    @Override
    public boolean canAcceptPayment() {
        return false;
    }

    @Override
    public boolean isBuilding() {
        return false;
    }

    @Override
    public boolean canRequestFrom() {
        return true;
    }

    protected static enum TransactionResult {
        SUCCESS,
        FAIL_UNKNOWN,
        FAIL_LOW_FUNDS,
        FAIL_ITEM_NOT_AVAILABLE;

    }
}

