/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;

public class BlockFishery
extends BlockFounder {
    private static final ItemStack gravel = new ItemStack(Blocks.field_150351_n);
    private static final int MIN_FISH = 0;
    private static final int MAX_FISH = 2;
    private static final int MIN_INK = 2;
    private static final int MAX_INK = 4;
    private static final int MIN_CLAY = 2;
    private static final int MAX_CLAY = 4;

    public BlockFishery() {
        super(4, -28, 32);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180645_a(world, pos, state, rand);
        this.gatherDrops(world);
        if (world.func_175640_z(pos)) {
            return;
        }
        if (this.chance <= 0.1f && !this.eat(world, pos, 2, 0.0f)) {
            return;
        }
        if (world.func_72820_D() % 24000L >= 12000L) {
            return;
        }
        if (UtilInventory.isSlotsFull(this.inventory)) {
            return;
        }
        this.goFishing(world, pos, rand.nextInt(3) + 0);
        this.collectInk(world, pos, rand.nextInt(3) + 2);
        this.harvestClay(world, pos, rand.nextInt(3) + 2);
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        ChunkPos p = chunk.func_76632_l();
        AxisAlignedBB bb = BlockFishery.calculateBorders(p, pos, this.lotSize, this.minHeight, this.maxHeight);
        BlockFishery.drawBorders(world, pos, bb);
        int water = 0;
        int xStart = p.func_180334_c() + (p.func_180334_c() % 32 == 0 ? 0 : -16);
        int xEnd = p.func_180332_e() + ((p.func_180332_e() + 1) % 32 == 0 ? 0 : 16);
        int zStart = p.func_180333_d() + (p.func_180333_d() % 32 == 0 ? 0 : -16);
        int zEnd = p.func_180330_f() + ((p.func_180330_f() + 1) % 32 == 0 ? 0 : 16);
        for (int y = 255; y >= 1; --y) {
            for (int x = xStart; x <= xEnd; ++x) {
                for (int z = zStart; z <= zEnd; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (block instanceof IFounder) {
                        IFounder lot = (IFounder)block;
                        AxisAlignedBB other = BlockFishery.calculateBorders(world.func_175726_f(blockPos).func_76632_l(), blockPos, lot.getPlotSize(), lot.getPlotMinHeight(), lot.getPlotMaxHeight());
                        if (bb.func_72326_a(other)) {
                            this.complain(world, "tile.founder.msg.occupied", new Object[0]);
                            return false;
                        }
                    }
                    if (!Block.func_149680_a((Block)block, (Block)Blocks.field_150355_j) || !world.func_175726_f(blockPos).func_177444_d(blockPos.func_177982_a(0, 1, 0))) continue;
                    ++water;
                }
            }
        }
        if (water < 128) {
            this.complain(world, "tile.founder.fishery.msg.noPlace", water, 128);
            return false;
        }
        return true;
    }

    private void goFishing(World world, BlockPos pos, int amount) {
        if (amount <= 0) {
            return;
        }
        boolean fishingspot = false;
        for (int y = this.yEnd; y >= this.yStart; --y) {
            for (int x = this.xStart + 4; x <= this.xEnd - 4; ++x) {
                for (int z = this.zStart + 4; z <= this.zEnd - 4; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (!Block.func_149680_a((Block)block, (Block)Blocks.field_150355_j) || !world.func_175726_f(blockPos).func_177444_d(blockPos.func_177982_a(0, 1, 0))) continue;
                    fishingspot = true;
                    int found = UtilInventory.findItem(this.inventory, (Item)Items.field_151112_aM);
                    if (found < 0) {
                        ItemStack received = this.requestItem(world, pos, new ItemStack((Item)Items.field_151112_aM));
                        if (received != null) {
                            UtilInventory.addItemToInventory(this.inventory, received);
                        }
                        found = UtilInventory.findItem(this.inventory, (Item)Items.field_151112_aM);
                    }
                    if (found < 0) {
                        this.complainResult(world, lastResult, Items.field_151112_aM.func_77658_a() + ".name", new Object[0]);
                        return;
                    }
                    ItemStack stack = this.getFishingResult(world, this.inventory.func_70301_a(found));
                    this.addItemToInventory(stack, this.coinPouch);
                    if (this.inventory.func_70301_a(found).func_96631_a(2, world.field_73012_v)) {
                        this.inventory.func_70298_a(found, 1);
                    }
                    if (--amount > 0) continue;
                    return;
                }
            }
        }
        if (!fishingspot) {
            return;
        }
    }

    private void collectInk(World world, BlockPos pos, int amount) {
        if (amount <= 0) {
            return;
        }
        List list = world.func_72872_a(EntitySquid.class, new AxisAlignedBB((double)this.xStart, (double)this.yStart, (double)this.zStart, (double)this.xEnd, (double)this.yEnd, (double)this.zEnd));
        for (int i = 0; i < list.size() && i < amount; ++i) {
            EntitySquid squid = (EntitySquid)list.get(i);
            squid.func_70097_a(DamageSource.field_76377_j, 20.0f);
        }
    }

    private void harvestClay(World world, BlockPos pos, int amount) {
        if (amount <= 0) {
            return;
        }
        for (int y = this.yEnd; y >= this.yStart; --y) {
            for (int x = this.xStart; x <= this.xEnd; ++x) {
                for (int z = this.zStart; z <= this.zEnd; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (!Block.func_149680_a((Block)block, (Block)Blocks.field_150435_aG)) continue;
                    ItemStack received = UtilInventory.findItem(this.inventory, gravel);
                    if (received == null) {
                        received = this.requestItem(world, pos, gravel);
                    }
                    if (received == null) {
                        this.complainResult(world, lastResult, Blocks.field_150351_n.func_149739_a() + ".name", new Object[0]);
                        return;
                    }
                    world.func_175655_b(blockPos, true);
                    world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176223_P());
                    if (--amount > 0) continue;
                    return;
                }
            }
        }
    }

    private ItemStack getFishingResult(World world, ItemStack rod) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"luck_of_the_sea"), (ItemStack)rod);
        LootContext lc = new LootContext.Builder((WorldServer)world).func_186469_a((float)i).func_186471_a();
        List items = world.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(world.field_73012_v, lc);
        return (ItemStack)items.get(0);
    }
}

