/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.CitiesMod;
import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.IPlantable;

public class BlockFarm
extends BlockFounder {
    private static final ItemStack wheat_seeds = new ItemStack(Items.field_151014_N, 1);
    private static final ItemStack potato = new ItemStack(Items.field_151174_bG, 1);
    private static final ItemStack carrot = new ItemStack(Items.field_151172_bF, 1);
    private static final float PLAYER_TIME = 0.45f;
    private static final float TICK_TIME = 68.27f;

    public BlockFarm() {
        super(4, -4, 32);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180645_a(world, pos, state, rand);
        this.gatherDrops(world);
        if (world.func_175640_z(pos)) {
            return;
        }
        if (this.chance <= 0.1f && !this.eat(world, pos, 2, 0.0f)) {
            return;
        }
        if (world.func_72820_D() % 24000L >= 12000L) {
            return;
        }
        if (UtilInventory.isSlotsFull(this.inventory)) {
            return;
        }
        this.complained = false;
        this.busy = false;
        float remaining = this.tillSoil(world, pos, 34.135f);
        remaining = this.plantSeed(world, pos, 20.480999f + remaining);
        this.harvestCrop(world, 6.8269997f + remaining, this.chance < droughtDisasterChance && !world.func_72896_J());
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        ChunkPos p = chunk.func_76632_l();
        AxisAlignedBB bb = BlockFarm.calculateBorders(p, pos, this.lotSize, this.minHeight, this.maxHeight);
        BlockFarm.drawBorders(world, pos, bb);
        int farmable = 0;
        int xStart = p.func_180334_c() + (p.func_180334_c() % 32 == 0 ? 0 : -16);
        int xEnd = p.func_180332_e() + ((p.func_180332_e() + 1) % 32 == 0 ? 0 : 16);
        int zStart = p.func_180333_d() + (p.func_180333_d() % 32 == 0 ? 0 : -16);
        int zEnd = p.func_180330_f() + ((p.func_180330_f() + 1) % 32 == 0 ? 0 : 16);
        for (int y = 255; y >= 1; --y) {
            for (int x = xStart; x <= xEnd; ++x) {
                for (int z = zStart; z <= zEnd; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (block instanceof IFounder) {
                        IFounder lot = (IFounder)block;
                        AxisAlignedBB other = BlockFarm.calculateBorders(world.func_175726_f(blockPos).func_76632_l(), blockPos, lot.getPlotSize(), lot.getPlotMinHeight(), lot.getPlotMaxHeight());
                        if (bb.func_72326_a(other)) {
                            this.complain(world, "tile.founder.msg.occupied", new Object[0]);
                            return false;
                        }
                    }
                    if (y > (int)bb.field_72337_e || y < (int)bb.field_72338_b || x < (int)bb.field_72340_a || x > (int)bb.field_72336_d || z < (int)bb.field_72339_c || z > (int)bb.field_72334_f || x % 16 == 0 || (x - 15) % 16 == 0 || z % 16 == 0 || (z - 15) % 16 == 0 || !Block.func_149680_a((Block)block, (Block)Blocks.field_150346_d) && !Block.func_149680_a((Block)block, (Block)Blocks.field_150349_c) && !Block.func_149680_a((Block)block, (Block)Blocks.field_150458_ak) || !BlockFarm.hasWater(world, blockPos) || world.func_175671_l(blockPos.func_177982_a(0, 1, 0)) < 9) continue;
                    ++farmable;
                }
            }
        }
        if (farmable < 64) {
            this.complain(world, "tile.founder.farm.msg.noPlace", farmable, 64);
            return false;
        }
        return true;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (placer instanceof EntityPlayer) {
            ((EntityPlayer)placer).func_71064_a((StatBase)CitiesMod.cities_achievements[1], 1);
        }
    }

    private float tillSoil(World world, BlockPos pos, float amount) {
        if (amount <= 0.0f) {
            return 0.0f;
        }
        for (int y = this.yStart; y <= this.yEnd; ++y) {
            for (int x = this.xStart; x <= this.xEnd; ++x) {
                if (x % 16 == 0 || (x - 15) % 16 == 0) continue;
                for (int z = this.zStart; z <= this.zEnd; ++z) {
                    BlockPos blockPos;
                    Block block;
                    if (z % 16 == 0 || (z - 15) % 16 == 0 || !Block.func_149680_a((Block)(block = world.func_180495_p(blockPos = new BlockPos(x, y, z)).func_177230_c()), (Block)Blocks.field_150346_d) && !Block.func_149680_a((Block)block, (Block)Blocks.field_150349_c)) continue;
                    BlockPos abovePos = new BlockPos(x, y + 1, z);
                    if (!BlockFarm.hasWater(world, blockPos) || world.func_175671_l(abovePos) < 9 || !world.func_175623_d(abovePos) && (!world.func_180495_p(abovePos).func_185904_a().func_76222_j() || world.func_180495_p(abovePos).func_185904_a().func_76224_d())) continue;
                    int found = -1;
                    found = UtilInventory.findItem(this.inventory, Items.field_151012_L);
                    if (found < 0 && (found = UtilInventory.findItem(this.inventory, Items.field_151019_K)) < 0) {
                        found = UtilInventory.findItem(this.inventory, Items.field_151018_J);
                    }
                    if (found < 0) {
                        ItemStack received = null;
                        received = this.requestItem(world, pos, new ItemStack(Items.field_151012_L));
                        if (received == null && (received = this.requestItem(world, pos, new ItemStack(Items.field_151019_K))) == null) {
                            received = this.requestItem(world, pos, new ItemStack(Items.field_151018_J));
                        }
                        if (received != null) {
                            UtilInventory.addItemToInventory(this.inventory, received);
                            found = UtilInventory.findItem(this.inventory, received.func_77973_b());
                        }
                    }
                    if (found < 0) {
                        if (!this.complained && !this.busy) {
                            this.complain(world, "tile.founder.farm.msg.tools", new TextComponentTranslation(block.func_149739_a() + ".name", new Object[0]));
                            this.complained = true;
                        }
                        return amount;
                    }
                    if (this.inventory.func_70301_a(found).func_96631_a(1, world.field_73012_v)) {
                        this.inventory.func_70298_a(found, 1);
                    }
                    world.func_175655_b(abovePos, true);
                    world.func_175656_a(blockPos, Blocks.field_150458_ak.func_176223_P());
                    this.busy = true;
                    amount -= 0.45f;
                    if (!(amount <= 0.0f)) continue;
                    return 0.0f;
                }
            }
        }
        return amount;
    }

    private float plantSeed(World world, BlockPos pos, float amount) {
        if (amount <= 0.0f) {
            return 0.0f;
        }
        for (int y = this.yEnd; y >= this.yStart; --y) {
            for (int x = this.xStart; x <= this.xEnd; ++x) {
                for (int z = this.zStart; z <= this.zEnd; ++z) {
                    BlockPos abovePos;
                    Block above;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (block instanceof BlockCrops) {
                        this.busy = true;
                        continue;
                    }
                    if (!block.isFertile(world, blockPos) || !(above = world.func_180495_p(abovePos = new BlockPos(x, y + 1, z)).func_177230_c()).func_176200_f((IBlockAccess)world, abovePos) || world.func_180495_p(abovePos).func_185904_a().func_76224_d()) continue;
                    int found = UtilInventory.findItem(this.inventory, IPlantable.class, 1);
                    if (found < 0) {
                        ItemStack received = null;
                        received = this.requestItem(world, pos, wheat_seeds);
                        if (received == null && (received = this.requestItem(world, pos, potato)) == null) {
                            received = this.requestItem(world, pos, carrot);
                        }
                        if (received != null) {
                            UtilInventory.addItemToInventory(this.inventory, received);
                        }
                        found = UtilInventory.findItem(this.inventory, IPlantable.class, 1);
                    }
                    if (found < 0) {
                        if (!this.complained && !this.busy) {
                            this.complainResult(world, lastResult, "%s/%s/%s", new TextComponentTranslation(Items.field_151014_N.func_77658_a() + ".name", new Object[0]), new TextComponentTranslation(Items.field_151174_bG.func_77658_a() + ".name", new Object[0]), new TextComponentTranslation(Items.field_151172_bF.func_77658_a() + ".name", new Object[0]));
                            this.complained = true;
                        }
                        return amount;
                    }
                    IPlantable plantable = (IPlantable)this.inventory.func_70301_a(found).func_77973_b();
                    this.inventory.func_70298_a(found, 1);
                    world.func_175656_a(abovePos, plantable.getPlant((IBlockAccess)world, abovePos));
                    this.busy = true;
                    amount -= 0.45f;
                    if (!(amount <= 0.0f)) continue;
                    return 0.0f;
                }
            }
        }
        return amount;
    }

    private void harvestCrop(World world, float amount, boolean disaster) {
        if (amount <= 0.0f) {
            return;
        }
        if (disaster) {
            this.complainCritical(world, "tile.founder.farm.msg.disaster", new Object[0]);
        }
        for (int y = this.yStart; y <= this.yEnd; ++y) {
            for (int x = this.xStart; x <= this.xEnd; ++x) {
                for (int z = this.zStart; z <= this.zEnd; ++z) {
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (disaster && world.func_180495_p(blockPos).func_185904_a() == Material.field_151586_h && world.func_180495_p(blockPos.func_177984_a()).func_185904_a() != Material.field_151586_h) {
                        world.func_175655_b(blockPos, false);
                    }
                    if (!(amount > 0.0f) || !(block instanceof BlockCrops) || block.func_176201_c(world.func_180495_p(blockPos)) < 7) continue;
                    world.func_175655_b(blockPos, true);
                    this.busy = true;
                    amount -= 0.45f;
                    if (!(amount <= 0.0f) || disaster) continue;
                    return;
                }
            }
        }
    }

    private static final boolean hasWater(World world, BlockPos pos) {
        BlockPos.MutableBlockPos mutableblockpos;
        Iterator iterator = BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4)).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (world.func_180495_p((BlockPos)(mutableblockpos = (BlockPos.MutableBlockPos)iterator.next())).func_185904_a() != Material.field_151586_h);
        return true;
    }
}

