/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.CitiesMod;
import com.dooglamoo.citiesmod.block.BlockBuilding;
import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.common.Market;
import com.dooglamoo.citiesmod.inventory.AutoRecipes;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import com.dooglamoo.citiesmod.tileentity.TileEntityFounder;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockFactory
extends BlockBuilding {
    protected static final ItemStack glass_pane = new ItemStack(Blocks.field_150410_aZ);
    protected static final ItemStack crafting_table = new ItemStack(Blocks.field_150462_ai);
    private static final int MIN_INVEST1 = 4000;
    private static final int MIN_INVEST2 = 8000;
    private final float MIN_QUALITY;

    public BlockFactory(int maxHeight) {
        super(maxHeight, -1, 16, maxHeight <= 16 ? 4000 : 8000, 3);
        float f = this.MIN_QUALITY = maxHeight <= 16 ? 6.0f : 11.0f;
        if (maxHeight <= 16) {
            this.trades.add(Items.field_151015_O);
            this.trades.add(Items.field_151083_be);
            this.trades.add(Items.field_151157_am);
            this.trades.add(Items.field_151077_bg);
            this.trades.add(Items.field_179559_bp);
            this.trades.add(Items.field_179557_bn);
            this.trades.add(Items.field_179566_aV);
            this.trades.add(Items.field_151168_bH);
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150344_f));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150325_L));
            this.trades.add(Items.field_151116_aA);
            this.trades.add(Items.field_151121_aF);
            this.trades.add(Items.field_151100_aR);
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150348_b));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150366_p));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150352_o));
            this.trades.add(Items.field_151137_ax);
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150322_A));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_180395_cM));
            this.trades.add(Items.field_151016_H);
            this.trades.add(Items.field_151032_g);
            this.trades.add(Items.field_151102_aT);
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150359_w));
            this.trades.add(Items.field_151118_aC);
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150435_aG));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150423_aK));
            this.trades.add(Items.field_151127_ba);
        } else {
            this.trades.add(Items.field_151025_P);
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150404_cg));
            this.trades.add(Items.field_151122_aG);
            this.trades.add(Items.field_151042_j);
            this.trades.add(Items.field_151043_k);
            this.trades.add(Items.field_151162_bE);
            this.trades.add(Items.field_151123_aH);
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150399_cn));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150417_aV));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150336_V));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150405_ch));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150335_W));
            this.trades.add(Items.field_151166_bC);
            this.trades.add(Items.field_151106_aX);
            this.trades.add(Items.field_151158_bO);
            this.trades.add(Items.field_151080_bb);
            this.trades.add(Items.field_151081_bc);
            this.trades.add(Item.func_150898_a((Block)Blocks.field_150426_aN));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_180398_cJ));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_180397_cI));
            this.trades.add(Item.func_150898_a((Block)Blocks.field_185767_cT));
        }
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175640_z(pos)) {
            return;
        }
        super.func_180645_a(world, pos, state, rand);
        this.seller = null;
        this.buyer = null;
        if (this.chance <= 0.1f) {
            if (this.coinPouch == null || this.coinPouch.func_82838_A() < this.MIN_INVESTMENT) {
                // empty if block
            }
            this.collectInvestment(world, pos, this.MIN_INVESTMENT);
            if (!this.eat(world, pos, this.MIN_COMMUNITY, this.MIN_QUALITY)) {
                return;
            }
        }
        if (this.build(world, pos, 68.27f) && !Market.marketDisabled) {
            this.exportGoods(world, pos);
            this.importGoods(world, pos);
        }
    }

    private boolean build(World world, BlockPos pos, float amount) {
        ItemStack woodType = null;
        boolean ladderFill = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150468_ap)) >= 0;
        for (int y = this.yStart; y <= this.yEnd; ++y) {
            for (int x = this.xStart; x <= this.xEnd; ++x) {
                for (int z = this.zStart; z <= this.zEnd; ++z) {
                    ItemStack received;
                    ItemStack item;
                    ItemStack stack;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (y == pos.func_177956_o()) {
                        if (this.seller == null && Block.func_149680_a((Block)block, (Block)CitiesMod.sellerBlock)) {
                            this.seller = (TileEntityFounder)world.func_175625_s(blockPos);
                        }
                        if (this.buyer == null && Block.func_149680_a((Block)block, (Block)CitiesMod.buyerBlock)) {
                            this.buyer = (TileEntityFounder)world.func_175625_s(blockPos);
                        }
                    }
                    if (block instanceof BlockFounder || (y == this.yStart + 1 || y == this.yStart + 2) && ((x - 7) % 16 == 0 || (x - 8) % 16 == 0 || (z - 7) % 16 == 0 || (z - 8) % 16 == 0)) continue;
                    if (!(x % 16 != 0 && (x - 15) % 16 != 0 && z % 16 != 0 && (z - 15) % 16 != 0 || ((this.yEnd - y) % 16 != 0 || y == this.yStart) && (y != this.yStart + 4 || x >= this.xStart + 3 && x <= this.xEnd - 3 || z >= this.zStart + 3 && z <= this.zEnd - 3) || Block.func_149680_a((Block)block, (Block)Blocks.field_150390_bg))) {
                        int dir = 2;
                        if ((x - 15) % 16 == 0) {
                            dir = 1;
                        } else if (x % 16 == 0) {
                            dir = 0;
                        } else if ((z - 15) % 16 == 0) {
                            dir = 3;
                        }
                        ItemStack received2 = UtilInventory.findItem(this.inventory, stonebrick_stairs);
                        if (received2 == null && (stack = AutoRecipes.make4StonebrickStairsFromStonebrick(world, pos, this, this.inventory)) != null) {
                            received2 = stack.func_77979_a(1);
                            if (stack.field_77994_a > 0) {
                                UtilInventory.addItemToInventory(this.inventory, stack);
                            }
                        }
                        if (received2 == null) {
                            this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                            return false;
                        }
                        world.func_175656_a(blockPos, Blocks.field_150390_bg.func_176203_a(4 | dir));
                        amount -= 1.6f;
                        if (amount <= 0.0f) {
                            return false;
                        }
                    }
                    if (x == this.xStart || x == this.xEnd || z == this.zStart || z == this.zEnd) continue;
                    if ((x - 1) % 16 == 0 || (x - 14) % 16 == 0 || (z - 1) % 16 == 0 || (z - 14) % 16 == 0) {
                        if ((this.yEnd - y) % 16 == 0 && y != this.yStart || ((x - 1) % 16 == 0 || (x - 2) % 16 == 0 || (x - 13) % 16 == 0 || (x - 14) % 16 == 0) && ((z - 1) % 16 == 0 || (z - 2) % 16 == 0 || (z - 13) % 16 == 0 || (z - 14) % 16 == 0)) {
                            if (!Block.func_149680_a((Block)block, (Block)Blocks.field_150417_aV)) {
                                ItemStack received3 = UtilInventory.findItem(this.inventory, stonebrick);
                                if (received3 == null && (received3 = this.requestItem(world, pos, stonebrick)) == null && (received3 = this.requestItem(world, pos, new ItemStack(Blocks.field_150417_aV, 1, 1))) == null && (received3 = this.requestItem(world, pos, new ItemStack(Blocks.field_150417_aV, 1, 2))) == null) {
                                    received3 = this.requestItem(world, pos, new ItemStack(Blocks.field_150417_aV, 1, 3));
                                }
                                if (received3 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150417_aV.func_149739_a() + ".name", new Object[0]);
                                    return false;
                                }
                                world.func_175656_a(blockPos, Blocks.field_150417_aV.func_176203_a(received3.func_77960_j()));
                                amount -= 1.6f;
                                if (amount <= 0.0f) {
                                    return false;
                                }
                            }
                        } else if ((this.yEnd - y) % 4 == 0 && y != this.yStart) {
                            ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (block != Blocks.field_150333_U && block != Blocks.field_180389_cP && block != Blocks.field_185771_cX && !OreDictionary.containsMatch((boolean)false, AutoRecipes.slabWood, (ItemStack[])new ItemStack[]{target}) && (world.func_180495_p(blockPos).func_185904_a().func_76222_j() || OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}))) {
                                ItemStack stack2;
                                int stone = UtilInventory.findItems(this.inventory, Item.func_150898_a((Block)Blocks.field_150333_U), Item.func_150898_a((Block)Blocks.field_180389_cP), Item.func_150898_a((Block)Blocks.field_185771_cX));
                                int wood = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.slabWood);
                                if (stone < 0 && wood < 0) {
                                    this.complain(world, "tile.founder.building.msg.slab", new Object[0]);
                                    return false;
                                }
                                stone = stone < 0 ? wood : stone;
                                item = this.inventory.func_70301_a(stone).func_77946_l();
                                item.field_77994_a = 1;
                                received = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                                if (received == null && (stack2 = AutoRecipes.make2SlabsFromBlocks(world, pos, item.func_77973_b(), item.func_77960_j(), this, this.inventory)) != null) {
                                    received = stack2.func_77979_a(1);
                                    if (stack2.field_77994_a > 0) {
                                        UtilInventory.addItemToInventory(this.inventory, stack2);
                                    }
                                }
                                if (received == null) {
                                    this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                                    return false;
                                }
                                world.func_175656_a(blockPos, Block.func_149634_a((Item)item.func_77973_b()).func_176203_a(8 | item.func_77960_j()));
                                amount -= 1.6f;
                                if (amount <= 0.0f) {
                                    return false;
                                }
                            }
                        }
                    }
                    if (x == this.xStart + 1 || x == this.xEnd - 1 || z == this.zStart + 1 || z == this.zEnd - 1) continue;
                    if ((x - 2) % 16 == 0 || (x - 13) % 16 == 0 || (z - 2) % 16 == 0 || (z - 13) % 16 == 0) {
                        if (y > this.yStart + 4 && (this.yEnd - y) % 4 != 0 && ((x - 3) % 16 == 0 || (x - 4) % 16 == 0 || (x - 7) % 16 == 0 || (x - 8) % 16 == 0 || (x - 11) % 16 == 0 || (x - 12) % 16 == 0 || (z - 3) % 16 == 0 || (z - 4) % 16 == 0 || (z - 7) % 16 == 0 || (z - 8) % 16 == 0 || (z - 11) % 16 == 0 || (z - 12) % 16 == 0)) {
                            if (world.func_180495_p(blockPos).func_185904_a() == Material.field_151579_a) {
                                ItemStack received4 = null;
                                int panes = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150410_aZ));
                                if (panes < 0) {
                                    stack = AutoRecipes.make16GlassPanesFromGlassBlock(world, pos, this, this.inventory);
                                    if (stack != null) {
                                        received4 = stack.func_77979_a(1);
                                        if (stack.field_77994_a > 0) {
                                            UtilInventory.addItemToInventory(this.inventory, stack);
                                        }
                                    }
                                } else {
                                    received4 = this.inventory.func_70298_a(panes, 1);
                                }
                                if (received4 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150359_w.func_149739_a() + ".name", new Object[0]);
                                    return false;
                                }
                                world.func_175656_a(blockPos, Blocks.field_150410_aZ.func_176223_P());
                                amount -= 1.6f;
                                if (amount <= 0.0f) {
                                    return false;
                                }
                            }
                        } else {
                            ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (block != Blocks.field_150334_T && block != Blocks.field_180388_cO && block != Blocks.field_185770_cW && block != Blocks.field_150373_bw && block != Blocks.field_150322_A && block != Blocks.field_150347_e && block != Blocks.field_150336_V && block != Blocks.field_150417_aV && block != Blocks.field_150385_bj && block != Blocks.field_150371_ca && !OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{target}) && block != Blocks.field_180395_cM && block != Blocks.field_185767_cT && (world.func_180495_p(blockPos).func_185904_a().func_76222_j() || OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}))) {
                                int stone = UtilInventory.findItems(this.inventory, Item.func_150898_a((Block)Blocks.field_150333_U), Item.func_150898_a((Block)Blocks.field_180389_cP), Item.func_150898_a((Block)Blocks.field_185771_cX));
                                int wood = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.slabWood);
                                if (stone < 0 && wood < 0) {
                                    this.complain(world, "tile.founder.building.msg.slab", new Object[0]);
                                    return false;
                                }
                                stone = stone < 0 ? wood : stone;
                                ItemStack itemSlab = this.inventory.func_70301_a(stone);
                                received = null;
                                List<ItemStack> items = this.getItemFromSlab(world, itemSlab);
                                if (items.isEmpty()) {
                                    this.complain(world, "tile.founder.building.msg.slab", new Object[0]);
                                    return false;
                                }
                                for (ItemStack request : items) {
                                    Block requestBlock = Block.func_149634_a((Item)request.func_77973_b());
                                    if (!Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150348_b) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150322_A) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150347_e) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150336_V) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150417_aV) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150385_bj) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_150371_ca) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_180395_cM) && !Block.func_149680_a((Block)requestBlock, (Block)Blocks.field_185767_cT) && !OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{new ItemStack(request.func_77973_b(), 1, Short.MAX_VALUE)})) continue;
                                    received = UtilInventory.findItemMetaWithMin(this.inventory, 2, request);
                                    if (received == null) {
                                        received = this.requestItem(world, pos, request);
                                    }
                                    if (received == null) continue;
                                    break;
                                }
                                if (received == null) {
                                    this.complainResult(world, lastResult, items.get(0).func_77973_b().func_77667_c(items.get(0)) + ".name", new Object[0]);
                                    return false;
                                }
                                if (received.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150348_b)) {
                                    world.func_175656_a(blockPos, Blocks.field_150334_T.func_176223_P());
                                } else {
                                    world.func_175656_a(blockPos, Block.func_149634_a((Item)received.func_77973_b()).func_176203_a(received.func_77960_j()));
                                }
                                amount -= 1.6f;
                                if (amount <= 0.0f) {
                                    return false;
                                }
                            }
                        }
                    }
                    if (x == this.xStart + 2 || x == this.xEnd - 2 || z == this.zStart + 2 || z == this.zEnd - 2) continue;
                    if ((x == this.xStart + 6 || x == this.xEnd - 6) && z == this.zStart + 3) {
                        ItemStack stack3;
                        if (specifyLadder && !ladderFill) continue;
                        ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                        if (block == Blocks.field_150468_ap || block == Blocks.field_150415_aT || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                        ItemStack received5 = UtilInventory.findItemMetaWithMin(this.inventory, 2, ladder);
                        if (received5 == null && (stack3 = AutoRecipes.make24LaddersFromPlanks(world, pos, this, this.inventory)) != null) {
                            received5 = stack3.func_77979_a(1);
                            if (stack3.field_77994_a > 0) {
                                UtilInventory.addItemToInventory(this.inventory, stack3);
                            }
                        }
                        if (received5 == null) {
                            this.complainResult(world, lastResult, "tile.wood.name", new Object[0]);
                            return false;
                        }
                        world.func_175656_a(blockPos, Blocks.field_150468_ap.func_176203_a(3));
                        amount -= 1.6f;
                        if (!(amount <= 0.0f)) continue;
                        return false;
                    }
                    if (y == this.yStart) {
                        ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                        if (!OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{target}) && block != Blocks.field_150468_ap && block != Blocks.field_150415_aT && (world.func_180495_p(blockPos).func_185904_a().func_76222_j() || OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target}))) {
                            ItemStack received6;
                            if (woodType == null) {
                                int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.plankWood);
                                if (found < 0) {
                                    this.complain(world, "tile.founder.building.msg.floor", new Object[0]);
                                    return false;
                                }
                                ItemStack item2 = this.inventory.func_70301_a(found);
                                woodType = new ItemStack(item2.func_77973_b(), 1, item2.func_77960_j());
                            }
                            if ((received6 = UtilInventory.findItemMetaWithMin(this.inventory, 2, woodType)) == null) {
                                received6 = this.requestItem(world, pos, woodType);
                            }
                            if (received6 == null) {
                                this.complainResult(world, lastResult, woodType.func_77973_b().func_77667_c(woodType) + ".name", new Object[0]);
                                return false;
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)woodType.func_77973_b()).func_176203_a(woodType.func_77960_j()));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return false;
                        }
                        if (woodType != null) continue;
                        woodType = new ItemStack(Item.func_150898_a((Block)block), 1, block.func_176201_c(world.func_180495_p(blockPos)));
                        continue;
                    }
                    if ((this.yEnd - y) % 4 == 0 && (x != this.xStart + 6 && x != this.xEnd - 6 || z != this.zStart + 3)) {
                        ItemStack received7;
                        if (!((x - 4) % 16 != 0 && (x - 11) % 16 != 0 || (z - 4) % 16 != 0 && (z - 11) % 16 != 0)) {
                            ItemStack received8;
                            ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                            if (block == Blocks.field_150359_w || block == Blocks.field_150426_aN || block == Blocks.field_180398_cJ || block == Blocks.field_150478_aa || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                            if (y != this.yEnd && world.field_73012_v.nextFloat() <= lightingChance) {
                                ItemStack torches;
                                int found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150426_aN));
                                if (found < 0) {
                                    found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_180398_cJ));
                                }
                                if (found < 0) {
                                    found = UtilInventory.findItem(this.inventory, Item.func_150898_a((Block)Blocks.field_150478_aa));
                                }
                                if (found < 0) {
                                    TextComponentTranslation light = new TextComponentTranslation("%s/%s/%s", new Object[]{new TextComponentTranslation(Blocks.field_150426_aN.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Blocks.field_180398_cJ.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Blocks.field_150478_aa.func_149739_a() + ".name", new Object[0])});
                                    this.complain(world, "tile.founder.building.msg.light", light);
                                    return false;
                                }
                                item = this.inventory.func_70301_a(found).func_77946_l();
                                item.field_77994_a = 1;
                                received8 = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
                                if (received8 == null && (received8 = this.requestItem(world, pos, item)) == null && item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) && (torches = AutoRecipes.make8TorchesFromCoalAndPlanks(world, pos, this, this.inventory)) != null) {
                                    received8 = torches.func_77979_a(1);
                                    if (torches.field_77994_a > 0) {
                                        UtilInventory.addItemToInventory(this.inventory, torches);
                                    }
                                }
                                if (received8 == null) {
                                    this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                                    return false;
                                }
                            } else {
                                received8 = UtilInventory.findItem(this.inventory, glass);
                                if (received8 == null) {
                                    received8 = this.requestItem(world, pos, glass);
                                }
                                if (received8 == null) {
                                    this.complainResult(world, lastResult, Blocks.field_150359_w.func_149739_a() + ".name", new Object[0]);
                                    return false;
                                }
                            }
                            world.func_175656_a(blockPos, Block.func_149634_a((Item)received8.func_77973_b()).func_176203_a(received8.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) ? 3 : 0));
                            amount -= 1.6f;
                            if (!(amount <= 0.0f)) continue;
                            return false;
                        }
                        ItemStack target = new ItemStack(Item.func_150898_a((Block)block), 1, Short.MAX_VALUE);
                        if (OreDictionary.containsMatch((boolean)false, AutoRecipes.plankWood, (ItemStack[])new ItemStack[]{target}) || !world.func_180495_p(blockPos).func_185904_a().func_76222_j() && !OreDictionary.containsMatch((boolean)false, AutoRecipes.minable, (ItemStack[])new ItemStack[]{target})) continue;
                        if (woodType == null) {
                            int found = UtilInventory.findItemDictionary(this.inventory, AutoRecipes.plankWood);
                            if (found < 0) {
                                this.complain(world, "tile.founder.building.msg.floor", new Object[0]);
                                return false;
                            }
                            ItemStack item3 = this.inventory.func_70301_a(found);
                            woodType = new ItemStack(item3.func_77973_b(), 1, item3.func_77960_j());
                        }
                        if ((received7 = UtilInventory.findItemMetaWithMin(this.inventory, 2, woodType)) == null) {
                            received7 = this.requestItem(world, pos, woodType);
                        }
                        if (received7 == null) {
                            this.complainResult(world, lastResult, woodType.func_77973_b().func_77667_c(woodType) + ".name", new Object[0]);
                            return false;
                        }
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)woodType.func_77973_b()).func_176203_a(woodType.func_77960_j()));
                        amount -= 1.6f;
                        if (!(amount <= 0.0f)) continue;
                        return false;
                    }
                    if (y == this.yEnd || y <= this.yStart + 1 || (this.yEnd + 1 - y) % 4 != 0 || (x - 4) % 16 != 0 && (x - 11) % 16 != 0 || (z - 4) % 16 != 0 && (z - 11) % 16 != 0) continue;
                    if (Block.func_149680_a((Block)block, (Block)Blocks.field_150474_ac)) {
                        this.complain(world, "tile.founder.building.msg.security", new Object[0]);
                        return false;
                    }
                    if (!world.func_180495_p(blockPos).func_185904_a().func_76222_j()) continue;
                    ItemStack received9 = UtilInventory.findItem(this.inventory, crafting_table);
                    if (received9 == null) {
                        received9 = AutoRecipes.make1CraftingTableFromPlanks(world, pos, this, this.inventory);
                    }
                    if (received9 == null) {
                        this.complainResult(world, lastResult, Blocks.field_150462_ai.func_149739_a() + ".name", new Object[0]);
                        return false;
                    }
                    world.func_175656_a(blockPos, Blocks.field_150462_ai.func_176223_P());
                    amount -= 1.6f;
                    if (!(amount <= 0.0f)) continue;
                    return false;
                }
            }
        }
        this.addStatsToPlayers(world, this.maxHeight <= 16 ? 17 : 20);
        return true;
    }
}

