/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.CitiesMod;
import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockDistributor
extends BlockFounder {
    public static float feeRate = 0.03f;
    public static int maxFee = 1000;

    public BlockDistributor() {
        super(3, 0, 8);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175640_z(pos)) {
            return;
        }
        super.func_180645_a(world, pos, state, rand);
        if (this.chance <= 0.1f) {
            this.collectFee(world, pos);
            if (!this.eat(world, pos, 1, 0.0f)) {
                return;
            }
        }
        this.requestGoods(world, pos);
    }

    @Override
    public boolean canContain(IFounder block) {
        return true;
    }

    @Override
    public boolean canBeContainedIn(IFounder block) {
        return block.isBuilding();
    }

    @Override
    public int minInventory() {
        return 1;
    }

    @Override
    public IFounder.DISTRIBUTOR_PRIORITY getDistributorPriority() {
        return IFounder.DISTRIBUTOR_PRIORITY.PRIORITY_1;
    }

    @Override
    public boolean canAcceptPayment() {
        return true;
    }

    @Override
    protected List<IInventory> getDistributors(World world, BlockPos pos) {
        if (this.distributors == null) {
            this.distributors = new ArrayList();
            ArrayList<IInventory> distributors0 = new ArrayList<IInventory>();
            ArrayList<IInventory> distributors2 = new ArrayList<IInventory>();
            ArrayList<IInventory> distributors3 = new ArrayList<IInventory>();
            List list = world.field_175730_i;
            block5: for (int i = 0; i < list.size(); ++i) {
                Block block;
                TileEntity t = (TileEntity)list.get(i);
                if (!(t.func_145835_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= 7225.0) || !((block = t.func_145838_q()) instanceof IFounder) || ((IFounder)block).getDistributorPriority() == IFounder.DISTRIBUTOR_PRIORITY.PRIORITY_1 || !((IFounder)block).canRequestFrom()) continue;
                switch (((IFounder)block).getDistributorPriority()) {
                    case PRIORITY_0: {
                        distributors0.add((IInventory)t);
                        continue block5;
                    }
                    case PRIORITY_2: {
                        distributors2.add((IInventory)t);
                        continue block5;
                    }
                    case PRIORITY_3: {
                        distributors3.add((IInventory)t);
                        continue block5;
                    }
                }
            }
            if (!distributors0.isEmpty()) {
                Collections.shuffle(distributors0, world.field_73012_v);
                this.distributors.addAll(distributors0);
            }
            if (!distributors2.isEmpty()) {
                Collections.shuffle(distributors2, world.field_73012_v);
                this.distributors.addAll(distributors2);
            }
            if (!distributors3.isEmpty()) {
                Collections.shuffle(distributors3, world.field_73012_v);
                this.distributors.addAll(distributors3);
            }
        }
        return this.distributors;
    }

    private void collectFee(World world, BlockPos pos) {
        if (this.coinPouch == null) {
            return;
        }
        List<IInventory> list = this.getDistributors(world, pos);
        for (int i = 0; i < list.size(); ++i) {
            int amount;
            int vendorMoney;
            IInventory distributor = list.get(i);
            Block block = ((TileEntity)distributor).func_145838_q();
            if (block instanceof IFounder && ((IFounder)block).isBuilding() || (vendorMoney = UtilInventory.findItem(distributor, CitiesMod.coinPouch)) < 0 || (amount = distributor.func_70301_a(vendorMoney).func_82838_A()) < feeExemptionThreshold) continue;
            int cost = Math.min(maxFee, (int)((float)amount * feeRate));
            distributor.func_70301_a(vendorMoney).func_82841_c(distributor.func_70301_a(vendorMoney).func_82838_A() - cost);
            this.coinPouch.func_82841_c(this.coinPouch.func_82838_A() + cost);
        }
    }

    private void requestGoods(World world, BlockPos pos) {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a >= Math.min(stack.func_77976_d(), this.inventory.func_70297_j_())) continue;
            int num = Math.min(stack.func_77976_d(), this.inventory.func_70297_j_()) - stack.field_77994_a;
            ItemStack received = this.requestItem(world, pos, new ItemStack(stack.func_77973_b(), num, stack.func_77960_j()), false);
            if (received == null) continue;
            stack.field_77994_a += received.field_77994_a;
        }
    }
}

