/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.common.Market;
import com.dooglamoo.citiesmod.inventory.AutoRecipes;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class BlockCraftsman
extends BlockFounder {
    private static final ItemStack sand_8 = new ItemStack((Block)Blocks.field_150354_m, 8);
    private static final ItemStack clayBall_8 = new ItemStack(Items.field_151119_aD, 8);
    private static final ItemStack glass_8 = new ItemStack(Blocks.field_150359_w, 8);
    private static final ItemStack brick_4 = new ItemStack(Items.field_151118_aC, 4);
    private static final ItemStack coal = new ItemStack(Items.field_151044_h, 1, 0);
    private static final ItemStack charcoal = new ItemStack(Items.field_151044_h, 1, 1);

    public BlockCraftsman() {
        super(3, 0, 8);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175640_z(pos)) {
            return;
        }
        super.func_180645_a(world, pos, state, rand);
        if (this.chance <= 0.1f && !this.eat(world, pos, 1, 0.0f)) {
            return;
        }
        if (world.func_72820_D() % 24000L >= 18000L) {
            return;
        }
        if (UtilInventory.isSlotsFull(this.inventory)) {
            if (showInventoryFullMsg) {
                this.complain(world, "tile.founder.msg.full", new Object[0]);
            }
            return;
        }
        this.findFurnace(world);
        this.complained = false;
        this.busy = false;
        this.fillKiln(world, pos);
        this.craftStainedGlass(world, pos, 2);
        this.craftBrick(world, pos, 16);
    }

    @Override
    public boolean canContain(IFounder block) {
        return true;
    }

    @Override
    public boolean canBeContainedIn(IFounder block) {
        return block.isBuilding();
    }

    @Override
    public int minInventory() {
        return 1;
    }

    private void fillKiln(World world, BlockPos pos) {
        BlockFounder.TransactionResult lastItemResult = BlockFounder.TransactionResult.SUCCESS;
        BlockFounder.TransactionResult lastFuelResult = BlockFounder.TransactionResult.SUCCESS;
        lastResult = BlockFounder.TransactionResult.SUCCESS;
        for (int i = 0; i < this.furnaces.size(); ++i) {
            TileEntityFurnace furnace = (TileEntityFurnace)this.furnaces.get(i);
            if (furnace.func_70301_a(2) != null && !UtilInventory.isSlotsFull(this.inventory)) {
                ItemStack stack = furnace.func_70298_a(2, furnace.func_70301_a((int)2).field_77994_a);
                this.addItemToInventory(stack, this.coinPouch);
                this.busy = true;
            }
            if (furnace.func_145950_i()) continue;
            if (furnace.func_70301_a(0) == null) {
                ItemStack receivedClay;
                ItemStack receivedSand = UtilInventory.findItem(this.inventory, sand_8);
                if (receivedSand == null) {
                    receivedSand = this.requestItem(world, pos, sand_8);
                }
                if ((receivedClay = UtilInventory.findItem(this.inventory, clayBall_8)) == null) {
                    receivedClay = this.requestItem(world, pos, clayBall_8);
                }
                if (receivedSand == null) {
                    if (receivedClay == null) {
                        lastItemResult = lastResult;
                    } else {
                        furnace.func_70299_a(0, receivedClay);
                        this.busy = true;
                    }
                } else {
                    if (receivedClay == null) {
                        furnace.func_70299_a(0, receivedSand);
                    } else if (world.field_73012_v.nextFloat() < 0.5f) {
                        UtilInventory.addItemToInventory(this.inventory, receivedClay);
                        furnace.func_70299_a(0, receivedSand);
                    } else {
                        UtilInventory.addItemToInventory(this.inventory, receivedSand);
                        furnace.func_70299_a(0, receivedClay);
                    }
                    this.busy = true;
                }
            }
            if (furnace.func_70301_a(1) != null) continue;
            ItemStack received = UtilInventory.findItemsMeta(this.inventory, coal, charcoal);
            if (received == null && (received = this.requestItem(world, pos, coal)) == null) {
                received = this.requestItem(world, pos, charcoal);
            }
            if (received == null) {
                lastFuelResult = lastResult;
                continue;
            }
            furnace.func_70299_a(1, received);
            this.busy = true;
        }
        if (lastItemResult != BlockFounder.TransactionResult.SUCCESS) {
            this.complainResult(world, lastItemResult, "%s/%s", new TextComponentTranslation(Blocks.field_150354_m.func_149739_a() + ".name", new Object[0]), new TextComponentTranslation(Items.field_151119_aD.func_77658_a() + ".name", new Object[0]));
            this.complained = true;
        }
        if (lastFuelResult != BlockFounder.TransactionResult.SUCCESS) {
            this.complainResult(world, lastFuelResult, Items.field_151044_h.func_77658_a() + ".name", new Object[0]);
            this.complained = true;
        }
    }

    private void craftStainedGlass(World world, BlockPos pos, int amount) {
        while (amount > 0) {
            ItemStack stack;
            if (UtilInventory.isSlotsFull(this.inventory)) {
                return;
            }
            int found = UtilInventory.findItem(this.inventory, Items.field_151100_aR);
            if (found < 0) {
                return;
            }
            ItemStack item = this.inventory.func_70301_a(found).func_77946_l();
            item.field_77994_a = 1;
            ItemStack receivedDye = UtilInventory.findItemMetaWithMin(this.inventory, 2, item);
            if (receivedDye == null) {
                receivedDye = this.requestItem(world, pos, item);
            }
            if (receivedDye == null && (stack = this.craftDye(world, pos, item.func_77960_j())) != null) {
                receivedDye = stack.func_77979_a(1);
                if (stack.field_77994_a > 0) {
                    UtilInventory.addItemToInventory(this.inventory, stack);
                }
            }
            if (receivedDye == null) {
                this.complainResult(world, lastResult, item.func_77973_b().func_77667_c(item) + ".name", new Object[0]);
                this.complained = true;
                return;
            }
            this.busy = true;
            ItemStack received = UtilInventory.findItem(this.inventory, glass_8);
            if (received == null) {
                received = this.requestItem(world, pos, glass_8);
            } else if (this.coinPouch != null && !expertMode) {
                this.coinPouch.func_82841_c(Math.max(0, this.coinPouch.func_82838_A() - Market.getPrice(received) * received.field_77994_a));
            }
            if (received == null) {
                UtilInventory.addItemToInventory(this.inventory, receivedDye);
                this.complainResult(world, lastResult, Blocks.field_150359_w.func_149739_a() + ".name", new Object[0]);
                this.complained = true;
                return;
            }
            int color = 15 - receivedDye.func_77960_j();
            this.addItemToInventory(new ItemStack((Block)Blocks.field_150399_cn, 8, color), this.coinPouch);
            --amount;
        }
    }

    private void craftBrick(World world, BlockPos pos, int amount) {
        while (amount > 0) {
            if (UtilInventory.isSlotsFull(this.inventory)) {
                return;
            }
            ItemStack received = UtilInventory.findItem(this.inventory, brick_4);
            if (received == null) {
                received = this.requestItem(world, pos, brick_4);
            } else if (this.coinPouch != null && !expertMode) {
                this.coinPouch.func_82841_c(Math.max(0, this.coinPouch.func_82838_A() - Market.getPrice(received) * received.field_77994_a));
            }
            if (received == null) {
                if (!this.complained && !this.busy) {
                    this.complainResult(world, lastResult, Items.field_151118_aC.func_77658_a() + ".name", new Object[0]);
                }
                return;
            }
            this.addItemToInventory(new ItemStack(Item.func_150898_a((Block)Blocks.field_150336_V), 1), this.coinPouch);
            --amount;
        }
    }

    private ItemStack craftDye(World world, BlockPos pos, int dyeMeta) {
        switch (dyeMeta) {
            case 1: {
                return AutoRecipes.make2RedFrom1Rose(world, pos, this, this.inventory);
            }
            case 5: {
                return AutoRecipes.make4PurpleFrom1Rose2Lapis(world, pos, this, this.inventory);
            }
            case 6: {
                return AutoRecipes.make2CyanFrom1Green1Lapis(world, pos, this, this.inventory);
            }
            case 7: {
                return AutoRecipes.make3LightgrayFrom1Ink2White(world, pos, this, this.inventory);
            }
            case 8: {
                return AutoRecipes.make2GrayFrom1Ink1White(world, pos, this, this.inventory);
            }
            case 9: {
                return AutoRecipes.make2PinkFrom1Peony(world, pos, this, this.inventory);
            }
            case 10: {
                return AutoRecipes.make2LimeFrom1Green1White(world, pos, this, this.inventory);
            }
            case 11: {
                return AutoRecipes.make2YellowFrom1Sunflower(world, pos, this, this.inventory);
            }
            case 12: {
                return AutoRecipes.make2LightblueFrom1Lapis1White(world, pos, this, this.inventory);
            }
            case 13: {
                return AutoRecipes.make2MagentaFrom1Lilac(world, pos, this, this.inventory);
            }
            case 14: {
                return AutoRecipes.make4OrangeFrom1Rose1Sunflower(world, pos, this, this.inventory);
            }
        }
        return null;
    }
}

