/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.inventory.AutoRecipes;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockCarpenter
extends BlockFounder {
    private static final ItemStack string_2 = new ItemStack(Items.field_151007_F, 2);
    private static final ItemStack cobblestone = new ItemStack(Blocks.field_150347_e);
    private static final ItemStack cobblestone_2 = new ItemStack(Blocks.field_150347_e, 2);
    private static final ItemStack cobblestone_3 = new ItemStack(Blocks.field_150347_e, 3);
    private static final ItemStack stick_2 = new ItemStack(Items.field_151055_y, 2);
    private static final ItemStack stick_3 = new ItemStack(Items.field_151055_y, 3);

    public BlockCarpenter() {
        super(3, 0, 8);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175640_z(pos)) {
            return;
        }
        super.func_180645_a(world, pos, state, rand);
        if (this.chance <= 0.1f && !this.eat(world, pos, 1, 0.0f)) {
            return;
        }
        if (world.func_72820_D() % 24000L >= 18000L) {
            return;
        }
        if (UtilInventory.isSlotsFull(this.inventory)) {
            if (showInventoryFullMsg) {
                this.complain(world, "tile.founder.msg.full", new Object[0]);
            }
            return;
        }
        this.makeTool(world, pos, 0);
        this.makeTool(world, pos, 1);
        this.makeTool(world, pos, 2);
        this.makeTool(world, pos, 3);
        this.makeFishingRod(world, pos);
        this.makePlanks(world, pos, 8);
    }

    @Override
    public boolean canContain(IFounder block) {
        return true;
    }

    @Override
    public boolean canBeContainedIn(IFounder block) {
        return block.isBuilding();
    }

    @Override
    public IFounder.DISTRIBUTOR_PRIORITY getDistributorPriority() {
        return IFounder.DISTRIBUTOR_PRIORITY.PRIORITY_2;
    }

    private void makeFishingRod(World world, BlockPos pos) {
        ItemStack stack;
        if (UtilInventory.isSlotsFull(this.inventory) || UtilInventory.findItem(this.inventory, (Item)Items.field_151112_aM) >= 0) {
            return;
        }
        ItemStack receivedSticks = UtilInventory.findItem(this.inventory, stick_3);
        if (receivedSticks == null && (stack = AutoRecipes.make8SticksFromLog(world, pos, this, this.inventory)) != null) {
            receivedSticks = stack.func_77979_a(3);
            if (stack.field_77994_a > 0) {
                UtilInventory.addItemToInventory(this.inventory, stack);
            }
        }
        if (receivedSticks == null && (stack = AutoRecipes.make4SticksFromPlanks(world, pos, this, this.inventory)) != null) {
            receivedSticks = stack.func_77979_a(3);
            if (stack.field_77994_a > 0) {
                UtilInventory.addItemToInventory(this.inventory, stack);
            }
        }
        if (receivedSticks == null) {
            this.complainResult(world, lastResult, "tile.log.name", new Object[0]);
            return;
        }
        ItemStack receivedString = UtilInventory.findItem(this.inventory, string_2);
        if (receivedString == null) {
            receivedString = this.requestItem(world, pos, string_2);
        }
        if (receivedString == null) {
            UtilInventory.addItemToInventory(this.inventory, receivedSticks);
            this.complainResult(world, lastResult, Items.field_151007_F.func_77658_a() + ".name", new Object[0]);
            return;
        }
        this.addItemToInventory(new ItemStack((Item)Items.field_151112_aM), this.coinPouch);
    }

    private void makePlanks(World world, BlockPos pos, int amount) {
        while (amount > 0) {
            if (UtilInventory.isSlotsFull(this.inventory)) {
                return;
            }
            ItemStack received = AutoRecipes.make4PlanksFromLog(world, pos, this, this.inventory);
            if (received != null) {
                this.addItemToInventory(received, this.coinPouch);
                --amount;
                continue;
            }
            this.complainResult(world, lastResult, "tile.log.name", new Object[0]);
            return;
        }
    }

    private boolean makeTool(World world, BlockPos pos, int id) {
        ItemStack stack;
        if (UtilInventory.isSlotsFull(this.inventory)) {
            return false;
        }
        switch (id) {
            case 0: {
                if (UtilInventory.findItem(this.inventory, Items.field_151051_r) < 0) break;
                return false;
            }
            case 1: {
                if (UtilInventory.findItem(this.inventory, Items.field_151049_t) < 0) break;
                return false;
            }
            case 2: {
                if (UtilInventory.findItem(this.inventory, Items.field_151050_s) < 0) break;
                return false;
            }
            case 3: {
                if (UtilInventory.findItem(this.inventory, Items.field_151018_J) < 0) break;
                return false;
            }
        }
        ItemStack receivedSticks = UtilInventory.findItem(this.inventory, stick_2);
        if (receivedSticks == null && (stack = AutoRecipes.make8SticksFromLog(world, pos, this, this.inventory)) != null) {
            receivedSticks = stack.func_77979_a(2);
            if (stack.field_77994_a > 0) {
                UtilInventory.addItemToInventory(this.inventory, stack);
            }
        }
        if (receivedSticks == null && (stack = AutoRecipes.make4SticksFromPlanks(world, pos, this, this.inventory)) != null) {
            receivedSticks = stack.func_77979_a(2);
            if (stack.field_77994_a > 0) {
                UtilInventory.addItemToInventory(this.inventory, stack);
            }
        }
        if (receivedSticks == null) {
            this.complainResult(world, lastResult, "tile.log.name", new Object[0]);
            return false;
        }
        ItemStack receivedCobble = null;
        switch (id) {
            case 0: {
                receivedCobble = UtilInventory.findItem(this.inventory, cobblestone);
                if (receivedCobble == null) {
                    receivedCobble = this.requestItem(world, pos, cobblestone);
                }
                if (receivedCobble == null) {
                    UtilInventory.addItemToInventory(this.inventory, receivedSticks);
                    this.complainResult(world, lastResult, Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]);
                    return false;
                }
                this.addItemToInventory(new ItemStack(Items.field_151051_r), this.coinPouch);
                break;
            }
            case 1: {
                receivedCobble = UtilInventory.findItem(this.inventory, cobblestone_3);
                if (receivedCobble == null) {
                    receivedCobble = this.requestItem(world, pos, cobblestone_3);
                }
                if (receivedCobble == null) {
                    UtilInventory.addItemToInventory(this.inventory, receivedSticks);
                    this.complainResult(world, lastResult, Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]);
                    return false;
                }
                this.addItemToInventory(new ItemStack(Items.field_151049_t), this.coinPouch);
                break;
            }
            case 2: {
                receivedCobble = UtilInventory.findItem(this.inventory, cobblestone_3);
                if (receivedCobble == null) {
                    receivedCobble = this.requestItem(world, pos, cobblestone_3);
                }
                if (receivedCobble == null) {
                    UtilInventory.addItemToInventory(this.inventory, receivedSticks);
                    this.complainResult(world, lastResult, Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]);
                    return false;
                }
                this.addItemToInventory(new ItemStack(Items.field_151050_s), this.coinPouch);
                break;
            }
            case 3: {
                receivedCobble = UtilInventory.findItem(this.inventory, cobblestone_2);
                if (receivedCobble == null) {
                    receivedCobble = this.requestItem(world, pos, cobblestone_2);
                }
                if (receivedCobble == null) {
                    UtilInventory.addItemToInventory(this.inventory, receivedSticks);
                    this.complainResult(world, lastResult, Blocks.field_150347_e.func_149739_a() + ".name", new Object[0]);
                    return false;
                }
                this.addItemToInventory(new ItemStack(Items.field_151018_J), this.coinPouch);
            }
        }
        return true;
    }
}

