/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.CitiesMod;
import com.dooglamoo.citiesmod.block.BlockBuyer;
import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.BlockSeller;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.common.Market;
import com.dooglamoo.citiesmod.inventory.AutoRecipes;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import com.dooglamoo.citiesmod.tileentity.TileEntityFounder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;

public abstract class BlockBuilding
extends BlockFounder {
    protected static final ItemStack torch = new ItemStack(Blocks.field_150478_aa);
    protected static final ItemStack glowstone = new ItemStack(Blocks.field_150426_aN);
    protected static final ItemStack sea_lantern = new ItemStack(Blocks.field_180398_cJ);
    protected static final ItemStack glass = new ItemStack(Blocks.field_150359_w);
    protected static final ItemStack stonebrick = new ItemStack(Blocks.field_150417_aV);
    protected static final ItemStack stonebrick_stairs = new ItemStack(Blocks.field_150390_bg);
    protected static final ItemStack ladder = new ItemStack(Blocks.field_150468_ap);
    protected static final float PLAYER_TIME = 1.6f;
    protected static final float PLAYER_FAST_TIME = 1.3f;
    protected static final float TICK_TIME = 68.27f;
    public static float lightingChance = 0.3f;
    public static float investmentFeeRate = 0.02f;
    public static boolean specifyLadder = false;
    protected final int MIN_INVESTMENT;
    protected final int MIN_COMMUNITY;
    protected TileEntityFounder seller;
    protected TileEntityFounder buyer;
    protected List<Item> trades = new ArrayList<Item>();
    private int maxSale = 0;
    private int maxBuy = 0;
    private static List<String> traded = new ArrayList<String>();

    public BlockBuilding(int maxHeight, int minHeight, int lotSize, int minInvestment, int minCommunity) {
        super(maxHeight, minHeight, lotSize);
        this.MIN_INVESTMENT = minInvestment;
        this.MIN_COMMUNITY = minCommunity;
    }

    @Override
    public boolean canContain(IFounder block) {
        return !block.isBuilding();
    }

    @Override
    public boolean canBeContainedIn(IFounder block) {
        return !block.isBuilding();
    }

    @Override
    public int minInventory() {
        return 1;
    }

    @Override
    public boolean isBuilding() {
        return true;
    }

    @Override
    public boolean canAcceptPayment() {
        return true;
    }

    @Override
    public boolean canRequestFrom() {
        return false;
    }

    protected List<IInventory> getInvestors(World world, BlockPos pos) {
        ArrayList<IInventory> investors = new ArrayList<IInventory>();
        List list = world.field_175730_i;
        for (int i = 0; i < list.size(); ++i) {
            Block block;
            TileEntity t = (TileEntity)list.get(i);
            if (t == this.inventory || !(t.func_145835_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= 7225.0) || !((block = t.func_145838_q()) instanceof IFounder) || block instanceof BlockBuyer || block instanceof BlockSeller) continue;
            investors.add((IInventory)t);
        }
        Collections.shuffle(investors, world.field_73012_v);
        return investors;
    }

    protected void exportGoods(World world, BlockPos pos) {
        if (this.buyer != null) {
            if (this.seller != null) {
                int sellerCoinPouchSlot = UtilInventory.findItem((IInventory)this.seller, CitiesMod.coinPouch);
                int buyerCoinPouchSlot = UtilInventory.findItem((IInventory)this.buyer, CitiesMod.coinPouch);
                if (sellerCoinPouchSlot >= 0 && buyerCoinPouchSlot >= 0) {
                    ItemStack sellerCoinPouchStack = this.seller.func_70301_a(sellerCoinPouchSlot);
                    ItemStack buyerCoinPouchStack = this.buyer.func_70301_a(buyerCoinPouchSlot);
                    buyerCoinPouchStack.func_82841_c(buyerCoinPouchStack.func_82838_A() + sellerCoinPouchStack.func_82838_A());
                    sellerCoinPouchStack.func_82841_c(0);
                }
            }
            int buyerCoinPouchSlot = UtilInventory.findItem((IInventory)this.buyer, CitiesMod.coinPouch);
            if (this.coinPouch != null && buyerCoinPouchSlot >= 0) {
                ItemStack buyerCoinPouchStack = this.buyer.func_70301_a(buyerCoinPouchSlot);
                int amount = this.coinPouch.func_82838_A() / 10;
                if (buyerCoinPouchStack.func_82838_A() < amount) {
                    buyerCoinPouchStack.func_82841_c(buyerCoinPouchStack.func_82838_A() + amount);
                    this.coinPouch.func_82841_c(this.coinPouch.func_82838_A() - amount);
                }
            }
        }
        if (this.buyer == null || this.coinPouch == null) {
            return;
        }
        int sale = 0;
        traded.clear();
        for (int i = 0; i < this.buyer.func_70302_i_(); ++i) {
            ItemStack stack = this.buyer.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == CitiesMod.coinPouch) continue;
            if (this.trades.contains(stack.func_77973_b())) {
                ItemStack goods = null;
                if (stack.field_77994_a > 1) {
                    goods = this.buyer.func_70298_a(i, stack.field_77994_a - 1);
                }
                if (goods == null) continue;
                int cost = Market.getPrice(goods) * goods.field_77994_a;
                this.coinPouch.func_82841_c(this.coinPouch.func_82838_A() + cost);
                if (sale == 0) {
                    this.addStatsToPlayers(world, 12);
                }
                sale += cost;
                if (traded.contains(goods.func_77973_b().func_77667_c(goods) + ".name")) continue;
                traded.add(goods.func_77973_b().func_77667_c(goods) + ".name");
                continue;
            }
            this.complain(world, "tile.founder.building.msg.noExport", stack.func_77973_b().func_77667_c(stack) + ".name");
        }
        if (sale > this.maxSale) {
            this.maxSale = sale;
            String tradedStr = "";
            Object[] args = new Object[traded.size()];
            for (int i = 0; i < traded.size(); ++i) {
                if (i >= 3) {
                    tradedStr = tradedStr + " ... ";
                    break;
                }
                tradedStr = tradedStr + " %s,";
                args[i] = new TextComponentTranslation(traded.get(i), new Object[0]);
            }
            tradedStr = tradedStr.substring(1, tradedStr.length() - 1);
            TextComponentTranslation tradedTxt = new TextComponentTranslation(tradedStr, args);
            this.complain(world, "tile.founder.building.msg.export", sale, tradedTxt);
        }
    }

    protected void importGoods(World world, BlockPos pos) {
        if (this.seller == null || this.coinPouch == null) {
            return;
        }
        int sale = 0;
        traded.clear();
        for (int i = 0; i < this.seller.func_70302_i_(); ++i) {
            ItemStack stack = this.seller.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == CitiesMod.coinPouch) continue;
            if (this.trades.contains(stack.func_77973_b()) && !AutoRecipes.banned.contains(stack.func_77973_b())) {
                if (stack.field_77994_a >= Math.min(stack.func_77976_d(), this.seller.func_70297_j_())) continue;
                int num = Math.min(stack.func_77976_d(), this.seller.func_70297_j_());
                num -= stack.field_77994_a;
                int price = Market.getPrice(stack);
                if (price != 0 && (num = Math.min(num, this.coinPouch.func_82838_A() / price)) == 0) continue;
                int cost = price * num;
                this.coinPouch.func_82841_c(this.coinPouch.func_82838_A() - cost);
                stack.field_77994_a += num;
                if (sale == 0) {
                    this.addStatsToPlayers(world, 13);
                }
                sale += cost;
                if (traded.contains(stack.func_77973_b().func_77667_c(stack) + ".name")) continue;
                traded.add(stack.func_77973_b().func_77667_c(stack) + ".name");
                continue;
            }
            this.complain(world, "tile.founder.building.msg.noImport", stack.func_77973_b().func_77667_c(stack) + ".name");
        }
        if (sale > this.maxBuy) {
            this.maxBuy = sale;
            String tradedStr = "";
            Object[] args = new Object[traded.size()];
            for (int i = 0; i < traded.size(); ++i) {
                if (i >= 3) {
                    tradedStr = tradedStr + " ... ";
                    break;
                }
                tradedStr = tradedStr + " %s,";
                args[i] = new TextComponentTranslation(traded.get(i), new Object[0]);
            }
            tradedStr = tradedStr.substring(1, tradedStr.length() - 1);
            TextComponentTranslation tradedTxt = new TextComponentTranslation(tradedStr, args);
            this.complain(world, "tile.founder.building.msg.import", sale, tradedTxt);
        }
    }

    protected void collectInvestment(World world, BlockPos pos, int minInvestment) {
        if (this.coinPouch == null) {
            return;
        }
        List<IInventory> list = this.getInvestors(world, pos);
        for (int i = 0; i < list.size() && this.coinPouch.func_82838_A() < minInvestment; ++i) {
            int amount;
            IInventory distributor = list.get(i);
            int vendorMoney = UtilInventory.findItem(distributor, CitiesMod.coinPouch);
            if (vendorMoney < 0 || (amount = distributor.func_70301_a(vendorMoney).func_82838_A()) < feeExemptionThreshold) continue;
            int investment = Math.min((int)((float)amount * investmentFeeRate), Math.max(0, minInvestment - this.coinPouch.func_82838_A()));
            distributor.func_70301_a(vendorMoney).func_82841_c(distributor.func_70301_a(vendorMoney).func_82838_A() - investment);
            this.coinPouch.func_82841_c(this.coinPouch.func_82838_A() + investment);
            if (this.coinPouch.func_82838_A() >= minInvestment) break;
        }
    }

    protected List<ItemStack> getItemFromSlab(World world, ItemStack slab) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (IRecipe obj : CraftingManager.func_77594_a().func_77592_b()) {
            Object[] ingredients;
            ShapedRecipes recipe;
            if (obj.func_77571_b() == null || !obj.func_77571_b().func_77969_a(slab)) continue;
            if (obj instanceof ShapedRecipes) {
                recipe = (ShapedRecipes)obj;
                ingredients = recipe.field_77574_d;
                if (ingredients.length != 3 || !ingredients[0].func_77969_a(ingredients[1]) || !ingredients[0].func_77969_a(ingredients[2])) continue;
                items.add(ingredients[0]);
                continue;
            }
            if (!(obj instanceof ShapedOreRecipe) || (ingredients = (recipe = (ShapedOreRecipe)obj).getInput()).length != 3) continue;
            if (ingredients[0] instanceof ItemStack) {
                items.add(ingredients[0]);
                continue;
            }
            if (!(ingredients[0] instanceof List) || ((List)ingredients[0]).size() <= 0) continue;
            for (Object l : (List)ingredients[0]) {
                if (!(l instanceof ItemStack)) continue;
                items.add((ItemStack)l);
            }
        }
        return items;
    }
}

