/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.common.Market;
import com.dooglamoo.citiesmod.inventory.AutoRecipes;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockBlacksmith
extends BlockFounder {
    private static final ItemStack ironOre_8 = new ItemStack(Blocks.field_150366_p, 8);
    private static final ItemStack ironIngot_9 = new ItemStack(Items.field_151042_j, 9);
    private static final ItemStack coal = new ItemStack(Items.field_151044_h, 1, 0);
    private static final ItemStack charcoal = new ItemStack(Items.field_151044_h, 1, 1);

    public BlockBlacksmith() {
        super(3, 0, 8);
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175640_z(pos)) {
            return;
        }
        super.func_180645_a(world, pos, state, rand);
        if (this.chance <= 0.1f && !this.eat(world, pos, 1, 0.0f)) {
            return;
        }
        if (world.func_72820_D() % 24000L >= 18000L) {
            return;
        }
        if (UtilInventory.isSlotsFull(this.inventory)) {
            if (showInventoryFullMsg) {
                this.complain(world, "tile.founder.msg.full", new Object[0]);
            }
            return;
        }
        this.findFurnace(world);
        this.smeltOre(world, pos);
        this.makeTool(world, pos, 0);
        this.makeTool(world, pos, 1);
        this.makeTool(world, pos, 2);
        this.makeTool(world, pos, 3);
        this.makeIronBlocks(world, pos, 1);
    }

    @Override
    public boolean canContain(IFounder block) {
        return true;
    }

    @Override
    public boolean canBeContainedIn(IFounder block) {
        return block.isBuilding();
    }

    @Override
    public IFounder.DISTRIBUTOR_PRIORITY getDistributorPriority() {
        return IFounder.DISTRIBUTOR_PRIORITY.PRIORITY_2;
    }

    private void smeltOre(World world, BlockPos pos) {
        BlockFounder.TransactionResult lastOreResult = BlockFounder.TransactionResult.SUCCESS;
        BlockFounder.TransactionResult lastFuelResult = BlockFounder.TransactionResult.SUCCESS;
        for (int i = 0; i < this.furnaces.size(); ++i) {
            ItemStack received;
            TileEntityFurnace furnace = (TileEntityFurnace)this.furnaces.get(i);
            if (furnace.func_70301_a(2) != null && !UtilInventory.isSlotsFull(this.inventory)) {
                ItemStack stack = furnace.func_70298_a(2, furnace.func_70301_a((int)2).field_77994_a);
                this.addItemToInventory(stack, this.coinPouch);
            }
            if (furnace.func_145950_i()) continue;
            if (furnace.func_70301_a(0) == null) {
                received = UtilInventory.findItem(this.inventory, ironOre_8);
                if (received == null) {
                    received = this.requestItem(world, pos, ironOre_8);
                }
                if (received == null) {
                    lastOreResult = lastResult;
                } else {
                    furnace.func_70299_a(0, received);
                }
            }
            if (furnace.func_70301_a(1) != null) continue;
            received = UtilInventory.findItemsMeta(this.inventory, coal, charcoal);
            if (received == null && (received = this.requestItem(world, pos, coal)) == null) {
                received = this.requestItem(world, pos, charcoal);
            }
            if (received == null) {
                lastFuelResult = lastResult;
                continue;
            }
            furnace.func_70299_a(1, received);
        }
        if (lastOreResult != BlockFounder.TransactionResult.SUCCESS) {
            this.complainResult(world, lastOreResult, Blocks.field_150366_p.func_149739_a() + ".name", new Object[0]);
        }
        if (lastFuelResult != BlockFounder.TransactionResult.SUCCESS) {
            this.complainResult(world, lastFuelResult, Items.field_151044_h.func_77658_a() + ".name", new Object[0]);
        }
    }

    private void makeIronBlocks(World world, BlockPos pos, int amount) {
        while (amount > 0) {
            if (UtilInventory.isSlotsFull(this.inventory)) {
                return;
            }
            ItemStack received = UtilInventory.findItem(this.inventory, ironIngot_9);
            if (received == null) {
                received = this.requestItem(world, pos, ironIngot_9);
                if (received == null) {
                    this.complainResult(world, BlockFounder.TransactionResult.FAIL_ITEM_NOT_AVAILABLE, Items.field_151042_j.func_77658_a() + ".name", new Object[0]);
                    return;
                }
            } else if (this.coinPouch != null && !expertMode) {
                this.coinPouch.func_82841_c(Math.max(0, this.coinPouch.func_82838_A() - Market.getPrice(received) * received.field_77994_a));
            }
            this.addItemToInventory(new ItemStack(Blocks.field_150339_S), this.coinPouch);
            --amount;
        }
    }

    private boolean makeTool(World world, BlockPos pos, int id) {
        ItemStack stack;
        if (UtilInventory.isSlotsFull(this.inventory)) {
            return false;
        }
        switch (id) {
            case 0: {
                if (UtilInventory.findItem(this.inventory, Items.field_151037_a) < 0) break;
                return false;
            }
            case 1: {
                if (UtilInventory.findItem(this.inventory, Items.field_151036_c) < 0) break;
                return false;
            }
            case 2: {
                if (UtilInventory.findItem(this.inventory, Items.field_151035_b) < 0) break;
                return false;
            }
            case 3: {
                if (UtilInventory.findItem(this.inventory, Items.field_151019_K) < 0) break;
                return false;
            }
        }
        ItemStack receivedSticks = UtilInventory.findItem(this.inventory, new ItemStack(Items.field_151055_y, 2));
        if (receivedSticks == null && (stack = AutoRecipes.make8SticksFromLog(world, pos, this, this.inventory)) != null) {
            receivedSticks = stack.func_77979_a(2);
            if (stack.field_77994_a > 0) {
                UtilInventory.addItemToInventory(this.inventory, stack);
            }
        }
        if (receivedSticks == null) {
            this.complainResult(world, lastResult, "tile.log.name", new Object[0]);
            return false;
        }
        ItemStack receivedIron = null;
        switch (id) {
            case 0: {
                receivedIron = UtilInventory.findItem(this.inventory, new ItemStack(Items.field_151042_j, 1));
                if (receivedIron == null) {
                    receivedIron = this.requestItem(world, pos, new ItemStack(Items.field_151042_j, 1));
                    if (receivedIron == null) {
                        UtilInventory.addItemToInventory(this.inventory, receivedSticks);
                        this.complainResult(world, BlockFounder.TransactionResult.FAIL_ITEM_NOT_AVAILABLE, Items.field_151042_j.func_77658_a() + ".name", new Object[0]);
                        return false;
                    }
                } else if (this.coinPouch != null && !expertMode) {
                    this.coinPouch.func_82841_c(Math.max(0, this.coinPouch.func_82838_A() - Market.getPrice(receivedIron) * receivedIron.field_77994_a));
                }
                this.addItemToInventory(new ItemStack(Items.field_151037_a), this.coinPouch);
                break;
            }
            case 1: {
                receivedIron = UtilInventory.findItem(this.inventory, new ItemStack(Items.field_151042_j, 3));
                if (receivedIron == null) {
                    receivedIron = this.requestItem(world, pos, new ItemStack(Items.field_151042_j, 3));
                    if (receivedIron == null) {
                        UtilInventory.addItemToInventory(this.inventory, receivedSticks);
                        this.complainResult(world, BlockFounder.TransactionResult.FAIL_ITEM_NOT_AVAILABLE, Items.field_151042_j.func_77658_a() + ".name", new Object[0]);
                        return false;
                    }
                } else if (this.coinPouch != null && !expertMode) {
                    this.coinPouch.func_82841_c(Math.max(0, this.coinPouch.func_82838_A() - Market.getPrice(receivedIron) * receivedIron.field_77994_a));
                }
                this.addItemToInventory(new ItemStack(Items.field_151036_c), this.coinPouch);
                break;
            }
            case 2: {
                receivedIron = UtilInventory.findItem(this.inventory, new ItemStack(Items.field_151042_j, 3));
                if (receivedIron == null) {
                    receivedIron = this.requestItem(world, pos, new ItemStack(Items.field_151042_j, 3));
                    if (receivedIron == null) {
                        UtilInventory.addItemToInventory(this.inventory, receivedSticks);
                        this.complainResult(world, BlockFounder.TransactionResult.FAIL_ITEM_NOT_AVAILABLE, Items.field_151042_j.func_77658_a() + ".name", new Object[0]);
                        return false;
                    }
                } else if (this.coinPouch != null && !expertMode) {
                    this.coinPouch.func_82841_c(Math.max(0, this.coinPouch.func_82838_A() - Market.getPrice(receivedIron) * receivedIron.field_77994_a));
                }
                this.addItemToInventory(new ItemStack(Items.field_151035_b), this.coinPouch);
                break;
            }
            case 3: {
                receivedIron = UtilInventory.findItem(this.inventory, new ItemStack(Items.field_151042_j, 2));
                if (receivedIron == null) {
                    receivedIron = this.requestItem(world, pos, new ItemStack(Items.field_151042_j, 2));
                    if (receivedIron == null) {
                        UtilInventory.addItemToInventory(this.inventory, receivedSticks);
                        this.complainResult(world, BlockFounder.TransactionResult.FAIL_ITEM_NOT_AVAILABLE, Items.field_151042_j.func_77658_a() + ".name", new Object[0]);
                        return false;
                    }
                } else if (this.coinPouch != null && !expertMode) {
                    this.coinPouch.func_82841_c(Math.max(0, this.coinPouch.func_82838_A() - Market.getPrice(receivedIron) * receivedIron.field_77994_a));
                }
                this.addItemToInventory(new ItemStack(Items.field_151019_K), this.coinPouch);
            }
        }
        return true;
    }
}

