/*
 * Decompiled with CFR 0.152.
 */
package com.dooglamoo.citiesmod.block;

import com.dooglamoo.citiesmod.block.BlockFounder;
import com.dooglamoo.citiesmod.block.IFounder;
import com.dooglamoo.citiesmod.inventory.UtilInventory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockBakery
extends BlockFounder {
    private static final ItemStack wheat_3 = new ItemStack(Items.field_151015_O, 3);
    private static final ItemStack coal = new ItemStack(Items.field_151044_h, 1, 0);
    private static final ItemStack charcoal = new ItemStack(Items.field_151044_h, 1, 1);
    private List<ItemStack> foods = new ArrayList<ItemStack>();

    public BlockBakery() {
        super(3, 0, 8);
        this.foods.add(new ItemStack(Items.field_151147_al, 8));
        this.foods.add(new ItemStack(Items.field_151082_bd, 8));
        this.foods.add(new ItemStack(Items.field_151076_bf, 8));
        this.foods.add(new ItemStack(Items.field_151115_aP, 8, 0));
        this.foods.add(new ItemStack(Items.field_151115_aP, 8, 1));
        this.foods.add(new ItemStack(Items.field_151174_bG, 8));
        this.foods.add(new ItemStack(Items.field_179561_bm, 8));
        this.foods.add(new ItemStack(Items.field_179558_bo, 8));
    }

    @Override
    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_175640_z(pos)) {
            return;
        }
        super.func_180645_a(world, pos, state, rand);
        if (this.chance <= 0.1f && !this.eat(world, pos, 1, 0.0f)) {
            return;
        }
        if (world.func_72820_D() % 24000L >= 18000L) {
            return;
        }
        if (UtilInventory.isSlotsFull(this.inventory)) {
            if (showInventoryFullMsg) {
                this.complain(world, "tile.founder.msg.full", new Object[0]);
            }
            return;
        }
        this.findFurnace(world);
        this.complained = false;
        this.busy = false;
        this.cookFood(world, pos);
        this.makeBread(world, pos, 2);
    }

    @Override
    public boolean canContain(IFounder block) {
        return true;
    }

    @Override
    public boolean canBeContainedIn(IFounder block) {
        return block.isBuilding();
    }

    private void cookFood(World world, BlockPos pos) {
        BlockFounder.TransactionResult lastFoodResult = BlockFounder.TransactionResult.SUCCESS;
        BlockFounder.TransactionResult lastFuelResult = BlockFounder.TransactionResult.SUCCESS;
        for (int f = 0; f < this.furnaces.size(); ++f) {
            TileEntityFurnace furnace = (TileEntityFurnace)this.furnaces.get(f);
            if (furnace.func_70301_a(2) != null && !UtilInventory.isSlotsFull(this.inventory)) {
                ItemStack stack = furnace.func_70298_a(2, furnace.func_70301_a((int)2).field_77994_a);
                this.addItemToInventory(stack, this.coinPouch);
                this.busy = true;
            }
            if (!furnace.func_145950_i()) {
                ItemStack received;
                if (furnace.func_70301_a(0) == null) {
                    Collections.shuffle(this.foods, world.field_73012_v);
                    received = null;
                    for (int i = 0; i < this.foods.size(); ++i) {
                        received = UtilInventory.findItemMeta(this.inventory, this.foods.get(i));
                        if (received == null) {
                            received = this.requestItem(world, pos, this.foods.get(i));
                        }
                        if (received == null) continue;
                        furnace.func_70299_a(0, received);
                        this.busy = true;
                        break;
                    }
                    if (received == null) {
                        lastFoodResult = lastResult;
                    }
                }
                if (furnace.func_70301_a(1) != null) continue;
                received = UtilInventory.findItemsMeta(this.inventory, coal, charcoal);
                if (received == null && (received = this.requestItem(world, pos, coal)) == null) {
                    received = this.requestItem(world, pos, charcoal);
                }
                if (received == null) {
                    lastFuelResult = lastResult;
                    continue;
                }
                furnace.func_70299_a(1, received);
                this.busy = true;
                continue;
            }
            this.busy = true;
        }
        if (lastFoodResult != BlockFounder.TransactionResult.SUCCESS) {
            this.complainResult(world, lastFoodResult, "tile.founder.food.cook", new Object[0]);
            this.complained = true;
        }
        if (lastFuelResult != BlockFounder.TransactionResult.SUCCESS) {
            this.complainResult(world, lastFuelResult, Items.field_151044_h.func_77658_a() + ".name", new Object[0]);
            this.complained = true;
        }
    }

    private void makeBread(World world, BlockPos pos, int amount) {
        while (amount > 0) {
            if (UtilInventory.isSlotsFull(this.inventory)) {
                return;
            }
            ItemStack received = UtilInventory.findItem(this.inventory, wheat_3);
            if (received == null) {
                received = this.requestItem(world, pos, wheat_3);
            }
            if (received == null) {
                if (!this.complained && !this.busy) {
                    this.complainResult(world, lastResult, Items.field_151015_O.func_77658_a() + ".name", new Object[0]);
                }
                return;
            }
            this.addItemToInventory(new ItemStack(Items.field_151025_P, 1), this.coinPouch);
            --amount;
        }
    }
}

