/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.storage.loot;

import com.google.common.collect.Lists;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.files.SimpleLeveledRegistry;
import ivorius.reccomplex.files.loading.LeveledRegistry;
import ivorius.reccomplex.world.storage.loot.GenericItemCollection;
import ivorius.reccomplex.world.storage.loot.WeightedItemCollection;
import ivorius.reccomplex.world.storage.loot.WeightedItemCollectionRegistry;
import java.util.ArrayList;

public class GenericItemCollectionRegistry
extends SimpleLeveledRegistry<GenericItemCollection.Component> {
    public static final GenericItemCollectionRegistry INSTANCE = new GenericItemCollectionRegistry();

    public GenericItemCollectionRegistry() {
        super("generic item collection component");
    }

    @Override
    public GenericItemCollection.Component register(String id, String domain, GenericItemCollection.Component component, boolean active, LeveledRegistry.ILevel level) {
        if (component.inventoryGeneratorID == null || component.inventoryGeneratorID.length() == 0) {
            component.inventoryGeneratorID = id;
        }
        if (active && !RCConfig.shouldInventoryGeneratorGenerate(id, domain)) {
            active = false;
        }
        GenericItemCollection.Component prev = super.register(id, domain, component, active, level);
        this.invalidateCache(component.inventoryGeneratorID);
        return prev;
    }

    @Override
    public GenericItemCollection.Component unregister(String id, LeveledRegistry.ILevel level) {
        GenericItemCollection.Component rt = (GenericItemCollection.Component)((Object)super.unregister(id, level));
        this.invalidateCache(rt.inventoryGeneratorID);
        return rt;
    }

    @Override
    public void clear(LeveledRegistry.ILevel level) {
        ArrayList removed = Lists.newArrayList(this.map(level).values());
        super.clear(level);
        for (GenericItemCollection.Component component : removed) {
            this.invalidateCache(component.inventoryGeneratorID);
        }
    }

    private void invalidateCache(String generatorID) {
        WeightedItemCollectionRegistry.INSTANCE.unregister(generatorID, LeveledRegistry.Level.CUSTOM);
        for (String key : this.activeIDs()) {
            GenericItemCollection.Component component = (GenericItemCollection.Component)((Object)this.get(key));
            if (!component.inventoryGeneratorID.equals(generatorID)) continue;
            GenericItemCollection collection = this.registerGetGenericItemCollection(component.inventoryGeneratorID, this.status(key).getDomain());
            collection.components.add(component);
        }
    }

    private GenericItemCollection registerGetGenericItemCollection(String key, String domain) {
        WeightedItemCollection collection = (WeightedItemCollection)WeightedItemCollectionRegistry.INSTANCE.get(key);
        if (collection == null || !(collection instanceof GenericItemCollection)) {
            collection = new GenericItemCollection();
            WeightedItemCollectionRegistry.INSTANCE.register(key, domain, collection, true, LeveledRegistry.Level.CUSTOM);
        }
        return (GenericItemCollection)collection;
    }

    private static class ComponentData {
        public boolean disabled;
        public String domain;

        public ComponentData(boolean disabled, String domain) {
            this.disabled = disabled;
            this.domain = domain;
        }
    }
}

