/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.script;

import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.blocks.Directions;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.IvCollections;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.gui.worldscripts.structuregenerator.TableDataSourceWorldScriptStructureGenerator;
import ivorius.reccomplex.nbt.NBTStorable;
import ivorius.reccomplex.utils.RCAxisAlignedTransform;
import ivorius.reccomplex.world.gen.feature.StructureGenerator;
import ivorius.reccomplex.world.gen.feature.WorldStructureGenerationData;
import ivorius.reccomplex.world.gen.feature.structure.ReadableInstanceData;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.ListGeneration;
import ivorius.reccomplex.world.gen.script.WorldScript;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.apache.commons.lang3.tuple.Pair;

public class WorldScriptStructureGenerator
implements WorldScript<InstanceData> {
    protected boolean simpleMode;
    protected BlockPos structureShift = BlockPos.field_177992_a;
    protected String structureListID = "";
    protected EnumFacing front;
    protected List<String> structureNames = new ArrayList<String>();
    protected Integer structureRotation;
    protected Boolean structureMirror;

    public boolean isSimpleMode() {
        return this.simpleMode;
    }

    public void setSimpleMode(boolean simpleMode) {
        this.simpleMode = simpleMode;
    }

    public BlockPos getStructureShift() {
        return this.structureShift;
    }

    public void setStructureShift(BlockPos structureShift) {
        this.structureShift = structureShift;
    }

    public String getStructureListID() {
        return this.structureListID;
    }

    public void setStructureListID(String structureListID) {
        this.structureListID = structureListID;
    }

    public EnumFacing getFront() {
        return this.front;
    }

    public void setFront(EnumFacing front) {
        this.front = front;
    }

    public List<String> getStructureNames() {
        return Collections.unmodifiableList(this.structureNames);
    }

    public void setStructureNames(List<String> structureNames) {
        IvCollections.setContentsOfList(this.structureNames, structureNames);
    }

    public Integer getStructureRotation() {
        return this.structureRotation;
    }

    public void setStructureRotation(Integer structureRotation) {
        this.structureRotation = structureRotation;
    }

    public Boolean getStructureMirror() {
        return this.structureMirror;
    }

    public void setStructureMirror(Boolean structureMirror) {
        this.structureMirror = structureMirror;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.structureShift = BlockPositions.readFromNBT("structureShift", nbtTagCompound);
        this.simpleMode = !nbtTagCompound.func_150297_b("simpleMode", 1) || nbtTagCompound.func_74767_n("simpleMode");
        this.structureListID = nbtTagCompound.func_74779_i("structureListID");
        this.front = nbtTagCompound.func_150297_b("front", 8) ? Directions.deserialize(nbtTagCompound.func_74779_i("front")) : null;
        ArrayList<String> structureList = new ArrayList<String>();
        NBTTagList structureNBTList = nbtTagCompound.func_150295_c("structures", 8);
        for (int i = 0; i < structureNBTList.func_74745_c(); ++i) {
            structureList.add(structureNBTList.func_150307_f(i));
        }
        IvCollections.setContentsOfList(this.structureNames, structureList);
        this.structureRotation = nbtTagCompound.func_74764_b("structureRotation") ? Integer.valueOf(nbtTagCompound.func_74762_e("structureRotation")) : null;
        this.structureMirror = nbtTagCompound.func_74764_b("structureMirror") ? Boolean.valueOf(nbtTagCompound.func_74767_n("structureMirror")) : null;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        BlockPositions.writeToNBT("structureShift", this.structureShift, nbtTagCompound);
        nbtTagCompound.func_74757_a("simpleMode", this.simpleMode);
        nbtTagCompound.func_74778_a("structureListID", this.structureListID);
        if (this.front != null) {
            nbtTagCompound.func_74778_a("front", Directions.serialize(this.front));
        }
        NBTTagList structureNBTList = new NBTTagList();
        for (String struc : this.structureNames) {
            structureNBTList.func_74742_a((NBTBase)new NBTTagString(struc));
        }
        nbtTagCompound.func_74782_a("structures", (NBTBase)structureNBTList);
        if (this.structureRotation != null) {
            nbtTagCompound.func_74768_a("structureRotation", this.structureRotation.intValue());
        }
        if (this.structureMirror != null) {
            nbtTagCompound.func_74757_a("structureMirror", this.structureMirror.booleanValue());
        }
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new InstanceData(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound());
    }

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context, BlockPos pos) {
        InstanceData instanceData = null;
        Random random = context.random;
        AxisAlignedTransform2D transform = context.transform;
        if (this.simpleMode) {
            String structureID;
            Structure structure;
            if (this.structureNames.size() > 0 && (structure = (Structure)StructureRegistry.INSTANCE.get(structureID = this.structureNames.get(random.nextInt(this.structureNames.size())))) != null) {
                int rotations;
                int n = structure.isRotatable() ? (this.structureRotation != null ? transform.getRotation() + this.structureRotation : random.nextInt(4)) : (rotations = 0);
                boolean mirrorX = structure.isMirrorable() && (this.structureMirror != null ? transform.isMirrorX() != this.structureMirror.booleanValue() : random.nextBoolean());
                AxisAlignedTransform2D strucTransform = AxisAlignedTransform2D.from(rotations, mirrorX);
                int[] strucSize = structure.size();
                BlockPos strucCoord = transform.apply(this.structureShift, new int[]{1, 1, 1}).func_177973_b((Vec3i)transform.apply(BlockPos.field_177992_a, strucSize)).func_177971_a((Vec3i)pos);
                instanceData = new InstanceData(structureID, null, strucCoord, strucTransform, new StructureGenerator(structure).seed(random.nextLong()).environment(context.environment).transform(strucTransform).lowerCoord(strucCoord).asSource(context.generateAsSource).instanceData().orElse(null));
            }
        } else {
            Collection generationInfos = StructureRegistry.INSTANCE.getStructuresInList(this.structureListID, this.front).collect(Collectors.toList());
            if (generationInfos.size() > 0) {
                int rotations;
                boolean mirrorX;
                Pair pair = WeightedSelector.select(random, generationInfos, item -> (double)RCConfig.tweakedSpawnRate(StructureRegistry.INSTANCE.id(item.getLeft())) * ((ListGeneration)item.getRight()).getWeight());
                Structure structure = (Structure)pair.getLeft();
                String structureID = StructureRegistry.INSTANCE.id(structure);
                ListGeneration generationInfo = (ListGeneration)pair.getRight();
                if (this.front != null) {
                    EnumFacing curFront = Directions.rotate(this.front, transform);
                    mirrorX = structure.isMirrorable() && structure.isRotatable() && random.nextBoolean();
                    Integer neededRotations = Directions.getHorizontalClockwiseRotations(curFront, generationInfo.front, mirrorX);
                    rotations = neededRotations != null ? neededRotations : 0;
                } else {
                    mirrorX = structure.isMirrorable() && random.nextBoolean();
                    rotations = structure.isRotatable() ? random.nextInt(4) : 0;
                }
                AxisAlignedTransform2D strucTransform = AxisAlignedTransform2D.from(rotations, mirrorX);
                int[] strucSize = structure.size();
                BlockPos strucCoord = transform.apply(this.structureShift.func_177971_a((Vec3i)generationInfo.shift), new int[]{1, 1, 1}).func_177973_b((Vec3i)transform.apply(BlockPos.field_177992_a, strucSize)).func_177971_a((Vec3i)pos);
                instanceData = new InstanceData(structureID, generationInfo.id(), strucCoord, strucTransform, new StructureGenerator(structure).seed(random.nextLong()).environment(context.environment).transform(strucTransform).asSource(context.generateAsSource).lowerCoord(strucCoord).instanceData().orElse(null));
            }
        }
        return instanceData != null ? instanceData : new InstanceData();
    }

    @Override
    public void generate(StructureSpawnContext context, InstanceData instanceData, BlockPos pos) {
        this.generate_(context, instanceData);
    }

    protected <T extends NBTStorable> void generate_(StructureSpawnContext context, InstanceData instanceData) {
        Structure structure = (Structure)StructureRegistry.INSTANCE.get(instanceData.structureID);
        ReadableInstanceData<?> structureData = instanceData.structureData;
        if (structure == null || !structureData.exists()) {
            return;
        }
        this.generate(context, instanceData, structure, structureData, instanceData.generationInfoID);
    }

    @Nonnull
    protected <T extends NBTStorable> Optional<WorldStructureGenerationData.StructureEntry> generate(StructureSpawnContext context, InstanceData instanceData, Structure<T> structure, ReadableInstanceData<T> structureData, String generationInfo) {
        StructureGenerator<T> generator = new StructureGenerator<T>(structure).structureID(instanceData.structureID).asChild(context).generationInfo(generationInfo).lowerCoord(instanceData.lowerCoord).transform(instanceData.structureTransform);
        structureData.load(generator);
        return generator.generate();
    }

    @Override
    public String getDisplayString() {
        return IvTranslations.get("reccomplex.worldscript.strucGen");
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate tableDelegate) {
        return new TableDataSourceWorldScriptStructureGenerator(this, navigator, tableDelegate);
    }

    public static class InstanceData
    implements NBTStorable {
        public String structureID = "";
        public String generationInfoID;
        public BlockPos lowerCoord;
        public AxisAlignedTransform2D structureTransform = AxisAlignedTransform2D.ORIGINAL;
        public final ReadableInstanceData<?> structureData = new ReadableInstanceData();

        public InstanceData() {
        }

        public InstanceData(String structureID, String generationInfoID, BlockPos lowerCoord, AxisAlignedTransform2D structureTransform, NBTStorable structureData) {
            this.structureID = structureID;
            this.generationInfoID = generationInfoID;
            this.lowerCoord = lowerCoord;
            this.structureTransform = structureTransform;
            this.structureData.setInstanceData(structureData);
        }

        public InstanceData(NBTTagCompound compound) {
            this.structureID = compound.func_74779_i("structureID");
            this.generationInfoID = compound.func_150297_b(this.generationInfoID, 8) ? compound.func_74779_i("generationInfoID") : null;
            this.lowerCoord = BlockPositions.readFromNBT("lowerCoord", compound);
            this.structureTransform = RCAxisAlignedTransform.read(compound, "rotation", "mirrorX");
            this.structureData.readFromNBT("structureData", compound);
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("structureID", this.structureID);
            if (this.generationInfoID != null) {
                compound.func_74778_a("generationInfoID", this.generationInfoID);
            }
            BlockPositions.writeToNBT("lowerCoord", this.lowerCoord, compound);
            RCAxisAlignedTransform.write(compound, this.structureTransform, "rotation", "mirrorX");
            this.structureData.writeToNBT("structureData", compound);
            return compound;
        }
    }
}

