/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.script;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.maze.components.MazeComponentConnector;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazePredicateMany;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MorphingMazeComponent;
import ivorius.ivtoolkit.maze.components.PlacedMazeComponent;
import ivorius.ivtoolkit.maze.components.SetMazeComponent;
import ivorius.ivtoolkit.tools.IvNBTHelper;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.ivtoolkit.tools.NBTTagLists;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceWorldScriptMazeGenerator;
import ivorius.reccomplex.nbt.NBTStorable;
import ivorius.reccomplex.utils.IntAreas;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.VariableDomain;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLoadContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructurePrepareContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.Selection;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.MazeGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.Connector;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.ConnectorFactory;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.ConnectorStrategy;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.MazeComponentStructure;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.PlacedStructure;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.SavedMazeComponent;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.SavedMazePathConnection;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.SavedMazeReachability;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.WorldGenMaze;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.rules.BlockedConnectorStrategy;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.rules.LimitAABBStrategy;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.rules.MazeRule;
import ivorius.reccomplex.world.gen.feature.structure.generic.maze.rules.MazeRuleRegistry;
import ivorius.reccomplex.world.gen.script.WorldScript;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class WorldScriptMazeGenerator
implements WorldScript<InstanceData> {
    public final List<MazeRule> rules = new ArrayList<MazeRule>();
    public String mazeID = "";
    public BlockPos structureShift = BlockPos.field_177992_a;
    public int[] roomSize = new int[]{3, 5, 3};
    public SavedMazeComponent mazeComponent = new SavedMazeComponent();

    public WorldScriptMazeGenerator() {
        this.mazeComponent.reachability.groupByDefault = false;
    }

    public static <C> void blockRooms(MorphingMazeComponent<C> component, Set<MazeRoom> rooms, C wallConnector) {
        component.add(WorldGenMaze.createCompleteComponent(rooms, Collections.emptyMap(), wallConnector));
    }

    public static <C> void enclose(MorphingMazeComponent<C> component, MazeRoom lower, MazeRoom higher, C wallConnector) {
        if (lower.getDimensions() != higher.getDimensions()) {
            throw new IllegalArgumentException();
        }
        HashSet<MazeRoom> rooms = new HashSet<MazeRoom>();
        int[] coords = lower.getCoordinates();
        int i = 0;
        while (i < coords.length) {
            int lowest = lower.getCoordinate(i);
            int highest = higher.getCoordinate(i);
            int finalI = i;
            IntAreas.visitCoordsExcept(lower.getCoordinates(), higher.getCoordinates(), (TIntList)TIntArrayList.wrap((int[])new int[]{i++}), ints -> {
                ints[finalI] = lowest;
                rooms.add(new MazeRoom((int)ints));
                ints[finalI] = highest;
                rooms.add(new MazeRoom((int)ints));
                return true;
            });
        }
        WorldScriptMazeGenerator.blockRooms(component, rooms, wallConnector);
    }

    @Override
    public void generate(StructureSpawnContext context, InstanceData instanceData, BlockPos pos) {
        for (PlacedStructure placedComponent : instanceData.placedStructures) {
            WorldGenMaze.generate(context, placedComponent, pos);
        }
    }

    @Override
    public String getDisplayString() {
        return IvTranslations.get("reccomplex.worldscript.mazeGen");
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate tableDelegate) {
        return new TableDataSourceWorldScriptMazeGenerator(this, tableDelegate, navigator);
    }

    public String getMazeID() {
        return this.mazeID;
    }

    public void setMazeID(String mazeID) {
        this.mazeID = mazeID;
    }

    public BlockPos getStructureShift() {
        return this.structureShift;
    }

    public void setStructureShift(BlockPos structureShift) {
        this.structureShift = structureShift;
    }

    public int[] getRoomSize() {
        return (int[])this.roomSize.clone();
    }

    public void setRoomSize(int[] roomSize) {
        this.roomSize = roomSize;
    }

    public SavedMazeComponent getMazeComponent() {
        return this.mazeComponent;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.mazeID = compound.func_74779_i("mazeID");
        if (compound.func_150297_b("mazeComponent", 10)) {
            this.mazeComponent.readFromNBT(compound.func_74775_l("mazeComponent"));
        } else {
            NBTTagCompound rooms = compound.func_74775_l("rooms");
            this.mazeComponent.rooms.readFromNBT(rooms);
            if (compound.func_150297_b("roomNumbers", 11)) {
                this.mazeComponent.rooms.add(new Selection.Area(true, new int[]{0, 0, 0}, IvVecMathHelper.sub(IvNBTHelper.readIntArrayFixedSize("roomNumbers", 3, compound), new int[][]{{1, 1, 1}})));
            }
            if (compound.func_150297_b("blockedRoomAreas", 9)) {
                NBTTagList blockedRoomsList = compound.func_150295_c("blockedRoomAreas", 10);
                for (int i = 0; i < blockedRoomsList.func_74745_c(); ++i) {
                    NBTTagCompound blockedRoomTag = blockedRoomsList.func_150305_b(i);
                    this.mazeComponent.rooms.add(new Selection.Area(false, IvNBTHelper.readIntArrayFixedSize("min", 3, blockedRoomTag), IvNBTHelper.readIntArrayFixedSize("max", 3, blockedRoomTag)));
                }
            }
            this.mazeComponent.exitPaths.clear();
            this.mazeComponent.exitPaths.addAll(NBTCompoundObjects.readListFrom(compound, "mazeExits", SavedMazePathConnection::new));
            this.mazeComponent.defaultConnector.id = "Wall";
            this.mazeComponent.reachability.set(Collections.emptyList(), Collections.emptyList(), false);
        }
        this.structureShift = BlockPositions.readFromNBT("structureShift", compound);
        this.roomSize = IvNBTHelper.readIntArrayFixedSize("roomSize", 3, compound);
        this.rules.clear();
        this.rules.addAll(NBTTagLists.compoundsFrom(compound, "rules").stream().map(MazeRuleRegistry.INSTANCE::read).collect(Collectors.toList()));
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("mazeID", this.mazeID);
        compound.func_74782_a("mazeComponent", (NBTBase)NBTCompoundObjects.write(this.mazeComponent));
        BlockPositions.writeToNBT("structureShift", this.structureShift, compound);
        compound.func_74783_a("roomSize", this.roomSize);
        NBTTagLists.writeTo(compound, "rules", this.rules.stream().map(MazeRuleRegistry.INSTANCE::write).collect(Collectors.toList()));
    }

    @Override
    public InstanceData prepareInstanceData(StructurePrepareContext context, BlockPos pos) {
        InstanceData instanceData = new InstanceData();
        instanceData.placedStructures.addAll(this.getPlacedRooms(context.random, context.transform, context.environment).stream().map(placedComponent -> WorldGenMaze.place(context.random, context.environment, this.structureShift, this.roomSize, placedComponent, pos, context.transform)).filter(Objects::nonNull).collect(Collectors.toList()));
        return instanceData;
    }

    @Override
    public InstanceData loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new InstanceData(nbt instanceof NBTTagCompound ? (NBTTagCompound)nbt : new NBTTagCompound());
    }

    public List<PlacedMazeComponent<MazeComponentStructure<Connector>, Connector>> getPlacedRooms(Random random, AxisAlignedTransform2D transform, Environment environment) {
        if (this.mazeComponent.rooms.isEmpty()) {
            return null;
        }
        ConnectorFactory factory = new ConnectorFactory();
        Connector wallConnector = factory.get("Wall");
        Connector defaultConnector = this.mazeComponent.defaultConnector.toConnector(factory);
        Set<Connector> blockedConnections = Collections.singleton(wallConnector);
        int[] boundsHigher = this.mazeComponent.rooms.boundsHigher();
        int[] boundsLower = this.mazeComponent.rooms.boundsLower();
        int[] oneArray = new int[boundsHigher.length];
        Arrays.fill(oneArray, 1);
        int[] outsideBoundsHigher = IvVecMathHelper.add(boundsHigher, oneArray);
        int[] outsideBoundsLower = IvVecMathHelper.sub(boundsLower, new int[][]{oneArray});
        List transformedComponents = StructureRegistry.INSTANCE.getStructuresInMaze(this.mazeID).flatMap(pair -> ((Structure)pair.getLeft()).declaredVariables().omega(environment, true).flatMap(domain -> WorldGenMaze.transforms((Structure)pair.getLeft(), (MazeGeneration)pair.getRight(), transform, factory, environment.copy((VariableDomain)domain), blockedConnections))).collect(Collectors.toList());
        SetMazeComponent maze = new SetMazeComponent();
        WorldScriptMazeGenerator.enclose(maze, new MazeRoom(outsideBoundsLower), new MazeRoom(outsideBoundsHigher), defaultConnector);
        WorldScriptMazeGenerator.blockRooms(maze, this.mazeComponent.rooms.compile(false).keySet(), defaultConnector);
        WorldGenMaze.buildExitPaths(environment, factory, this.mazeComponent.exitPaths, maze.rooms()).forEach(path -> {
            Connector cfr_ignored_0 = (Connector)maze.exits().put((MazePassage)((Object)((Object)path.getKey())), path.getValue());
        });
        maze.reachability().putAll((Multimap)WorldGenMaze.addExternalReachability((ImmutableMultimap.Builder<MazePassage, MazePassage>)ImmutableListMultimap.builder(), maze.exits(), blockedConnections).build());
        maze.reachability().putAll((Multimap)this.mazeComponent.reachability.build((ImmutableMultimap.Builder<MazePassage, MazePassage>)ImmutableListMultimap.builder(), AxisAlignedTransform2D.ORIGINAL, this.mazeComponent.boundsSize(), SavedMazeReachability.notBlocked(blockedConnections, maze.exits()), maze.exits().keySet()).build());
        ConnectorStrategy connectorStrategy = new ConnectorStrategy();
        List predicates = this.rules.stream().map(r -> r.build(this, blockedConnections, factory, transformedComponents, connectorStrategy)).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        predicates.add(new LimitAABBStrategy(outsideBoundsHigher));
        predicates.add(new BlockedConnectorStrategy<Connector>(blockedConnections));
        int totalRooms = this.mazeComponent.rooms.compile(true).size();
        return MazeComponentConnector.connect(maze, transformedComponents, connectorStrategy, new MazePredicateMany(predicates), random, RCConfig.mazePlacementReversesPerRoom >= 0.0f ? MathHelper.func_76141_d((float)((float)totalRooms * RCConfig.mazePlacementReversesPerRoom + 0.5f)) : MazeComponentConnector.INFINITE_REVERSES);
    }

    public static class InstanceData
    implements NBTStorable {
        public final List<PlacedStructure> placedStructures = new ArrayList<PlacedStructure>();

        public InstanceData() {
        }

        public InstanceData(NBTTagCompound compound) {
            this.placedStructures.addAll(NBTCompoundObjects.readListFrom(compound, "placedStructures", PlacedStructure::new));
        }

        @Override
        public NBTBase writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            NBTCompoundObjects.writeListTo(compound, "placedStructures", this.placedStructures);
            return compound;
        }
    }
}

