/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.utils.FMLRemapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MCRegistrySpecial
implements MCRegistry {
    public static final String HIDDEN_ITEM_TAG = "RC_HIDDEN_ITEM";
    private static final Item DUMMY_ITEM = Items.field_151044_h;
    protected final BiMap<ResourceLocation, Item> itemMap = HashBiMap.create();
    protected final BiMap<ResourceLocation, Block> blockMap = HashBiMap.create();
    protected final Map<ResourceLocation, Class<? extends TileEntity>> tileEntityMap = new HashMap<ResourceLocation, Class<? extends TileEntity>>();
    protected MCRegistry parent;
    protected FMLRemapper remapper;
    protected ItemHidingRegistry itemHidingRegistry = new ItemHidingRegistry();

    public MCRegistrySpecial(MCRegistry parent, FMLRemapper remapper) {
        this.parent = parent;
        this.remapper = remapper;
    }

    public BiMap<ResourceLocation, Item> getItemMap() {
        return Maps.unmodifiableBiMap(this.itemMap);
    }

    public BiMap<ResourceLocation, Block> getBlockMap() {
        return Maps.unmodifiableBiMap(this.blockMap);
    }

    public Map<ResourceLocation, Class<? extends TileEntity>> getTileEntityMap() {
        return Collections.unmodifiableMap(this.tileEntityMap);
    }

    public void register(ResourceLocation id, Item item) {
        this.itemMap.put((Object)id, (Object)item);
    }

    public void register(ResourceLocation id, Block block) {
        this.blockMap.put((Object)id, (Object)block);
    }

    public void register(ResourceLocation id, Class<? extends TileEntity> tileEntity) {
        this.tileEntityMap.put(id, tileEntity);
    }

    public ItemHidingRegistry itemHidingMode() {
        return this.itemHidingRegistry;
    }

    @Override
    public Item itemFromID(ResourceLocation itemID) {
        Item item = (Item)this.itemMap.get((Object)(itemID = this.remapper.mapItem(itemID)));
        return item != null ? item : this.parent.itemFromID(itemID);
    }

    @Override
    public ResourceLocation idFromItem(Item item) {
        ResourceLocation id = (ResourceLocation)this.itemMap.inverse().get((Object)item);
        return id != null ? id : this.parent.idFromItem(item);
    }

    @Override
    public void modifyItemStackCompound(NBTTagCompound compound, ResourceLocation itemID) {
        this.parent.modifyItemStackCompound(compound, itemID);
    }

    public boolean isSafe(Item item) {
        return this.itemMap.isEmpty() || !this.itemMap.containsValue((Object)item);
    }

    public boolean isItemSafe(ResourceLocation itemID) {
        return this.itemMap.isEmpty() || !this.itemMap.containsKey((Object)itemID);
    }

    @Override
    public Block blockFromID(ResourceLocation blockID) {
        Block block = (Block)this.blockMap.get((Object)(blockID = this.remapper.mapBlock(blockID)));
        return block != null ? block : this.parent.blockFromID(blockID);
    }

    @Override
    public ResourceLocation idFromBlock(Block block) {
        ResourceLocation id = (ResourceLocation)this.blockMap.inverse().get((Object)block);
        return id != null ? id : this.parent.idFromBlock(block);
    }

    public boolean isSafe(Block block) {
        return this.blockMap.isEmpty() || !this.blockMap.containsValue((Object)block);
    }

    public boolean isBlockSafe(ResourceLocation blockID) {
        return this.blockMap.isEmpty() || !this.blockMap.containsKey((Object)blockID);
    }

    @Override
    public TileEntity loadTileEntity(World world, NBTTagCompound compound) {
        try {
            Class<? extends TileEntity> oclass = this.tileEntityMap.get(this.remapper.mapTileEntity(new ResourceLocation(compound.func_74779_i("id"))));
            if (oclass != null) {
                TileEntity tileEntity = oclass.newInstance();
                tileEntity.func_145839_a(compound);
                return tileEntity;
            }
        }
        catch (Exception e) {
            RecurrentComplex.logger.error("Error loading special TileEntity", (Throwable)e);
        }
        return this.parent.loadTileEntity(world, compound);
    }

    public boolean isSafe(TileEntity tileEntity) {
        return this.tileEntityMap.isEmpty() || !this.tileEntityMap.containsValue(tileEntity.getClass());
    }

    public class ItemHidingRegistry
    implements MCRegistry {
        @Override
        public Item itemFromID(ResourceLocation itemID) {
            return !MCRegistrySpecial.this.isItemSafe(itemID = MCRegistrySpecial.this.remapper.mapItem(itemID)) ? DUMMY_ITEM : MCRegistrySpecial.this.parent.itemFromID(itemID);
        }

        @Override
        public ResourceLocation idFromItem(Item item) {
            return MCRegistrySpecial.this.idFromItem(item);
        }

        public ResourceLocation containedItemID(ItemStack stack) {
            return MCRegistrySpecial.this.idFromItem(this.containedItem(stack));
        }

        public Item containedItem(ItemStack stack) {
            Item hidden = this.hiddenItem(stack);
            return hidden != null ? hidden : stack.func_77973_b();
        }

        @Nullable
        public Item hiddenItem(ItemStack stack) {
            return stack.func_77942_o() && stack.func_77978_p().func_150297_b(MCRegistrySpecial.HIDDEN_ITEM_TAG, 8) ? MCRegistrySpecial.this.itemFromID(new ResourceLocation(stack.func_77978_p().func_74779_i(MCRegistrySpecial.HIDDEN_ITEM_TAG))) : null;
        }

        public ItemStack constructItemStack(ResourceLocation itemID, int stackSize, int metadata) {
            return this.constructItemStack(MCRegistrySpecial.this.itemFromID(itemID), stackSize, metadata);
        }

        public ItemStack constructItemStack(Item item, int stackSize, int metadata) {
            ResourceLocation hiddenID = (ResourceLocation)MCRegistrySpecial.this.itemMap.inverse().get((Object)item);
            if (hiddenID != null) {
                ItemStack stack = new ItemStack(DUMMY_ITEM, stackSize, metadata);
                stack.func_77983_a(MCRegistrySpecial.HIDDEN_ITEM_TAG, (NBTBase)new NBTTagString(hiddenID.toString()));
                return stack;
            }
            return new ItemStack(item, stackSize, metadata);
        }

        @Override
        public void modifyItemStackCompound(NBTTagCompound compound, ResourceLocation itemID) {
            Item item = (Item)MCRegistrySpecial.this.itemMap.get((Object)MCRegistrySpecial.this.remapper.mapItem(itemID));
            if (item != null) {
                NBTTagCompound stackNBT;
                if (compound.func_150297_b("tag", 10)) {
                    stackNBT = compound.func_74775_l("tag");
                } else {
                    stackNBT = new NBTTagCompound();
                    compound.func_74782_a("tag", (NBTBase)stackNBT);
                }
                stackNBT.func_74778_a(MCRegistrySpecial.HIDDEN_ITEM_TAG, itemID.toString());
                itemID = this.idFromItem(DUMMY_ITEM);
                compound.func_74778_a("id", itemID.toString());
            }
            MCRegistrySpecial.this.parent.modifyItemStackCompound(compound, itemID);
        }

        @Override
        public Block blockFromID(ResourceLocation blockID) {
            return MCRegistrySpecial.this.blockFromID(blockID);
        }

        @Override
        public ResourceLocation idFromBlock(Block block) {
            return MCRegistrySpecial.this.idFromBlock(block);
        }

        @Override
        public TileEntity loadTileEntity(World world, NBTTagCompound compound) {
            return MCRegistrySpecial.this.loadTileEntity(world, compound);
        }
    }
}

