/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.transformers;

import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.blocks.IvMutableBlockPos;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.nbt.NBTStorable;
import ivorius.reccomplex.utils.RCStructureBoundingBoxes;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLiveContext;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.RunTransformer;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.Transformer;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public abstract class TransformerSingleBlock<S extends NBTStorable>
extends Transformer<S> {
    public TransformerSingleBlock(@Nonnull String id) {
        super(id);
    }

    @Override
    public boolean skipGeneration(S instanceData, StructureLiveContext context, BlockPos pos, IBlockState state, IvWorldData worldData, BlockPos sourcePos) {
        return this.matches(context.environment, instanceData, state);
    }

    @Override
    public void transform(S instanceData, Transformer.Phase phase, StructureSpawnContext context, IvWorldData worldData, RunTransformer transformer) {
        if (!this.generatesInPhase(instanceData, phase)) {
            return;
        }
        IvBlockCollection blockCollection = worldData.blockCollection;
        StructureBoundingBox relevantSourceArea = context.sourceIntersection(BlockAreas.toBoundingBox(blockCollection.area()));
        if (relevantSourceArea == null) {
            return;
        }
        BlockPos lowerCoord = StructureBoundingBoxes.min(context.boundingBox);
        int[] areaSize = new int[]{blockCollection.width, blockCollection.height, blockCollection.length};
        context.freezeHeightMap(context.intersection(context.boundingBox));
        BlockPos.MutableBlockPos worldCoord = new BlockPos.MutableBlockPos();
        for (BlockPos blockPos : RCStructureBoundingBoxes.mutablePositions(relevantSourceArea)) {
            IBlockState state;
            IvMutableBlockPos.add(context.transform.applyOn(blockPos, worldCoord, areaSize), lowerCoord);
            if (!context.includesComplex((Vec3i)worldCoord) || !this.matches(context.environment, instanceData, state = blockCollection.getBlockState(blockPos))) continue;
            this.transformBlock(instanceData, Transformer.Phase.BEFORE, context, areaSize, (BlockPos)worldCoord, state);
        }
        context.meltHeightMap();
    }

    public abstract boolean generatesInPhase(S var1, Transformer.Phase var2);

    public abstract boolean matches(Environment var1, S var2, IBlockState var3);

    public abstract void transformBlock(S var1, Transformer.Phase var2, StructureSpawnContext var3, int[] var4, BlockPos var5, IBlockState var6);
}

