/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.placement.rays;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import gnu.trove.list.array.TIntArrayList;
import ivorius.ivtoolkit.blocks.IvMutableBlockPos;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.ivtoolkit.world.WorldCache;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.TableDataSourceExpression;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCellBoolean;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSupplied;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.utils.expression.PositionedBlockExpression;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.FactorLimit;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.StructurePlaceContext;
import java.lang.reflect.Type;
import java.util.OptionalInt;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class RayAverageMatcher
extends FactorLimit.Ray {
    public final PositionedBlockExpression destMatcher = new PositionedBlockExpression(RecurrentComplex.specialRegistry);
    public boolean up;

    public RayAverageMatcher() {
        this(null, false, "blocks:movement & !is:foliage");
    }

    public RayAverageMatcher(Float weight, boolean up, String destExpression) {
        super(weight);
        this.up = up;
        this.destMatcher.setExpression(destExpression);
    }

    public static BlockPos findFirstBlock(BlockPos.MutableBlockPos pos, Predicate<BlockPos> predicate, boolean up, int wHeight) {
        while (pos.func_177956_o() >= 0 && pos.func_177956_o() < wHeight && !predicate.test((BlockPos)pos)) {
            IvMutableBlockPos.offset((BlockPos)pos, pos, up ? EnumFacing.UP : EnumFacing.DOWN);
        }
        return IvMutableBlockPos.offset((BlockPos)pos, pos, !up ? EnumFacing.UP : EnumFacing.DOWN);
    }

    public static int getAverageGroundLevel(boolean up, int y, StructureBoundingBox boundingBox, Predicate<BlockPos> predicate, int wHeight, double samples, Random random) {
        TIntArrayList list = new TIntArrayList(boundingBox.func_78883_b() * boundingBox.func_78880_d());
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int k = boundingBox.field_78896_c; k <= boundingBox.field_78892_f; ++k) {
            for (int l = boundingBox.field_78897_a; l <= boundingBox.field_78893_d; ++l) {
                if (!(samples >= 1.0) && !(random.nextDouble() < samples)) continue;
                pos.func_181079_c(l, y, k);
                list.add(RayAverageMatcher.findFirstBlock(pos, predicate, up, wHeight).func_177956_o());
            }
        }
        if (list.isEmpty()) {
            return -1;
        }
        return RayAverageMatcher.averageIgnoringErrors(list.toArray());
    }

    protected static int averageIgnoringErrors(int ... values) {
        int average = 0;
        for (int val : values) {
            average += val;
        }
        average /= values.length;
        int averageDist = 0;
        for (int val : values) {
            averageDist += RayAverageMatcher.dist(val, average);
        }
        averageDist /= values.length;
        int newAverage = 0;
        int ignored = 0;
        for (int val : values) {
            if (RayAverageMatcher.dist(val, average) <= averageDist * 2) {
                newAverage += val;
                continue;
            }
            ++ignored;
        }
        return newAverage / (values.length - ignored);
    }

    protected static int dist(int val1, int val2) {
        return val1 > val2 ? val1 - val2 : val2 - val1;
    }

    @Override
    public OptionalInt cast(WorldCache cache, StructurePlaceContext context, int y) {
        int floorBlocks = context.boundingBox.func_78883_b() * context.boundingBox.func_78880_d();
        double samples = floorBlocks < 256 ? 1.0 : Math.pow(256.0f / (float)floorBlocks, 0.7f);
        int averageGroundLevel = RayAverageMatcher.getAverageGroundLevel(this.up, y, context.boundingBox, blockPos -> (Boolean)this.destMatcher.evaluate(() -> PositionedBlockExpression.Argument.at(cache, blockPos)), cache.world.func_72800_K(), samples, context.random);
        return averageGroundLevel >= 0 ? OptionalInt.of(averageGroundLevel) : OptionalInt.empty();
    }

    @Override
    public String displayString() {
        return IvTranslations.get("reccomplex.placer.factors.limit.rays." + FactorLimit.getRayRegistry().iDForType(this.getClass()) + (this.up ? ".title.up" : ".title.down"));
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceSegmented(this.rayTableDataSource(navigator, delegate), TableDataSourceExpression.constructDefault(IvTranslations.get("reccomplex.placer.factors.limit.rays.matcher.condition"), this.destMatcher, null), new TableDataSourceSupplied(() -> {
            TableCellBoolean cell = new TableCellBoolean(null, this.up, IvTranslations.get("reccomplex.direction.up"), IvTranslations.get("reccomplex.direction.down"));
            cell.addPropertyConsumer(v -> {
                this.up = v;
            });
            return new TitledCell(IvTranslations.get("reccomplex.placer.factors.limit.rays.matcher.direction"), cell);
        }));
    }

    public static class Serializer
    implements JsonSerializer<RayAverageMatcher>,
    JsonDeserializer<RayAverageMatcher> {
        public RayAverageMatcher deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.asJsonObject(json, "rayAverageMatcher");
            Float weight = JsonUtils.has(jsonObject, "weight") ? Float.valueOf(JsonUtils.getFloat(jsonObject, "weight")) : null;
            boolean up = JsonUtils.getBoolean(jsonObject, "up", true);
            String destExpression = JsonUtils.getString(jsonObject, "destExpression", "");
            return new RayAverageMatcher(weight, up, destExpression);
        }

        public JsonElement serialize(RayAverageMatcher src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            if (src.weight != null) {
                jsonObject.addProperty("weight", (Number)src.weight);
            }
            jsonObject.addProperty("up", Boolean.valueOf(src.up));
            jsonObject.addProperty("destExpression", src.destMatcher.getExpression());
            return jsonObject;
        }
    }
}

