/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.maze.rules;

import com.google.common.collect.Sets;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import ivorius.ivtoolkit.maze.components.ConnectionStrategy;
import ivorius.ivtoolkit.maze.components.MazeComponent;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazePredicate;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MorphingMazeComponent;
import ivorius.ivtoolkit.maze.components.ShiftedMazeComponent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReachabilityStrategy<C>
implements MazePredicate<C> {
    private final Collection<Ability<C>> traversalAbilities = new ArrayList<Ability<C>>();
    private ConnectionPoint mainConnectionPoint;
    private final List<ConnectionPoint> connectionPoints = new ArrayList<ConnectionPoint>();
    private final TObjectIntMap<ConnectionPoint> stepsReached = new TObjectIntHashMap();
    private final Predicate<MazeRoom> confiner;
    private final ConnectionStrategy<C> connectionStrategy;
    private boolean preventConnection;

    public ReachabilityStrategy(Predicate<MazeRoom> confiner, ConnectionStrategy<C> connectionStrategy, boolean preventConnection) {
        this.confiner = confiner;
        this.connectionStrategy = connectionStrategy;
        this.preventConnection = preventConnection;
    }

    public static <C> ReachabilityStrategy<C> connect(Collection<Collection<MazePassage>> points, Predicate<MazeRoom> confiner, Collection<Ability<C>> traversalAbilities, ConnectionStrategy<C> connectionStrategy) {
        ReachabilityStrategy<C> strategy = new ReachabilityStrategy<C>(confiner, connectionStrategy, false);
        strategy.setConnection(points);
        strategy.traversalAbilities.addAll(traversalAbilities);
        return strategy;
    }

    public static <C> ReachabilityStrategy<C> preventConnection(Collection<Collection<MazePassage>> points, Predicate<MazeRoom> confiner, ConnectionStrategy<C> connectionStrategy) {
        ReachabilityStrategy<C> strategy = new ReachabilityStrategy<C>(confiner, connectionStrategy, true);
        strategy.setConnection(points);
        return strategy;
    }

    public static <C> Collection<Ability<C>> compileAbilities(Collection<? extends MazeComponent<C>> components) {
        HashSet<Ability<C>> abilities = new HashSet<Ability<C>>();
        for (MazeComponent<C> component : components) {
            for (MazePassage source : component.reachability().keySet()) {
                if (!component.rooms().contains(source.getSource())) continue;
                for (MazePassage exit : ReachabilityStrategy.traverse(Collections.singleton(component), new HashSet<MazePassage>(), Collections.singleton(source), null)) {
                    if (component.rooms().contains(exit.getSource()) || source.equals((Object)exit.inverse())) continue;
                    abilities.add(Ability.from(source, exit, component));
                }
            }
        }
        Iterator iterator2 = abilities.iterator();
        while (iterator2.hasNext()) {
            Ability ability = (Ability)iterator2.next();
            if (!ReachabilityStrategy.approximateCanReach(ability.rooms, (c, p) -> ReachabilityStrategy.compatible(ability.exits.get(p), c), abilities.stream().filter(a -> !a.equals(ability)).collect(Collectors.toSet()), Collections.singleton(ability.start), Collections.singleton(ability.destination()), null)) continue;
            iterator2.remove();
        }
        return abilities;
    }

    protected static <C> boolean compatible(C existing, C add) {
        return existing == null || add == null || existing.equals(add);
    }

    public static <C> Predicate<C> connectorTraverser(Set<C> blockingConnections) {
        return input -> !blockingConnections.contains(input);
    }

    protected static <C> Set<MazePassage> traverse(Collection<MazeComponent<C>> mazes, @Nonnull Collection<MazePassage> traversed, Collection<MazePassage> connections, @Nullable Consumer<MazePassage> visitor) {
        MazePassage src;
        if (connections.size() <= 0) {
            return Collections.emptySet();
        }
        ArrayDeque<MazePassage> dirty = new ArrayDeque<MazePassage>(connections);
        HashSet<MazePassage> added = new HashSet<MazePassage>();
        while ((src = (MazePassage)((Object)dirty.pollFirst())) != null) {
            for (MazeComponent<C> maze : mazes) {
                maze.reachability().get((Object)src).forEach(dest -> {
                    if (traversed.add((MazePassage)((Object)dest))) {
                        if (visitor != null) {
                            visitor.accept((MazePassage)((Object)dest));
                        }
                        added.add((MazePassage)((Object)dest));
                        dirty.addLast((MazePassage)((Object)dest));
                    }
                });
            }
        }
        return added;
    }

    private static <C> boolean approximateCanReach(Set<MazeRoom> rooms, BiPredicate<C, MazePassage> connector, Collection<Ability<C>> abilities, Set<MazePassage> left, Set<MazePassage> right, Predicate<MazeRoom> confiner) {
        return ReachabilityStrategy.approximateCanReach(rooms, abilities, Collections.emptyList(), left, right, Collections.emptyList(), confiner, connector);
    }

    private static <C> boolean approximateCanReach(Set<MazeRoom> rooms, Collection<Ability<C>> abilities, Collection<MazeComponent<C>> mazes, Set<MazePassage> left, Set<MazePassage> right, Collection<MazePassage> pTraversed, Predicate<MazeRoom> confiner, BiPredicate<C, MazePassage> connector) {
        MazePassage curPre;
        if (left.size() <= 0 || right.size() <= 0) {
            return false;
        }
        if (left.stream().anyMatch(right::contains)) {
            return true;
        }
        HashSet traversed = Sets.newHashSet(pTraversed);
        Predicate<MazeRoom> roomPlaceable = confiner != null ? o -> confiner.test((MazeRoom)o) && !rooms.contains(o) : rooms::contains;
        Predicate<MazePassage> passagePlaceable = o -> roomPlaceable.test(o.getSource());
        HashSet visited = Sets.newHashSet(left);
        TreeSet dirty = Sets.newTreeSet((o1, o2) -> {
            int compare = Double.compare(ReachabilityStrategy.minDistanceSQ(o1, right), ReachabilityStrategy.minDistanceSQ(o2, right));
            if (compare != 0) {
                return compare;
            }
            compare = ReachabilityStrategy.compare(o1.getSource().getCoordinates(), o2.getSource().getCoordinates());
            if (compare != 0) {
                return compare;
            }
            compare = ReachabilityStrategy.compare(o1.getDest().getCoordinates(), o2.getDest().getCoordinates());
            if (compare != 0) {
                return compare;
            }
            return 0;
        });
        dirty.addAll(left);
        visited.addAll(left);
        while ((curPre = (MazePassage)((Object)dirty.pollFirst())) != null) {
            MazePassage cur = curPre;
            for (Ability ability2 : abilities.stream().filter(ability -> ability.start.distance(cur) != null).filter(ability -> ability.rooms.stream().map(r -> r.add(cur.getSource())).allMatch(roomPlaceable)).filter(ability -> ability.exits.keySet().stream().allMatch(p -> connector.test(ability.exits.get(p), p.add(cur.getSource()))))::iterator) {
                MazePassage dest = ability2.destination().add(cur.getSource());
                if (right.contains((Object)dest)) {
                    return true;
                }
                if (passagePlaceable.test(dest) && visited.add(dest)) {
                    dirty.add(dest);
                }
                for (MazePassage p : ReachabilityStrategy.traverse(mazes, traversed, Collections.singleton(dest), null).stream().distinct()::iterator) {
                    if (right.contains((Object)p)) {
                        return true;
                    }
                    if (!passagePlaceable.test(p) || !visited.add(p)) continue;
                    dirty.add(p);
                }
            }
        }
        return false;
    }

    private static int compare(int[] left, int[] right) {
        for (int i = 0; i < left.length; ++i) {
            int cmp = Integer.compare(left[i], right[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static double minDistanceSQ(MazePassage passage, Collection<MazePassage> rooms) {
        return rooms.stream().map(MazePassage::getDest).mapToDouble(o -> o.distanceSQ(passage.getSource())).min().orElseThrow(InternalError::new);
    }

    protected static <C> C exitFromEither(MazeComponent<C> left, MazeComponent<C> right, MazePassage p) {
        C c = left.exits().get((Object)p);
        return c != null ? c : right.exits().get((Object)p);
    }

    protected void setConnection(Collection<Collection<MazePassage>> points) {
        this.connectionPoints.addAll(points.stream().map(p -> new ConnectionPoint((Collection<MazePassage>)p, p.stream().map(MazePassage::inverse).collect(Collectors.toList()))).collect(Collectors.toList()));
        this.mainConnectionPoint = this.connectionPoints.size() > 0 ? this.connectionPoints.remove(0) : null;
    }

    @Override
    public boolean canPlace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<?, C> component) {
        boolean canPlace;
        if (this.preventConnection && !this.stepsReached.isEmpty()) {
            return true;
        }
        if (this.stepsReached.size() == this.connectionPoints.size()) {
            return true;
        }
        Predicate<MazePassage> isDirtyPre = this.dirtyPassages(maze.exits().keySet());
        boolean[] unconnectable = new boolean[this.connectionPoints.size()];
        for (int i = 0; i < this.connectionPoints.size(); ++i) {
            ConnectionPoint point = this.connectionPoints.get(i);
            if (!point.traversed.stream().noneMatch(isDirtyPre)) continue;
            unconnectable[i] = true;
        }
        this.place(maze, component, true);
        Sets.SetView roomsFromBoth = Sets.union(maze.rooms(), component.rooms());
        Sets.SetView exitsFromBoth = Sets.union(maze.exits().keySet(), component.exits().keySet());
        Predicate<MazePassage> isDirty = this.dirtyPassages((Set<MazePassage>)exitsFromBoth);
        if (this.preventConnection) {
            canPlace = this.stepsReached.isEmpty();
        } else {
            canPlace = true;
            for (int i = 0; i < this.connectionPoints.size(); ++i) {
                ConnectionPoint point = this.connectionPoints.get(i);
                boolean bl = canPlace = this.stepsReached.containsKey((Object)point) || unconnectable[i] || ReachabilityStrategy.approximateCanReach((Set<MazeRoom>)roomsFromBoth, this.traversalAbilities, Arrays.asList(maze, component), point.traversed.stream().filter(isDirty).collect(Collectors.toSet()), this.mainConnectionPoint.traversed.stream().filter(isDirty).map(MazePassage::inverse).collect(Collectors.toSet()), point.traversed, this.confiner, (c, p) -> this.connectionStrategy.connect((MazePassage)((Object)p), ReachabilityStrategy.exitFromEither(maze, component, p.inverse()), (C)c) > 0.0f);
                if (!canPlace) break;
            }
        }
        this.unplace(maze, component, true);
        return canPlace;
    }

    @Nonnull
    protected Predicate<MazePassage> dirtyPassages(Set<MazePassage> r) {
        return input -> this.confiner.test(input.getSource()) && !r.contains(input);
    }

    @Override
    public void willPlace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<?, C> component) {
        this.place(maze, component, false);
    }

    @Override
    public void didPlace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<?, C> component) {
    }

    @Override
    public void willUnplace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<?, C> component) {
    }

    protected void place(MorphingMazeComponent<C> maze, ShiftedMazeComponent<?, C> component, boolean simulate) {
        if (this.stepsReached.size() == this.connectionPoints.size()) {
            this.stepsReached.transformValues(i -> i + 1);
        } else {
            for (ConnectionPoint point2 : this.connectionPoints) {
                if (this.stepsReached.containsKey((Object)point2)) {
                    this.stepsReached.adjustValue((Object)point2, 1);
                    continue;
                }
                point2.order.add(this.traverse(maze, component, point2.traversed, this.mainConnectionPoint.traversed, p -> this.stepsReached.put((Object)point2, 0)));
            }
            this.mainConnectionPoint.order.add(this.traverse(maze, component, this.mainConnectionPoint.traversed, this.connectionPoints.stream().filter(point -> !this.stepsReached.containsKey(point)).flatMap(point -> point.traversed.stream()).collect(Collectors.toList()), p -> this.connectionPoints.stream().filter(point -> point.traversed.contains(p)).forEach(point -> this.stepsReached.put(point, 0))));
        }
    }

    protected Set<MazePassage> traverse(MazeComponent<C> maze, MazeComponent<C> component, Set<MazePassage> traversed, Collection<MazePassage> goal, Consumer<MazePassage> goalConsumer) {
        return ReachabilityStrategy.traverse(Arrays.asList(maze, component), traversed, (Collection<MazePassage>)Sets.intersection(component.exits().keySet(), traversed), connection -> {
            if (goal.contains(connection)) {
                goalConsumer.accept((MazePassage)((Object)connection));
            }
        });
    }

    @Override
    public void didUnplace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<?, C> component) {
        this.unplace(maze, component, false);
    }

    protected void unplace(MorphingMazeComponent<C> maze, ShiftedMazeComponent<?, C> component, boolean simulate) {
        this.stepsReached.transformValues(i -> i - 1);
        this.stepsReached.retainEntries((a, i) -> i >= 0);
        if (this.stepsReached.size() < this.connectionPoints.size()) {
            this.mainConnectionPoint.reverseStep();
            this.connectionPoints.stream().filter(point -> point.order.size() > this.mainConnectionPoint.order.size()).forEach(ConnectionPoint::reverseStep);
        }
    }

    @Override
    public boolean isDirtyConnection(MazeRoom dest, MazeRoom source, C c) {
        return true;
    }

    protected Function<MazeRoom, String> dirtyMarker(MazeComponent component, @Nullable MazeComponent place) {
        return r -> {
            if (this.isDirty((MazeRoom)r, this.mainConnectionPoint, component)) {
                return "0";
            }
            int p = this.connectionPoints.stream().filter(point -> this.isDirty((MazeRoom)r, (ConnectionPoint)point, component)).mapToInt(this.connectionPoints::indexOf).findFirst().orElse(-1);
            if (p >= 0) {
                return "" + (p + 1);
            }
            if (place != null && place.rooms().contains(r)) {
                return "O";
            }
            return null;
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDirty(MazeRoom r, ConnectionPoint point, MazeComponent<?> component) {
        if (this.stepsReached.containsKey((Object)point)) return false;
        if (!point.traversed.stream().filter(this.dirtyPassages(component.exits().keySet())).anyMatch(r::equals)) return false;
        return true;
    }

    private class ConnectionPoint {
        public final Set<MazePassage> traversed = new HashSet<MazePassage>();
        public final List<Set<MazePassage>> order = new ArrayList<Set<MazePassage>>();

        @SafeVarargs
        public ConnectionPoint(Collection<MazePassage> ... points) {
            Arrays.stream(points).forEach(this.traversed::addAll);
        }

        public void reverseStep() {
            this.traversed.removeAll((Collection)this.order.remove(this.order.size() - 1));
        }
    }

    private static class Ability<C> {
        @Nonnull
        public final MazePassage start;
        @Nonnull
        public final MazePassage destination;
        @Nonnull
        public final Set<MazeRoom> rooms;
        @Nonnull
        public final Map<MazePassage, C> exits;

        public Ability(@Nonnull MazePassage start, @Nonnull MazePassage destination, @Nonnull Set<MazeRoom> rooms, @Nonnull Map<MazePassage, C> exits) {
            this.start = start;
            this.destination = destination;
            this.rooms = rooms;
            this.exits = exits;
        }

        public static <C> Ability<C> from(@Nonnull MazePassage start, @Nonnull MazePassage destination, MazeComponent<C> component) {
            return new Ability<Object>(start.normalize(), destination.sub(start.getSource()), component.rooms().stream().map(r -> r.sub(start.getSource())).collect(Collectors.toSet()), component.exits().keySet().stream().collect(Collectors.toMap(r -> r.sub(start.getSource()), component.exits()::get)));
        }

        public MazePassage destination() {
            return this.destination;
        }

        @Nonnull
        public Function<MazePassage, C> exits() {
            return this.exits::get;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ability ability = (Ability)o;
            if (!this.destination.equals((Object)ability.destination)) {
                return false;
            }
            if (!this.start.equals((Object)ability.start)) {
                return false;
            }
            if (!this.rooms.equals(ability.rooms)) {
                return false;
            }
            return this.exits.equals(ability.exits);
        }

        public int hashCode() {
            int result = this.destination.hashCode();
            result = 31 * result + this.start.hashCode();
            result = 31 * result + this.rooms.hashCode();
            result = 31 * result + this.exits.hashCode();
            return result;
        }

        public String toString() {
            return "Ability{destination=" + (Object)((Object)this.destination) + "expect=" + (Object)((Object)this.start) + ", rooms=" + this.rooms + ", exits=" + this.exits + '}';
        }
    }
}

