/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic.generation;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.Directions;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceVanillaStructureGeneration;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.expression.BiomeExpression;
import ivorius.reccomplex.world.gen.feature.structure.Placer;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import ivorius.reccomplex.world.gen.feature.structure.generic.placement.GenericPlacer;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;

public class VanillaGeneration
extends GenerationType {
    public Double generationWeight;
    public double minBaseLimit;
    public double maxBaseLimit;
    public double minScaledLimit;
    public double maxScaledLimit;
    @Nullable
    public EnumFacing front;
    public BlockPos spawnShift;
    public BiomeExpression biomeExpression;

    public VanillaGeneration() {
        this(null, null, 0.0, 2.0, 1.0, 1.0, EnumFacing.NORTH, BlockPos.field_177992_a, "");
    }

    public VanillaGeneration(@Nullable String id, Double generationWeight, double minBaseLimit, double maxBaseLimit, double minScaledLimit, double maxScaledLimit, EnumFacing front, BlockPos spawnShift, String biomeExpression) {
        super(id != null ? id : VanillaGeneration.randomID(VanillaGeneration.class));
        this.generationWeight = generationWeight;
        this.minBaseLimit = minBaseLimit;
        this.maxBaseLimit = maxBaseLimit;
        this.minScaledLimit = minScaledLimit;
        this.maxScaledLimit = maxScaledLimit;
        this.front = front;
        this.spawnShift = spawnShift;
        this.biomeExpression = ExpressionCache.of(new BiomeExpression(), biomeExpression);
    }

    @Override
    @Nonnull
    public String id() {
        return this.id;
    }

    @Override
    public void setID(@Nonnull String id) {
        this.id = id;
    }

    public void setSpawnShift(BlockPos spawnShift) {
        this.spawnShift = spawnShift;
    }

    @Override
    public String displayString() {
        return IvTranslations.get("reccomplex.generationInfo.vanilla.title");
    }

    @Override
    @Nullable
    public Placer placer() {
        return GenericPlacer.surfacePlacer();
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceVanillaStructureGeneration(navigator, delegate, this);
    }

    public boolean generatesIn(Biome biome) {
        return this.biomeExpression.test(biome);
    }

    public double getActiveWeight() {
        return this.generationWeight != null ? this.generationWeight : 1.0;
    }

    public int getVanillaWeight(double tweak) {
        return MathHelper.func_76128_c((double)(this.getActiveWeight() * tweak * (double)RCConfig.baseVillageSpawnWeight + 0.5));
    }

    public static class Serializer
    implements JsonSerializer<VanillaGeneration>,
    JsonDeserializer<VanillaGeneration> {
        public VanillaGeneration deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.asJsonObject(json, "vanillaStructureSpawnInfo");
            String id = GenerationType.readID(jsonObject);
            Double spawnWeight = jsonObject.has("generationWeight") ? Double.valueOf(JsonUtils.getDouble(jsonObject, "generationWeight")) : null;
            double minBaseLimit = JsonUtils.getDouble(jsonObject, "minBaseLimit", 0.0);
            double maxBaseLimit = JsonUtils.getDouble(jsonObject, "maxBaseLimit", 0.0);
            double minScaledLimit = JsonUtils.getDouble(jsonObject, "minScaledLimit", 0.0);
            double maxScaledLimit = JsonUtils.getDouble(jsonObject, "maxScaledLimit", 0.0);
            int spawnX = JsonUtils.getInt(jsonObject, "spawnShiftX", 0);
            int spawnY = JsonUtils.getInt(jsonObject, "spawnShiftY", 0);
            int spawnZ = JsonUtils.getInt(jsonObject, "spawnShiftZ", 0);
            EnumFacing front = jsonObject.has("front") ? Directions.deserialize(JsonUtils.getString(jsonObject, "front")) : null;
            String biomeExpression = JsonUtils.getString(jsonObject, "biomeExpression", "");
            return new VanillaGeneration(id, spawnWeight, minBaseLimit, maxBaseLimit, minScaledLimit, maxScaledLimit, front, new BlockPos(spawnX, spawnY, spawnZ), biomeExpression);
        }

        public JsonElement serialize(VanillaGeneration src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", src.id);
            if (src.generationWeight != null) {
                jsonObject.addProperty("generationWeight", (Number)src.generationWeight);
            }
            jsonObject.addProperty("minBaseLimit", (Number)src.minBaseLimit);
            jsonObject.addProperty("maxBaseLimit", (Number)src.maxBaseLimit);
            jsonObject.addProperty("minScaledLimit", (Number)src.minScaledLimit);
            jsonObject.addProperty("maxScaledLimit", (Number)src.maxScaledLimit);
            jsonObject.addProperty("spawnShiftX", (Number)src.spawnShift.func_177958_n());
            jsonObject.addProperty("spawnShiftY", (Number)src.spawnShift.func_177956_o());
            jsonObject.addProperty("spawnShiftZ", (Number)src.spawnShift.func_177952_p());
            if (src.front != null) {
                jsonObject.addProperty("front", Directions.serialize(src.front));
            }
            jsonObject.addProperty("biomeExpression", src.biomeExpression.getExpression());
            return jsonObject;
        }
    }
}

