/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.expression.EnvironmentExpression;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.VariableDomain;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;

public class GenericVariableDomain {
    @SerializedName(value="variables")
    protected final List<Variable> variables = new ArrayList<Variable>();

    public List<Variable> variables() {
        return this.variables;
    }

    public void fill(VariableDomain domain, Environment environment, Random random) {
        for (Variable variable : this.variables) {
            if (domain.isSet(variable.id)) continue;
            domain.set(variable.id, random.nextFloat() < variable.chance && variable.condition.test(environment));
        }
    }

    public float chance(Environment environment) {
        float chance = 1.0f;
        for (Variable variable : this.variables) {
            chance *= this.chance(variable, environment.variables.get(variable.id), environment);
        }
        return chance;
    }

    public float chance(Variable variable, boolean value, Environment environment) {
        return variable.condition.test(environment) ? (value ? variable.chance : 1.0f - variable.chance) : (float)(!value ? 1 : 0);
    }

    public Stream<VariableDomain> omega(Environment environment, boolean logical) {
        Stream<VariableDomain> stream = Stream.of(environment.variables.copy());
        for (Variable variable : this.variables) {
            if (logical && !variable.affectsLogic || environment.variables.isSet(variable.id)) continue;
            stream = stream.flatMap(d -> {
                VariableDomain cached = environment.variables;
                environment.variables = d;
                boolean top = variable.chance > 0.0f && variable.condition.test(environment);
                boolean bottom = variable.chance < 1.0f;
                environment.variables = cached;
                if (top && bottom) {
                    return d.split(variable.id);
                }
                return Stream.of(d.set(variable.id, top));
            });
        }
        return stream;
    }

    public static class Variable {
        public String id = "";
        public EnvironmentExpression condition = ExpressionCache.of(new EnvironmentExpression(), "");
        public float chance = 0.5f;
        public boolean affectsLogic = false;

        public Variable copy() {
            Variable var = new Variable();
            var.id = this.id;
            var.condition.setExpression(this.condition.getExpression());
            var.chance = this.chance;
            var.affectsLogic = this.affectsLogic;
            return var;
        }

        public static class Serializer
        implements JsonSerializer<Variable>,
        JsonDeserializer<Variable> {
            public Variable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonObject = JsonUtils.asJsonObject(json, "Generic Variable");
                Variable variable = new Variable();
                variable.id = JsonUtils.getString(jsonObject, "id");
                variable.condition.setExpression(JsonUtils.getString(jsonObject, "condition", ""));
                variable.chance = JsonUtils.getFloat(jsonObject, "chance");
                variable.affectsLogic = JsonUtils.getBoolean(jsonObject, "affectsLogic");
                return variable;
            }

            public JsonElement serialize(Variable src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("id", src.id);
                jsonObject.addProperty("condition", src.condition.getExpression());
                jsonObject.addProperty("chance", (Number)Float.valueOf(src.chance));
                jsonObject.addProperty("affectsLogic", Boolean.valueOf(src.affectsLogic));
                return jsonObject;
            }
        }
    }
}

