/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.generic;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import ivorius.ivtoolkit.blocks.BlockPositions;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.math.Transforms;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.tools.GuavaCollectors;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.ivtoolkit.tools.NBTCompoundObjects;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.utils.algebra.ExpressionCache;
import ivorius.reccomplex.utils.expression.PositionedBlockExpression;
import ivorius.reccomplex.world.gen.feature.structure.generic.Selection;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class BlockPattern
implements NBTCompoundObject {
    public static final Gson gson = BlockPattern.createGson();
    public final Selection pattern = new Selection(3);
    public final List<Ingredient> ingredients = new ArrayList<Ingredient>();

    public BlockPattern(List<Selection.Area> pattern, List<Ingredient> ingredients) {
        this.pattern.addAll(pattern);
        this.ingredients.addAll(ingredients);
    }

    public BlockPattern() {
        this.pattern.add(new Selection.Area(true, new int[]{0, 0, 0}, new int[]{0, 0, 0}, "Sapling"));
        this.ingredients.add(new Ingredient("Sapling", ExpressionCache.of(new PositionedBlockExpression(RecurrentComplex.specialRegistry), "block.id=minecraft:sapling"), true));
    }

    private static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(BlockPattern.class, (Object)new Serializer());
        builder.registerTypeAdapter(Ingredient.class, (Object)new IngredientSerializer(RecurrentComplex.specialRegistry));
        return builder.create();
    }

    public BlockPattern copy() {
        return new BlockPattern(this.pattern.copy(), this.ingredients);
    }

    public void transform(AxisAlignedTransform2D transform, int[] size) {
        this.pattern.transform(transform, size, 1);
    }

    @Nonnull
    public BlockPattern copy(AxisAlignedTransform2D transform, int[] size) {
        BlockPattern transformed = this.copy();
        transformed.transform(transform, size);
        return transformed;
    }

    public Optional<Ingredient> findIngredient(String id) {
        return this.ingredients.stream().filter(i -> i.identifier.equals(id)).findFirst();
    }

    public boolean test(World world, BlockPos pos) {
        return this.pattern.compile(true).entrySet().stream().allMatch(entry -> this.findIngredient((String)entry.getValue()).filter(i -> (Boolean)i.matcher.evaluate(() -> PositionedBlockExpression.Argument.at(world, pos.func_177971_a((Vec3i)BlockPositions.fromIntArray(((MazeRoom)entry.getKey()).getCoordinates()))))).isPresent());
    }

    public boolean canPlace(World world, BlockPos pos, int[] size, boolean rotate, boolean mirror) {
        return Transforms.transformStream(rotate, mirror).anyMatch(transform -> this.copy((AxisAlignedTransform2D)transform, size).testAll(world, pos).findAny().isPresent());
    }

    public Multimap<AxisAlignedTransform2D, BlockPos> testAll(World world, BlockPos pos, int[] size, boolean rotate, boolean mirror) {
        return (Multimap)Transforms.transformStream(rotate, mirror).collect(GuavaCollectors.toMultimap(o -> o, transform -> this.copy((AxisAlignedTransform2D)transform, size).testAll(world, pos)::iterator));
    }

    @Nonnull
    public Stream<BlockPos> testAll(World world, BlockPos pos) {
        return this.pattern.compile(true).keySet().stream().map(room -> pos.func_177973_b((Vec3i)BlockPositions.fromIntArray(room.getCoordinates()))).filter(p -> this.test(world, (BlockPos)p));
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.pattern.readFromNBT(compound.func_74775_l("pattern"));
        this.ingredients.clear();
        this.ingredients.addAll(NBTCompoundObjects.readListFrom(compound, "ingredients", Ingredient::new));
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTCompoundObjects.writeTo(compound, "pattern", this.pattern);
        NBTCompoundObjects.writeListTo(compound, "ingredients", this.ingredients);
    }

    public void forEach(Predicate<Ingredient> filter, Consumer<Map.Entry<BlockPos, String>> consumer) {
        this.pattern.compile(true).entrySet().stream().filter(entry -> this.findIngredient((String)entry.getValue()).filter(filter).isPresent()).map(entry -> Pair.of((Object)BlockPositions.fromIntArray(((MazeRoom)entry.getKey()).getCoordinates()), entry.getValue())).forEach(consumer);
    }

    public static class IngredientSerializer
    implements JsonSerializer<Ingredient>,
    JsonDeserializer<Ingredient> {
        private MCRegistry registry;

        public IngredientSerializer(MCRegistry registry) {
            this.registry = registry;
        }

        public Ingredient deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.asJsonObject(json, "blockPatternIngredient");
            String id = JsonUtils.getString(jsonObject, "id", "");
            String blockExpression = JsonUtils.getString(jsonObject, "blockExpression", "");
            boolean delete = JsonUtils.getBoolean(jsonObject, "delete", true);
            return new Ingredient(id, ExpressionCache.of(new PositionedBlockExpression(this.registry), blockExpression), delete);
        }

        public JsonElement serialize(Ingredient src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", src.identifier);
            jsonObject.addProperty("blockExpression", src.matcher.getExpression());
            jsonObject.addProperty("delete", Boolean.valueOf(src.delete));
            return jsonObject;
        }
    }

    public static class Serializer
    implements JsonSerializer<BlockPattern>,
    JsonDeserializer<BlockPattern> {
        public BlockPattern deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.asJsonObject(json, "blockPattern");
            List pattern = (List)context.deserialize(jsonObject.get("pattern"), new TypeToken<List<Selection.Area>>(){}.getType());
            List ingredients = (List)gson.fromJson(jsonObject.get("ingredients"), new TypeToken<List<Ingredient>>(){}.getType());
            return new BlockPattern(pattern, ingredients);
        }

        public JsonElement serialize(BlockPattern src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("pattern", gson.toJsonTree((Object)src.pattern));
            jsonObject.add("ingredients", gson.toJsonTree(src.ingredients));
            return jsonObject;
        }
    }

    public static class Ingredient
    implements NBTCompoundObject {
        public String identifier;
        public PositionedBlockExpression matcher;
        public boolean delete;

        public Ingredient() {
            this.identifier = "";
            this.matcher = ExpressionCache.of(new PositionedBlockExpression(RecurrentComplex.specialRegistry), "");
            this.delete = true;
        }

        public Ingredient(String identifier, PositionedBlockExpression matcher, boolean delete) {
            this.identifier = identifier;
            this.matcher = matcher;
            this.delete = delete;
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            this.identifier = compound.func_74779_i("identifier");
            this.matcher = ExpressionCache.of(new PositionedBlockExpression(RecurrentComplex.specialRegistry), compound.func_74779_i("blockExpression"));
            this.delete = compound.func_74767_n("delete");
        }

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74778_a("identifier", this.identifier);
            compound.func_74778_a("blockExpression", this.matcher.getExpression());
            compound.func_74757_a("delete", this.delete);
        }

        public Ingredient copy() {
            return new Ingredient(this.identifier, ExpressionCache.of(new PositionedBlockExpression(this.matcher.registry), this.matcher.getExpression()), this.delete);
        }
    }
}

