/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure;

import gnu.trove.map.TObjectByteMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.nbt.NBTTagCompound;

public class VariableDomain
implements NBTCompoundObject {
    protected final TObjectByteMap<String> variables = new TObjectByteHashMap();

    public VariableDomain() {
    }

    public VariableDomain(TObjectByteMap<String> variables) {
        this.variables.putAll(variables);
    }

    public void fill(VariableDomain domain) {
        this.variables.forEachEntry((a, b) -> {
            domain.variables.putIfAbsent(a, b);
            return true;
        });
    }

    public boolean get(String variable) {
        return this.variables.get((Object)variable) != 0;
    }

    public boolean isSet(String variable) {
        return this.variables.containsKey((Object)variable);
    }

    public VariableDomain set(String variable, boolean value) {
        this.variables.put((Object)variable, (byte)(value ? 1 : 0));
        return this;
    }

    public Stream<VariableDomain> split(String variable) {
        return IntStream.of(0, 1).mapToObj(i -> {
            VariableDomain copy = this.copy();
            copy.set(variable, i != 0);
            return copy;
        });
    }

    public VariableDomain copy() {
        return new VariableDomain(this.variables);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.variables.clear();
        for (String s : compound.func_150296_c()) {
            this.set(s, compound.func_74767_n(s));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        this.variables.forEachEntry((a, b) -> {
            compound.func_74757_a(a, b != 0);
            return true;
        });
    }
}

