/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import ivorius.ivtoolkit.blocks.BlockSurfacePos;
import ivorius.ivtoolkit.world.chunk.Chunks;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.files.SimpleLeveledRegistry;
import ivorius.reccomplex.files.loading.LeveledRegistry;
import ivorius.reccomplex.json.SerializableStringTypeRegistry;
import ivorius.reccomplex.world.gen.feature.decoration.RCBiomeDecorator;
import ivorius.reccomplex.world.gen.feature.selector.CachedStructureSelectors;
import ivorius.reccomplex.world.gen.feature.selector.MixingStructureSelector;
import ivorius.reccomplex.world.gen.feature.selector.NaturalStructureSelector;
import ivorius.reccomplex.world.gen.feature.selector.StructureSelector;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.ListGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.MazeGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.NaturalGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.StaticGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.VanillaDecorationGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.VanillaGeneration;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.Transformer;
import ivorius.reccomplex.world.gen.feature.villages.GenericVillageCreationHandler;
import ivorius.reccomplex.world.gen.feature.villages.GenericVillagePiece;
import ivorius.reccomplex.world.gen.feature.villages.TemporaryVillagerRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class StructureRegistry
extends SimpleLeveledRegistry<Structure<?>> {
    public static final StructureRegistry INSTANCE = new StructureRegistry();
    public static SerializableStringTypeRegistry<Transformer> TRANSFORMERS = new SerializableStringTypeRegistry<Transformer>("transformer", "type", Transformer.class);
    public static SerializableStringTypeRegistry<GenerationType> GENERATION_TYPES = new SerializableStringTypeRegistry<GenerationType>("generationInfo", "type", GenerationType.class);
    private Map<Class<? extends GenerationType>, Collection<Pair<Structure<?>, ? extends GenerationType>>> cachedGeneration = new HashMap();
    private CachedStructureSelectors<MixingStructureSelector<NaturalGeneration, NaturalStructureSelector.Category>> naturalSelectors = new CachedStructureSelectors<MixingStructureSelector>((biome, worldProvider) -> new MixingStructureSelector(this.activeMap(), (WorldProvider)worldProvider, (Biome)biome, NaturalGeneration.class));
    private CachedStructureSelectors<StructureSelector<VanillaDecorationGeneration, RCBiomeDecorator.DecorationType>> decorationSelectors = new CachedStructureSelectors<StructureSelector>((biome, worldProvider) -> new StructureSelector(this.activeMap(), (WorldProvider)worldProvider, (Biome)biome, VanillaDecorationGeneration.class));

    public StructureRegistry() {
        super("structure");
    }

    @Override
    public Structure register(String id, String domain, Structure structure, boolean active, LeveledRegistry.ILevel level) {
        if (!(!active || RCConfig.shouldStructureGenerate(id, domain) && structure.areDependenciesResolved())) {
            active = false;
        }
        Structure prev = super.register(id, domain, structure, active, level);
        this.clearCaches();
        return prev;
    }

    @Override
    public Structure unregister(String id, LeveledRegistry.ILevel level) {
        this.clearCaches();
        return (Structure)super.unregister(id, level);
    }

    protected <T extends GenerationType> Collection<Pair<Structure<?>, T>> getCachedGeneration(Class<T> clazz) {
        return this.cachedGeneration.get(clazz);
    }

    public <T extends GenerationType> Collection<Pair<Structure<?>, T>> getStructureGenerations(Class<T> clazz) {
        Collection<Pair<Structure<?>, T>> pairs = this.getCachedGeneration(clazz);
        if (pairs != null) {
            return pairs;
        }
        pairs = new ArrayList();
        for (Structure info : this.allActive()) {
            List<T> generationInfos = info.generationTypes(clazz);
            for (GenerationType t : generationInfos) {
                pairs.add(Pair.of((Object)info, (Object)t));
            }
        }
        ((ArrayList)pairs).trimToSize();
        this.cachedGeneration.put(clazz, pairs);
        return pairs;
    }

    public Stream<Pair<Structure<?>, ListGeneration>> getStructuresInList(String listID, @Nullable EnumFacing front) {
        Predicate<Pair> predicate = input -> listID.equals(((ListGeneration)input.getRight()).listID) && (front == null || ((Structure)input.getLeft()).isRotatable() || ((ListGeneration)input.getRight()).front == front);
        return this.getStructureGenerations(ListGeneration.class).stream().filter(predicate);
    }

    public Stream<Pair<Structure<?>, MazeGeneration>> getStructuresInMaze(String mazeID) {
        Predicate<Pair> predicate = input -> {
            MazeGeneration info = (MazeGeneration)input.getRight();
            return mazeID.equals(info.mazeID) && info.mazeComponent.isValid();
        };
        return this.getStructureGenerations(MazeGeneration.class).stream().filter(predicate);
    }

    public Stream<Triple<Structure<?>, StaticGeneration, BlockSurfacePos>> getStaticStructuresAt(ChunkPos chunkPos, World world, BlockPos spawnPos) {
        Predicate<Pair> predicate = input -> {
            StaticGeneration info = (StaticGeneration)input.getRight();
            return info.dimensionExpression.test(world.field_73011_w) && (info.pattern != null || Chunks.contains(chunkPos, info.getPos(spawnPos)));
        };
        Stream<Pair> statics = this.getStructureGenerations(StaticGeneration.class).stream().filter(predicate);
        return statics.flatMap(pair -> {
            StaticGeneration info = (StaticGeneration)pair.getRight();
            return info.hasPattern() ? Chunks.repeatIntersections(chunkPos, info.getPos(spawnPos), info.pattern.repeatX, info.pattern.repeatZ).map((? super T pos) -> Triple.of((Object)pair.getLeft(), (Object)info, (Object)pos)) : Stream.of(Triple.of((Object)pair.getLeft(), (Object)info, (Object)info.getPos(spawnPos)));
        });
    }

    public CachedStructureSelectors<MixingStructureSelector<NaturalGeneration, NaturalStructureSelector.Category>> naturalStructureSelectors() {
        return this.naturalSelectors;
    }

    public CachedStructureSelectors<StructureSelector<VanillaDecorationGeneration, RCBiomeDecorator.DecorationType>> decorationSelectors() {
        return this.decorationSelectors;
    }

    private void clearCaches() {
        this.naturalSelectors.clear();
        this.decorationSelectors.clear();
        this.cachedGeneration.clear();
        this.updateVanillaGenerations();
        for (Pair<Structure<?>, VanillaGeneration> pair : this.getStructureGenerations(VanillaGeneration.class)) {
            String generationID;
            String structureID = this.id(pair.getLeft());
            Class<? extends GenericVillagePiece> clazz = GenericVillageCreationHandler.getPieceClass(structureID, generationID = ((VanillaGeneration)pair.getRight()).id());
            if (clazz == null) continue;
            MapGenStructureIO.func_143031_a(clazz, (String)("Rc:" + structureID + "_" + generationID));
        }
    }

    private void updateVanillaGenerations() {
        TemporaryVillagerRegistry.instance().setHandlers(Sets.newHashSet((Iterable)Collections2.transform(this.getStructureGenerations(VanillaGeneration.class), input -> GenericVillageCreationHandler.forGeneration(this.id(input.getLeft()), ((VanillaGeneration)input.getRight()).id())).stream().filter(Objects::nonNull).collect(Collectors.toList())));
    }

    private static class StructureData {
        public boolean disabled;
        public String domain;

        public StructureData(boolean disabled, String domain) {
            this.disabled = disabled;
            this.domain = domain;
        }
    }
}

