/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.decoration;

import ivorius.ivtoolkit.tools.IvGsonHelper;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.world.gen.feature.StructureGenerator;
import ivorius.reccomplex.world.gen.feature.WorldGenStructures;
import ivorius.reccomplex.world.gen.feature.decoration.VanillaDecorationAdapter;
import ivorius.reccomplex.world.gen.feature.selector.StructureSelector;
import ivorius.reccomplex.world.gen.feature.structure.Placer;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.StructureRegistry;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureSpawnContext;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.VanillaDecorationGeneration;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.Pair;

public class RCBiomeDecorator {
    public static Adapter vanillaAdapter = new VanillaDecorationAdapter();
    public static final List<Adapter> adapters = new ArrayList<Adapter>();
    public static final int STRUCTURE_TRIES = 5;

    @ParametersAreNonnullByDefault
    public static Event.Result decorate(WorldServer worldIn, Random random, BlockPos chunkPos, DecorationType type) {
        try {
            return RCBiomeDecorator.doDecorate(worldIn, random, chunkPos, type);
        }
        catch (Exception e) {
            RecurrentComplex.logger.error("Exception when decorating", (Throwable)e);
            return null;
        }
    }

    protected static Event.Result doDecorate(WorldServer worldIn, Random random, BlockPos chunkPos, DecorationType type) {
        BiomeDecorator decorator;
        Biome biomeIn = worldIn.func_180494_b(chunkPos.func_177982_a(16, 0, 16));
        Adapter adapter = RCBiomeDecorator.adapter(worldIn, chunkPos, type, biomeIn, decorator = biomeIn.field_76760_I);
        int origAmount = adapter.amount(worldIn, random, biomeIn, decorator, chunkPos, type);
        if (origAmount < 0) {
            return null;
        }
        int vanillaAmount = RCBiomeDecorator.doDecorate(worldIn, random, chunkPos, type, origAmount, adapter.mayGiveUp(worldIn, random, biomeIn, decorator, chunkPos, type));
        if (vanillaAmount == origAmount) {
            return null;
        }
        for (int i = 0; i < vanillaAmount; ++i) {
            adapter.generate(worldIn, random, biomeIn, decorator, chunkPos, type);
        }
        return vanillaAmount >= 0 ? Event.Result.DENY : null;
    }

    @ParametersAreNonnullByDefault
    public static int decorate(WorldServer worldIn, Random random, BlockPos chunkPos, DecorationType type, int amount) {
        try {
            return RCBiomeDecorator.doDecorate(worldIn, random, chunkPos, type, amount, false);
        }
        catch (Exception e) {
            RecurrentComplex.logger.error("Exception when decorating", (Throwable)e);
            return amount;
        }
    }

    protected static int doDecorate(WorldServer worldIn, Random random, BlockPos blockPos, DecorationType type, int amount, boolean lowChance) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        double baseWeight = RCConfig.baseDecorationWeights.get((Object)type);
        if (baseWeight <= 0.0) {
            return amount;
        }
        Biome biomeIn = worldIn.func_180494_b(chunkPos.func_180331_a(16, 0, 16));
        StructureSelector<VanillaDecorationGeneration, DecorationType> selector = StructureRegistry.INSTANCE.decorationSelectors().get(biomeIn, worldIn.field_73011_w);
        double totalWeight = selector.totalWeight(type);
        if (totalWeight <= 0.0) {
            return amount;
        }
        return RCBiomeDecorator.trySurface(worldIn, random, chunkPos, selector, type, totalWeight, baseWeight, amount, lowChance);
    }

    public static Adapter adapter(WorldServer worldIn, BlockPos chunkPos, DecorationType type, Biome biomeIn, BiomeDecorator decorator) {
        return adapters.stream().filter(a -> a.matches(worldIn, biomeIn, decorator, chunkPos, type)).findFirst().orElse(vanillaAdapter);
    }

    public static int trySurface(WorldServer worldIn, Random random, ChunkPos chunkPos, StructureSelector<VanillaDecorationGeneration, DecorationType> selector, DecorationType type, double totalWeight, double baseWeight, int vanillaAmount, boolean mayGiveUp) {
        int rcAmount = RCBiomeDecorator.amount(random, totalWeight * baseWeight, vanillaAmount);
        if (rcAmount <= 0 && mayGiveUp) {
            return -1;
        }
        for (int i = 0; i < rcAmount; ++i) {
            for (int t = 0; t < 5 && !RCBiomeDecorator.generateSurface(selector.selectOne(random, type, totalWeight), worldIn, chunkPos, random); ++t) {
            }
        }
        return vanillaAmount - rcAmount;
    }

    public static boolean generateSurface(Pair<Structure<?>, VanillaDecorationGeneration> generation, WorldServer worldIn, ChunkPos chunkPos, Random random) {
        long seed = random.nextLong();
        BlockPos shift = ((VanillaDecorationGeneration)generation.getRight()).spawnShift;
        return new StructureGenerator((Structure)generation.getLeft()).generationInfo((GenerationType)generation.getRight()).world(worldIn).seed(seed).maturity(StructureSpawnContext.GenerateMaturity.SUGGEST).memorize(RCConfig.memorizeDecoration).allowOverlaps(true).randomPosition(WorldGenStructures.randomSurfacePos(chunkPos, seed).add(shift.func_177958_n(), shift.func_177952_p()), RCBiomeDecorator.shift(((VanillaDecorationGeneration)generation.getRight()).placer(), shift.func_177956_o() + 1)).fromCenter(true).generate() != null;
    }

    protected static Placer shift(Placer placer, int y) {
        return (context, blockCollection) -> placer.place(context, blockCollection) + y;
    }

    protected static int amount(Random random, double totalWeight, int picks) {
        int amount = 0;
        for (int i = 0; i < picks; ++i) {
            if (!(random.nextDouble() * (totalWeight + 1.0) > 1.0)) continue;
            ++amount;
        }
        return amount;
    }

    static interface Adapter {
        public boolean matches(WorldServer var1, Biome var2, BiomeDecorator var3, BlockPos var4, DecorationType var5);

        public int amount(WorldServer var1, Random var2, Biome var3, BiomeDecorator var4, BlockPos var5, DecorationType var6);

        public boolean mayGiveUp(WorldServer var1, Random var2, Biome var3, BiomeDecorator var4, BlockPos var5, DecorationType var6);

        public void generate(WorldServer var1, Random var2, Biome var3, BiomeDecorator var4, BlockPos var5, DecorationType var6);
    }

    public static enum DecorationType {
        BIG_SHROOM,
        CACTUS,
        TREE,
        DESERT_WELL,
        FOSSIL;


        public static DecorationType byID(String id) {
            return (DecorationType)IvGsonHelper.enumForName((String)id, (Enum[])DecorationType.values());
        }

        public String id() {
            return IvGsonHelper.serializedName(this);
        }
    }
}

