/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.expression;

import com.google.common.collect.Lists;
import ivorius.ivtoolkit.tools.IvGsonHelper;
import ivorius.reccomplex.utils.accessor.RCAccessorBiomeDictionary;
import ivorius.reccomplex.utils.algebra.BoolFunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.FunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.RCBoolAlgebra;
import ivorius.reccomplex.utils.algebra.SupplierCache;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeExpression
extends BoolFunctionExpressionCache<Biome, Object> {
    public static final String BIOME_NAME_PREFIX = "name=";
    public static final String BIOME_ID_PREFIX = "id=";
    public static final String BIOME_TYPE_PREFIX = "type=";

    public BiomeExpression() {
        super(RCBoolAlgebra.algebra(), true, TextFormatting.GREEN + "Any Biome");
        this.addTypes(new BiomeNameVariableType(BIOME_NAME_PREFIX, ""), new Function[0]);
        this.addTypes(new BiomeIDVariableType(BIOME_ID_PREFIX, ""), t -> t.alias("", ""));
        this.addTypes(new BiomeDictVariableType(BIOME_TYPE_PREFIX, ""), t -> t.alias("$", ""));
    }

    public static String ofTypes(BiomeDictionary.Type ... biomeTypes) {
        return BIOME_TYPE_PREFIX + String.join((CharSequence)" & type=", Lists.transform(Arrays.asList(biomeTypes), input -> input != null ? IvGsonHelper.serializedName((Enum)input) : null));
    }

    protected class BiomeDictVariableType
    extends FunctionExpressionCache.VariableType<Boolean, Biome, Object> {
        public BiomeDictVariableType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public Function<SupplierCache<Biome>, Boolean> parse(String var) {
            BiomeDictionary.Type type = RCAccessorBiomeDictionary.getTypeWeak(var);
            return type != null ? b -> BiomeDictionary.isBiomeOfType((Biome)((Biome)b.get()), (BiomeDictionary.Type)type) || type == BiomeDictionary.Type.WATER && (BiomeDictionary.isBiomeOfType((Biome)((Biome)b.get()), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.isBiomeOfType((Biome)((Biome)b.get()), (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) : b -> false;
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object biomes) {
            return RCAccessorBiomeDictionary.getTypeWeak(var) != null ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.UNKNOWN;
        }
    }

    protected class BiomeIDVariableType
    extends FunctionExpressionCache.VariableType<Boolean, Biome, Object> {
        public BiomeIDVariableType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public Function<SupplierCache<Biome>, Boolean> parse(String var) {
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(var));
            return b -> b.get() == biome;
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object biomes) {
            return Biome.field_185377_q.func_148741_d((Object)new ResourceLocation(var)) ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.UNKNOWN;
        }
    }

    protected class BiomeNameVariableType
    extends FunctionExpressionCache.VariableType<Boolean, Biome, Object> {
        public BiomeNameVariableType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public Function<SupplierCache<Biome>, Boolean> parse(String var) {
            List biomes = Biome.field_185377_q.func_148742_b().stream().map(arg_0 -> ((RegistryNamespaced)Biome.field_185377_q).func_82594_a(arg_0)).filter(b -> b.func_185359_l().equals(var)).collect(Collectors.toList());
            return o -> biomes.contains(o.get());
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object biomes) {
            return Biome.field_185377_q.func_148742_b().stream().map(arg_0 -> ((RegistryNamespaced)Biome.field_185377_q).func_82594_a(arg_0)).anyMatch(b -> b.func_185359_l().equals(var)) ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.UNKNOWN;
        }
    }
}

