/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import io.netty.buffer.ByteBuf;
import ivorius.reccomplex.files.loading.ResourceDirectory;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class SaveDirectoryData {
    private ResourceDirectory directory;
    private boolean deleteOther;
    private Set<String> filesInActive;
    private Set<String> filesInInactive;

    public SaveDirectoryData(ResourceDirectory directory, boolean deleteOther, Set<String> filesInActive, Set<String> filesInInactive) {
        this.directory = directory;
        this.deleteOther = deleteOther;
        this.filesInActive = filesInActive;
        this.filesInInactive = filesInInactive;
    }

    public static <T> void writeCollection(ByteBuf buf, Collection<T> collection, Consumer<T> consumer) {
        buf.writeInt(collection.size());
        collection.forEach(consumer);
    }

    public static <T> Collection<T> readCollection(ByteBuf buf, Function<ByteBuf, T> supplier) {
        return IntStream.range(0, buf.readInt()).mapToObj(i -> supplier.apply(buf)).collect(Collectors.toList());
    }

    public static SaveDirectoryData defaultData(String id, boolean active, Set<String> filesInActive, Set<String> filesInInactive) {
        ResourceDirectory directory = filesInInactive.contains(id) ? ResourceDirectory.INACTIVE : (filesInActive.contains(id) ? ResourceDirectory.ACTIVE : ResourceDirectory.custom(active));
        return new SaveDirectoryData(directory, true, filesInActive, filesInInactive);
    }

    public static SaveDirectoryData readFrom(ByteBuf buf) {
        return new SaveDirectoryData(ResourceDirectory.read(buf), buf.readBoolean(), SaveDirectoryData.readCollection(buf, ByteBufUtils::readUTF8String).stream().collect(Collectors.toSet()), SaveDirectoryData.readCollection(buf, ByteBufUtils::readUTF8String).stream().collect(Collectors.toSet()));
    }

    public void writeTo(ByteBuf buf) {
        this.directory.write(buf);
        buf.writeBoolean(this.deleteOther);
        SaveDirectoryData.writeCollection(buf, this.filesInActive, s -> ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s));
        SaveDirectoryData.writeCollection(buf, this.filesInInactive, s -> ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s));
    }

    public ResourceDirectory getDirectory() {
        return this.directory;
    }

    public void setDirectory(ResourceDirectory directory) {
        this.directory = directory;
    }

    public boolean isDeleteOther() {
        return this.deleteOther;
    }

    public void setDeleteOther(boolean deleteOther) {
        this.deleteOther = deleteOther;
    }

    public Set<String> getFilesInActive() {
        return this.filesInActive;
    }

    public void setFilesInActive(Set<String> filesInActive) {
        this.filesInActive = filesInActive;
    }

    public Set<String> getFilesInInactive() {
        return this.filesInInactive;
    }

    public void setFilesInInactive(Set<String> filesInInactive) {
        this.filesInInactive = filesInInactive;
    }

    public Result getResult() {
        return new Result(this.getDirectory(), this.isDeleteOther());
    }

    public static class Result {
        public final ResourceDirectory directory;
        public final boolean deleteOther;

        public Result(ResourceDirectory directory, boolean deleteOther) {
            this.directory = directory;
            this.deleteOther = deleteOther;
        }

        public static Result readFrom(ByteBuf buf) {
            return new Result(ResourceDirectory.read(buf), buf.readBoolean());
        }

        public void writeTo(ByteBuf buf) {
            this.directory.write(buf);
            buf.writeBoolean(this.deleteOther);
        }
    }
}

