/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.shadow.mcopts.commands.parameters;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.primitives.Doubles;
import ivorius.reccomplex.shadow.mcopts.MCOpts;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.NaP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameter;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import joptsimple.internal.Strings;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public class Parameters {
    public static final String SHORT_FLAG_PREFIX = "-";
    public static final String LONG_FLAG_PREFIX = "--";
    protected List<Pair<String, String>> raw;
    protected Set<String> flags = new HashSet<String>();
    protected ListMultimap<String, String> params = ArrayListMultimap.create();
    protected ListMultimap<String, String> rawParams = ArrayListMultimap.create();
    protected List<String> order = new ArrayList<String>();
    protected Set<String> declaredFlags = new HashSet<String>();
    protected Map<String, String> alias = new HashMap<String, String>();
    protected int until = -1;

    public static Parameters of(String[] args, Function<Parameters, Parameters> c) {
        Parameters parameters = new Parameters();
        return (c != null ? c.apply(parameters) : parameters).build(args);
    }

    public static String prefix(boolean isShort) {
        return isShort ? SHORT_FLAG_PREFIX : LONG_FLAG_PREFIX;
    }

    public static boolean hasLongPrefix(String name) {
        return name.startsWith(LONG_FLAG_PREFIX);
    }

    public static boolean hasShortPrefix(String name) {
        return name.startsWith(SHORT_FLAG_PREFIX) && Doubles.tryParse((String)name) == null;
    }

    public static String[] quoted(String[] args) {
        return (String[])Parameters.parse(args).map(Pair::getRight).toArray(String[]::new);
    }

    public static Stream<Pair<String, String>> parse(String[] args) {
        String full = Strings.join((String[])args, (String)" ");
        StringReader reader = new StringReader(full);
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, Integer.MAX_VALUE);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.quoteChar(34);
        ArrayList<String> parsed = new ArrayList<String>();
        ArrayList<String> raw = new ArrayList<String>();
        int last_tt = -1;
        int lastIndex = 0;
        try {
            while (tokenizer.nextToken() != -1) {
                int idx = Math.min(Parameters.index(reader), full.length());
                String arg = tokenizer.sval;
                String argRaw = full.substring(lastIndex, idx);
                parsed.add(arg);
                raw.add(tokenizer.ttype != 34 ? argRaw.trim() : argRaw);
                lastIndex = idx;
                last_tt = tokenizer.ttype;
            }
        }
        catch (IOException e) {
            MCOpts.logger.error("Error reading string", (Throwable)e);
        }
        reader.close();
        if (args.length > 0 && args[args.length - 1].length() == 0) {
            String lastRaw;
            String string = lastRaw = raw.size() > 0 ? (String)raw.get(raw.size() - 1) : null;
            if (last_tt != 34 || lastRaw != null && lastRaw.charAt(lastRaw.length() - 1) == '\"') {
                parsed.add("");
                raw.add("");
            }
        }
        return IntStream.range(0, parsed.size()).mapToObj(i -> Pair.of(raw.get(i), parsed.get(i)));
    }

    public static int index(StringReader reader) {
        try {
            return ReflectionHelper.findField(StringReader.class, (String[])new String[]{"next"}).getInt(reader);
        }
        catch (IllegalAccessException e) {
            MCOpts.logger.error("Error trying to get next", (Throwable)e);
            return 0;
        }
    }

    @Nonnull
    public static String trimQuotes(String arg) {
        String trimmed = arg;
        if (trimmed.startsWith("\"")) {
            trimmed = trimmed.substring(1, trimmed.length() - (trimmed.length() > 1 && trimmed.endsWith("\"") ? 1 : 0));
        }
        return trimmed;
    }

    public static Expect expect() {
        return new Expect();
    }

    public static String escape(String s) {
        return s.replaceAll("\"", Matcher.quoteReplacement("\\\""));
    }

    public Parameters build(String[] args) {
        this.raw = new ArrayList<Pair<String, String>>(Parameters.parse(args).collect(Collectors.toList()));
        this.order.add(null);
        String curName = null;
        boolean rawInterpreted = true;
        for (int p = 0; p < this.raw.size(); ++p) {
            Pair<String, String> pair = this.raw.get(p);
            String argRaw = (String)pair.getLeft();
            String arg = (String)pair.getRight();
            if (!this.interpretes() && rawInterpreted) {
                List<Pair<String, String>> rest = this.raw.subList(p, this.raw.size());
                String restString = rest.stream().map(Pair::getLeft).reduce(NaP::join).orElse("");
                rest.clear();
                Arrays.stream(restString.split(" ", -1)).map(s -> Pair.of((Object)s, (Object)s)).forEach(this.raw::add);
                rawInterpreted = false;
                --p;
                continue;
            }
            if (this.interpretes() && Parameters.hasLongPrefix(argRaw)) {
                curName = this.root(argRaw.substring(LONG_FLAG_PREFIX.length()).trim());
                this.flags.add(curName);
                if (!this.declaredFlags.contains(curName)) continue;
                curName = null;
                continue;
            }
            if (this.interpretes() && Parameters.hasShortPrefix(argRaw)) {
                List curFlags = argRaw.substring(SHORT_FLAG_PREFIX.length()).trim().chars().mapToObj(c -> String.valueOf((char)c)).collect(Collectors.toList());
                for (int i = 0; i < curFlags.size(); ++i) {
                    curName = this.root((String)curFlags.get(i));
                    this.flags.add(curName);
                    if (this.declaredFlags.contains(curName)) {
                        curName = null;
                        continue;
                    }
                    if (curFlags.size() <= i + 1) continue;
                    String rest = Strings.join(curFlags.subList(i + 1, curFlags.size()), (String)"");
                    this.order.add(curName);
                    this.params.put((Object)curName, (Object)rest);
                    this.rawParams.put((Object)curName, (Object)argRaw);
                    curName = null;
                }
                continue;
            }
            if (this.until > 0 && curName == null) {
                --this.until;
            }
            this.order.add(curName);
            this.params.put((Object)curName, (Object)arg);
            this.rawParams.put((Object)curName, (Object)argRaw);
            curName = null;
        }
        return this;
    }

    public void requireBuilt() throws IllegalStateException {
        if (this.raw == null) {
            throw new IllegalStateException();
        }
    }

    public void requireUnbuilt() throws IllegalStateException {
        if (this.raw != null) {
            throw new IllegalStateException();
        }
    }

    public Parameters alias(String parent, String ... aliases) {
        this.requireUnbuilt();
        parent = this.root(parent);
        for (String alias : aliases) {
            this.alias.put(alias, parent);
        }
        if (this.flags.removeAll(Arrays.asList(aliases))) {
            this.flags.add(parent);
        }
        return this;
    }

    public Parameters flag(String flag, String ... aliases) {
        this.requireUnbuilt();
        this.declaredFlags.add(this.root(flag));
        this.alias(flag, aliases);
        return this;
    }

    public Parameters flags(Collection<String> flags) {
        for (String flag : flags) {
            this.flag(flag, new String[0]);
        }
        return this;
    }

    public Parameters flags(String ... flags) {
        return this.flags(Arrays.asList(flags));
    }

    public Parameters until(int until) {
        this.until = until;
        return this;
    }

    public String root(String name) {
        String other;
        while ((other = this.alias.get(name)) != null) {
            name = other;
        }
        return name;
    }

    public String lastName() {
        return this.order.get(this.order.size() - 1);
    }

    public String last() {
        this.requireBuilt();
        return (String)this.raw.get(this.raw.size() - 1).getRight();
    }

    public String lastRaw() {
        this.requireBuilt();
        return (String)this.raw.get(this.raw.size() - 1).getLeft();
    }

    public String[] lastAsArray() {
        return new String[]{this.last()};
    }

    public boolean interpretes() {
        return this.until != 0;
    }

    public <T> Parameter<T> get(Function<Parameters, Parameter<T>> fun) {
        return fun.apply(this);
    }

    public Map<String, Parameter> entries() {
        this.requireBuilt();
        return this.flags.stream().collect(Collectors.toMap(k -> k, k -> new Parameter(0, (String)k, this.params.get(k), null)));
    }

    public boolean has(@Nonnull String flag) {
        this.requireBuilt();
        return this.flags.contains(this.root(flag));
    }

    public Parameter<String> get(int idx) {
        this.requireBuilt();
        return new Parameter(0, null, this.params.get(null), null).move(idx);
    }

    public Parameter<String> get(@Nonnull String name) {
        this.requireBuilt();
        name = this.root(name);
        return new Parameter<String>(this.has(name) && !this.params.containsKey((Object)name) ? -1 : 0, name, this.params.get((Object)name), null);
    }

    public List<Pair<String, String>> raw() {
        this.requireBuilt();
        return Collections.unmodifiableList(this.raw);
    }

    public Parameter<String> raw(int idx) {
        this.requireBuilt();
        return new Parameter(0, null, this.rawParams.get(null), null).move(idx);
    }

    public Parameter<String> raw(@Nonnull String name) {
        this.requireBuilt();
        name = this.root(name);
        return new Parameter<String>(this.has(name) && !this.rawParams.containsKey((Object)name) ? -1 : 0, name, this.params.get((Object)name), null);
    }
}

