/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.shadow.mcopts.commands.parameters;

import ivorius.reccomplex.shadow.mcopts.MCOpts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;

public class Parameter<T> {
    protected final int moved;
    protected final String name;
    protected final List<String> params;
    @Nonnull
    protected final Function<List<String>, T> fun;

    public Parameter(Parameter<T> other) {
        this.moved = other.moved;
        this.name = other.name;
        this.params = other.params;
        this.fun = other.fun;
    }

    public Parameter(Parameter<?> other, @Nonnull Function<List<String>, T> fun) {
        this.moved = other.moved;
        this.name = other.name;
        this.params = other.params;
        this.fun = fun;
    }

    public Parameter(int moved, String name, List<String> params, @Nullable Function<List<String>, T> fun) {
        this.moved = moved;
        this.name = name;
        this.params = params;
        this.fun = fun != null ? fun : this.initial();
    }

    public static Parameter<String> makeUp(String name, int moved, String ... params) {
        return Parameter.makeUp(name, moved, Arrays.asList(params));
    }

    public static Parameter<String> makeUp(String name, int moved, List<String> list) {
        return new Parameter<String>(moved, name, list, null);
    }

    public String name(int index) {
        if (this.name != null && index == 0) {
            return "--" + this.name;
        }
        return String.format("%s(%d)", this.name != null ? "--" + this.name + " " : "", Math.max(this.moved, 0) + index);
    }

    @Nonnull
    protected Function<List<String>, String> initial() {
        return list -> (String)this.get((List)list, 0);
    }

    public boolean isSet() {
        return this.moved >= 0;
    }

    protected <L> L get(List<L> list, int idx) throws CommandException {
        if (!this.isSet()) {
            throw ArgumentMissingException.create(this, idx);
        }
        if (list.isEmpty()) {
            throw ParameterNotFoundException.create(this, idx);
        }
        return list.get(idx);
    }

    public int count() {
        return this.params.size();
    }

    public boolean has(int size) {
        return size <= this.count();
    }

    @Nonnull
    public Function<List<String>, T> function() {
        return this.fun;
    }

    public Parameter<T> filter(Predicate<T> fun) {
        return this.filter(fun, null);
    }

    public Parameter<T> filter(Predicate<T> fun, @Nullable Function<T, CommandException> esc) {
        return new Parameter<Object>(this, s -> {
            T t = this.function().apply((List<String>)s);
            if (!fun.test(t) && esc != null) {
                throw (CommandException)esc.apply(t);
            }
            return t;
        });
    }

    public <O> Parameter<O> to(java.util.function.Function<Parameter<String>, Parameter<O>> fun) {
        return fun.apply(this);
    }

    public <O> Parameter<O> map(Function<T, O> fun) {
        return this.map(fun, null);
    }

    public <O> Parameter<O> map(Function<T, O> fun, @Nullable Function<T, CommandException> exc) {
        return new Parameter<Object>(this, s -> {
            T t = this.function().apply((List<String>)s);
            if (t == null) {
                return null;
            }
            Object o = fun.apply(t);
            if (o == null && exc != null) {
                throw (CommandException)exc.apply(t);
            }
            return o;
        });
    }

    public <O> Parameter<O> flatMap(Function<T, Parameter<O>> fun) {
        return new Parameter<Object>(this, s -> {
            T t = this.function().apply((List<String>)s);
            if (t == null) {
                return null;
            }
            Parameter po = (Parameter)fun.apply(t);
            return po.function().apply(po.params);
        });
    }

    public Parameter<T> orElse(T t) {
        return this.orElseGet(() -> t);
    }

    public Parameter<T> orElseGet(Supplier<T> supplier) {
        return new Parameter<Object>(this, s -> {
            try {
                return this.function().apply((List<String>)s);
            }
            catch (ParameterNotFoundException e) {
                return supplier.get();
            }
        });
    }

    @Nonnull
    public T require() throws CommandException {
        T t = this.function().apply(this.params);
        if (t == null) {
            throw MCOpts.translations.commandException("commands.parameters.invalid.generic", this.name(0));
        }
        return t;
    }

    public Optional<T> optional() throws CommandException {
        Object t = null;
        try {
            t = this.function().apply(this.params);
        }
        catch (ParameterNotFoundException parameterNotFoundException) {
            // empty catch block
        }
        return Optional.ofNullable(t);
    }

    public T get() {
        return this.tryGet().get();
    }

    public Optional<T> tryGet() {
        Object t = null;
        try {
            t = this.function().apply(this.params);
        }
        catch (CommandException commandException) {
            // empty catch block
        }
        return Optional.ofNullable(t);
    }

    public Parameter<T> rest(BinaryOperator<T> operator) {
        return new Parameter<Object>(this, p -> {
            Object t = this.function().apply(Collections.singletonList(this.get((List)p, 0)));
            for (int i = 1; i < p.size(); ++i) {
                t = operator.apply(t, this.function().apply(Collections.singletonList(p.get(i))));
            }
            return t;
        });
    }

    public Parameter<T> move(int idx) {
        return idx == 0 ? this : new Parameter<T>(this.isSet() ? this.moved + idx : this.moved, this.name, this.params.subList(Math.min(idx, this.params.size()), this.params.size()), this.fun);
    }

    public Parameter<T[]> varargs(IntFunction<T[]> init) {
        return this.stream().map(s -> s.toArray(init));
    }

    public Parameter<List<T>> varargsList() {
        return new Parameter<List<T>>(this, p -> {
            ArrayList<T> list = new ArrayList<T>(p.size());
            for (String param : p) {
                list.add(this.function().apply(Collections.singletonList(param)));
            }
            return list;
        });
    }

    public Parameter<Stream<T>> stream() {
        return this.varargsList().map(Collection::stream);
    }

    public static class ArgumentMissingException
    extends CommandException {
        private ArgumentMissingException(String message, Object ... objects) {
            super(message, objects);
        }

        public static ArgumentMissingException create(Parameter parameter, int index) {
            return MCOpts.translations.object(ArgumentMissingException::new, "commands.parameters.missing.argument", parameter.name(index));
        }
    }

    public static class ParameterNotFoundException
    extends CommandException {
        private ParameterNotFoundException(String message, Object ... objects) {
            super(message, objects);
        }

        public static ParameterNotFoundException create(Parameter parameter, int index) {
            return MCOpts.translations.object(ParameterNotFoundException::new, "commands.parameters.missing", parameter.name(index));
        }
    }

    public static interface Function<T, O> {
        public O apply(T var1) throws CommandException;
    }

    public static interface Supplier<T> {
        public T get() throws CommandException;
    }
}

