/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.shadow.mcopts.commands.parameters;

import ivorius.reccomplex.shadow.mcopts.MCOpts;
import ivorius.reccomplex.shadow.mcopts.accessor.AccessorBiomeDictionary;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameter;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MCP {
    public static BlockPos parseBlockPos(BlockPos blockpos, String[] args, int startIndex, boolean centerBlock) throws NumberInvalidException {
        return new BlockPos(CommandBase.func_175769_b((double)blockpos.func_177958_n(), (String)args[startIndex], (int)-30000000, (int)30000000, (boolean)centerBlock), CommandBase.func_175769_b((double)blockpos.func_177956_o(), (String)args[startIndex + 1], (int)0, (int)256, (boolean)false), CommandBase.func_175769_b((double)blockpos.func_177952_p(), (String)args[startIndex + 2], (int)-30000000, (int)30000000, (boolean)centerBlock));
    }

    public static Function<Parameter<String>, Parameter<BlockPos>> pos(Parameter<String> yp, Parameter<String> zp, BlockPos ref, boolean centerBlock) {
        return xp -> xp.orElse("~").flatMap(x -> yp.orElse("~").flatMap(y -> zp.orElse("~").map(z -> MCP.parseBlockPos(ref, new String[]{x, y, z}, 0, centerBlock))));
    }

    public static Function<Parameter<String>, Parameter<BlockPos>> pos(BlockPos ref, boolean centerBlock) {
        return p -> MCP.pos(p.move(1), p.move(2), ref, centerBlock).apply((Parameter<String>)p);
    }

    public static Function<Parameters, Parameter<BlockPos>> pos(String x, String y, String z, BlockPos ref, boolean centerBlock) {
        return p -> p.get(x).to(MCP.pos(p.get(y), p.get(z), ref, centerBlock));
    }

    public static Parameter<Biome> biome(Parameter<String> p) {
        return p.map(ResourceLocation::new).map(arg_0 -> ((RegistryNamespaced)Biome.field_185377_q).func_82594_a(arg_0), t -> MCOpts.translations.commandException("commands.parameters.biome.invalid", new Object[0]));
    }

    public static Parameter<BiomeDictionary.Type> biomeDictionaryType(Parameter<String> p) {
        return p.map(AccessorBiomeDictionary::getTypeWeak, s -> MCOpts.translations.commandException("commands.parameters.biometype.invalid", s));
    }

    public static Function<Parameter<String>, Parameter<WorldServer>> dimension(MinecraftServer server, ICommandSender sender) {
        return p -> p.filter(d -> !d.equals("~"), null).map(CommandBase::func_175755_a).map(arg_0 -> ((MinecraftServer)server).func_71218_a(arg_0), t -> MCOpts.translations.commandException("commands.parameters.dimension.invalid", new Object[0])).orElse((WorldServer)sender.func_130014_f_());
    }

    public static Function<Parameter<String>, Parameter<Block>> block(ICommandSender commandSender) {
        return p -> p.map(s -> CommandBase.func_147180_g((ICommandSender)commandSender, (String)s));
    }

    public static Function<Parameter<String>, Parameter<ICommand>> command(MinecraftServer server) {
        return p -> p.map(server.func_71187_D().func_71555_a()::get, s -> new CommandNotFoundException());
    }

    public static Function<Parameter<String>, Parameter<Entity>> entity(MinecraftServer server, ICommandSender sender) {
        return p -> p.map(s -> CommandBase.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)s));
    }

    public static Parameter<Rotation> rotation(Parameter<String> p) {
        return p.map(CommandBase::func_175755_a).map(i -> i > 40 ? i / 90 : i).map(MCP::rotationFromInt);
    }

    public static Rotation rotationFromInt(int rotation) {
        switch ((rotation % 4 + 4) % 4) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        throw new IllegalStateException();
    }
}

