/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.shadow.mcopts.accessor;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import ivorius.reccomplex.shadow.mcopts.reflection.SafeReflector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.BiomeDictionary;

public class AccessorBiomeDictionary {
    public static String serializedName(Enum anEnum) {
        String name = anEnum.name();
        try {
            SerializedName serializedName = anEnum.getClass().getField(name).getAnnotation(SerializedName.class);
            if (serializedName != null) {
                name = serializedName.value();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return name;
    }

    public static BiomeDictionary.Type getTypeWeak(String var) {
        return AccessorBiomeDictionary.getMap().get(var.toUpperCase());
    }

    public static Map<String, BiomeDictionary.Type> getMap() {
        HashMap<String, BiomeDictionary.Type> map = new HashMap<String, BiomeDictionary.Type>();
        for (BiomeDictionary.Type type : BiomeDictionary.Type.values()) {
            map.put(AccessorBiomeDictionary.serializedName((Enum)type), type);
        }
        return map;
    }

    public static void addSubtypes(BiomeDictionary.Type type, BiomeDictionary.Type ... subtypes) {
        AccessorBiomeDictionary.addSubtypes(type, Arrays.asList(subtypes));
    }

    public static void addSubtypes(BiomeDictionary.Type type, List<BiomeDictionary.Type> subtypes) {
        AccessorBiomeDictionary.setSubtypes(type, Lists.newArrayList((Iterable)Iterables.concat(AccessorBiomeDictionary.getSubtypes(type), subtypes)));
    }

    public static List<BiomeDictionary.Type> getSubtypes(BiomeDictionary.Type type) {
        return SafeReflector.get(BiomeDictionary.Type.class, "subTags", type, new ArrayList());
    }

    public static void setSubtypes(BiomeDictionary.Type type, List<BiomeDictionary.Type> types) {
        SafeReflector.of(BiomeDictionary.Type.class, "subTags", field -> field.set(type, types));
    }
}

