/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.item;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.RCGuiHandler;
import ivorius.reccomplex.item.GeneratingItem;
import ivorius.reccomplex.world.storage.loot.GenericItemCollection;
import ivorius.reccomplex.world.storage.loot.GenericItemCollectionRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ItemInventoryGenComponentTag
extends Item
implements GeneratingItem {
    public static String componentKey(ItemStack stack) {
        NBTTagCompound nbttagcompound;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("itemCollectionKey", 8)) {
            return stack.func_77978_p().func_74779_i("itemCollectionKey");
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("display", 10) && (nbttagcompound = stack.func_77978_p().func_74775_l("display")).func_150297_b("Name", 8)) {
            return nbttagcompound.func_74779_i("Name");
        }
        return null;
    }

    public static void setComponentKey(ItemStack stack, String generatorKey) {
        stack.func_77983_a("itemCollectionKey", (NBTBase)new NBTTagString(generatorKey));
    }

    public static GenericItemCollection.Component component(ItemStack stack) {
        return (GenericItemCollection.Component)((Object)GenericItemCollectionRegistry.INSTANCE.get(ItemInventoryGenComponentTag.componentKey(stack)));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K) {
            RCGuiHandler.editInventoryGenComponent(playerIn, ItemInventoryGenComponentTag.componentKey(itemStackIn), ItemInventoryGenComponentTag.component(itemStackIn), null);
        }
        return super.func_77659_a(itemStackIn, worldIn, playerIn, hand);
    }

    @Override
    public void generateInInventory(WorldServer server, IInventory inventory, Random random, ItemStack stack, int fromSlot) {
        GenericItemCollection.Component component = ItemInventoryGenComponentTag.component(stack);
        if (component != null) {
            inventory.func_70299_a(fromSlot, component.getRandomItemStack(random));
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String func_77653_i(ItemStack stack) {
        String key = ItemInventoryGenComponentTag.componentKey(stack);
        return key != null ? key : super.func_77653_i(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedInformation) {
        super.func_77624_a(stack, player, list, advancedInformation);
        GenericItemCollection.Component component = ItemInventoryGenComponentTag.component(stack);
        if (component != null) {
            list.add(component.inventoryGeneratorID);
            list.add(GenericItemCollectionRegistry.INSTANCE.hasActive(ItemInventoryGenComponentTag.componentKey(stack)) ? IvTranslations.format("inventoryGen.active", TextFormatting.GREEN, TextFormatting.RESET) : IvTranslations.format("inventoryGen.inactive", TextFormatting.RED, TextFormatting.RESET));
        } else {
            list.add(IvTranslations.get("inventoryGen.create"));
        }
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        super.func_150895_a(item, creativeTabs, list);
        for (String key : GenericItemCollectionRegistry.INSTANCE.ids()) {
            ItemStack stack = new ItemStack(item);
            ItemInventoryGenComponentTag.setComponentKey(stack, key);
            list.add(stack);
        }
    }
}

