/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.mazegenerator;

import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellBoolean;
import ivorius.reccomplex.gui.table.cell.TableCellIntegerRange;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.world.gen.feature.structure.generic.Selection;
import javax.annotation.Nonnull;
import net.minecraft.util.text.TextFormatting;

public class TableDataSourceSelectionArea
extends TableDataSourceSegmented {
    public static final String[] COORD_NAMES = new String[]{"x", "y", "z"};
    private Selection.Area area;
    private int[] dimensions;
    private boolean showIdentifier;

    public TableDataSourceSelectionArea(Selection.Area area, int[] dimensions, boolean showIdentifier) {
        this.area = area;
        this.dimensions = dimensions;
        this.showIdentifier = showIdentifier;
    }

    @Override
    @Nonnull
    public String title() {
        return "Area";
    }

    @Override
    public int numberOfSegments() {
        return this.showIdentifier ? 3 : 2;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 0: {
                return 1;
            }
            case 1: {
                return COORD_NAMES.length;
            }
            case 2: {
                return 1;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            TableCellBoolean cell = new TableCellBoolean("additive", this.area.isAdditive(), TextFormatting.GREEN + IvTranslations.get("reccomplex.selection.area.additive"), TextFormatting.GOLD + IvTranslations.get("reccomplex.selection.area.subtractive"));
            cell.addPropertyConsumer(this.area::setAdditive);
            return new TitledCell(cell);
        }
        if (segment == 1) {
            String title = IvTranslations.get("reccomplex.selection.area.range." + COORD_NAMES[index]);
            IntegerRange intRange = new IntegerRange(this.area.getMinCoord()[index], this.area.getMaxCoord()[index]);
            TableCellIntegerRange cell = new TableCellIntegerRange("area" + index, intRange, 0, this.dimensions[index] - 1);
            cell.addPropertyConsumer(val -> this.area.setCoord(index, val.getMin(), val.getMax()));
            return new TitledCell(title, cell).withTitleTooltip(IvTranslations.getLines("reccomplex.selection.area.range." + COORD_NAMES[index] + ".tooltip"));
        }
        if (segment == 2) {
            TableCellString cell = new TableCellString("", this.area.getIdentifier() != null ? this.area.getIdentifier() : "");
            cell.addPropertyConsumer(this.area::setIdentifier);
            return new TitledCell(IvTranslations.get("reccomplex.selection.area.identifier"), cell);
        }
        return super.cellForIndexInSegment(table, index, segment);
    }
}

