/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.mazegenerator;

import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceList;
import ivorius.reccomplex.gui.worldscripts.mazegenerator.TableDataSourceSelectionArea;
import ivorius.reccomplex.world.gen.feature.structure.generic.Selection;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.util.text.TextFormatting;

public class TableDataSourceSelection
extends TableDataSourceList<Selection.Area, Selection> {
    private int[] dimensions;
    public boolean showIdentifier;

    public TableDataSourceSelection(Selection list, int[] dimensions, TableDelegate tableDelegate, TableNavigator navigator, boolean showIdentifier) {
        super(list, tableDelegate, navigator);
        this.dimensions = dimensions;
        this.showIdentifier = showIdentifier;
        this.duplicateTitle = TextFormatting.GREEN + "D";
    }

    @Override
    public String getDisplayString(Selection.Area area) {
        TextFormatting color = area.isAdditive() ? TextFormatting.GREEN : TextFormatting.RED;
        return String.format("%s%s%s - %s%s", color, Arrays.toString(area.getMinCoord()), TextFormatting.RESET, color, Arrays.toString(area.getMaxCoord()));
    }

    @Override
    public Selection.Area newEntry(String actionID) {
        return new Selection.Area(true, new int[this.dimensions.length], new int[this.dimensions.length], this.showIdentifier ? "" : null);
    }

    @Override
    public Selection.Area copyEntry(Selection.Area area) {
        return area.copy();
    }

    @Override
    @Nonnull
    public TableCell entryCell(boolean enabled, Selection.Area area) {
        return TableCells.edit(enabled, this.navigator, this.tableDelegate, () -> new TableDataSourceSelectionArea(area, this.dimensions, this.showIdentifier));
    }

    @Override
    @Nonnull
    public String title() {
        return "Area List";
    }
}

