/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.worldscripts.mazegenerator;

import com.google.common.collect.ImmutableList;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellInteger;
import ivorius.reccomplex.gui.table.cell.TableCellStringInt;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class TableDataSourceMazeRoom
extends TableDataSourceSegmented {
    public MazeRoom room;
    private Consumer<MazeRoom> consumer;
    private final List<IntegerRange> ranges;
    private final List<String> titles;
    private final List<List<String>> tooltips;

    public TableDataSourceMazeRoom(MazeRoom room, Consumer<MazeRoom> consumer, List<IntegerRange> ranges, List<String> titles, List<List<String>> tooltips) {
        if (ranges.size() != titles.size() || ranges.size() != room.getDimensions()) {
            throw new IllegalArgumentException(String.format("ranges: %d, titles: %d, dimensions: %d", ranges.size(), titles.size(), room.getDimensions()));
        }
        this.room = room;
        this.consumer = consumer;
        this.ranges = ImmutableList.copyOf(ranges);
        this.titles = ImmutableList.copyOf(titles);
        this.tooltips = ImmutableList.copyOf(tooltips);
    }

    @Override
    @Nonnull
    public String title() {
        return "Room";
    }

    @Override
    public int numberOfSegments() {
        return 1;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return this.room.getDimensions();
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        IntegerRange range = this.ranges.get(index);
        int val = this.room.getCoordinate(index);
        String title = this.titles.get(index);
        List<String> tooltip = this.tooltips.get(index);
        if (range != null) {
            TableCellInteger cell = new TableCellInteger(null, val, range.min, range.max);
            cell.addPropertyConsumer(this.createConsumer(index));
            return new TitledCell(title, cell).withTitleTooltip(tooltip);
        }
        TableCellStringInt cell = new TableCellStringInt(null, val);
        cell.addPropertyConsumer(this.createConsumer(index));
        return new TitledCell(title, cell).withTitleTooltip(tooltip);
    }

    @Nonnull
    protected Consumer<Integer> createConsumer(int idx) {
        return val -> {
            this.room = this.setInDimension(this.room, idx, (int)val);
            this.consumer.accept(this.room);
        };
    }

    private MazeRoom setInDimension(MazeRoom room, int dimension, int value) {
        return this.room.addInDimension(dimension, value - room.getCoordinate(dimension));
    }
}

