/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table.cell;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCells;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellDefault;
import ivorius.reccomplex.gui.table.cell.TableCellMulti;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSource;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSupplied;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class TableCellMultiBuilder {
    protected final List<Supplier<TableCellButton>> cells = new ArrayList<Supplier<TableCellButton>>();
    protected final List<BooleanSupplier> enabledSuppliers = new ArrayList<BooleanSupplier>();
    public TableNavigator navigator;
    public TableDelegate delegate;

    private TableCellMultiBuilder(TableNavigator navigator, TableDelegate delegate) {
        this.navigator = navigator;
        this.delegate = delegate;
    }

    public static TableCellMultiBuilder create(TableNavigator navigator, TableDelegate delegate) {
        return new TableCellMultiBuilder(navigator, delegate);
    }

    @Nonnull
    private static TableCellButton defaultCell(Object title, Supplier<List<String>> tooltip, Runnable action) {
        TableCellButton cell = new TableCellButton(null, null, "");
        TableCellMultiBuilder.setVisuals(title, tooltip, cell);
        cell.addAction(action);
        return cell;
    }

    private static void setVisuals(Object title, Supplier<List<String>> tooltip, TableCellButton cell) {
        cell.title = "";
        cell.setTexture(null);
        if (title instanceof ResourceLocation) {
            cell.setTexture((ResourceLocation)title);
        } else if (title instanceof String) {
            cell.title = (String)title;
        }
        cell.setTooltip(tooltip != null ? tooltip.get() : null);
    }

    @Nonnull
    public TableCellMultiBuilder addCell(Supplier<TableCellButton> cell) {
        this.cells.add(cell);
        this.enabledSuppliers.add(null);
        return this;
    }

    public TableCellMultiBuilder addAction(Runnable action, Supplier<Object> title, @Nullable Supplier<List<String>> tooltip) {
        return this.addCell(() -> TableCellMultiBuilder.defaultCell(title.get(), tooltip, () -> {
            action.run();
            this.delegate.reloadData();
        }));
    }

    public TableCellMultiBuilder addSimpleNavigation(Supplier<TableDataSource> dataSource, Supplier<Object> title, @Nullable Supplier<List<String>> tooltip) {
        return this.addCell(() -> TableCellMultiBuilder.defaultCell(title.get(), tooltip, () -> this.lambda$null$580((Supplier)dataSource)));
    }

    public TableCellMultiBuilder addNavigation(Supplier<TableDataSource> dataSource, Supplier<Object> title, @Nullable Supplier<List<String>> tooltip) {
        return this.addCell(() -> {
            TableCellButton edit = TableCells.edit(true, this.navigator, this.delegate, dataSource);
            TableCellMultiBuilder.setVisuals(title.get(), tooltip, edit);
            return edit;
        });
    }

    public TableCellMultiBuilder addNavigation(Supplier<TableDataSource> dataSource, Supplier<Object> title) {
        return this.addNavigation(dataSource, title, null);
    }

    public TableCellMultiBuilder addNavigation(Supplier<TableDataSource> dataSource) {
        return this.addNavigation(dataSource, () -> IvTranslations.get("reccomplex.gui.edit"));
    }

    public TableCellMultiBuilder enabled(BooleanSupplier enabled) {
        this.enabledSuppliers.remove(this.enabledSuppliers.size() - 1);
        this.enabledSuppliers.add(enabled);
        return this;
    }

    @Nonnull
    public TableDataSource buildDataSource(@Nullable String title) {
        return new TableDataSourceSupplied(() -> this.buildTitled(title));
    }

    @Nonnull
    public TableDataSource buildDataSource(@Nullable String title, List<String> tooltip) {
        return new TableDataSourceSupplied(() -> this.buildTitled(title).withTitleTooltip(tooltip));
    }

    @Nonnull
    public TableDataSource buildDataSource() {
        return new TableDataSourceSupplied(this::buildTitled);
    }

    @Nonnull
    public TitledCell buildTitled(@Nullable String title) {
        return new TitledCell(title, this.build());
    }

    @Nonnull
    public TitledCell buildTitled() {
        return new TitledCell(this.build());
    }

    @Nonnull
    public TableCellDefault build() {
        ArrayList<TableCellButton> cells = new ArrayList<TableCellButton>();
        for (int i = 0; i < this.cells.size(); ++i) {
            TableCellButton cell = this.cells.get(i).get();
            cell.setId("action." + i);
            cell.actionID = "action." + i;
            BooleanSupplier enabled = this.enabledSuppliers.get(i);
            if (enabled != null) {
                cell.setEnabled(enabled.getAsBoolean());
            }
            cells.add(cell);
        }
        return new TableCellMulti(cells);
    }

    private /* synthetic */ void lambda$null$580(Supplier dataSource) {
        this.navigator.pushTable(new GuiTable(this.delegate, (TableDataSource)dataSource.get()));
    }
}

