/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table.cell;

import ivorius.ivtoolkit.gui.GuiControlListener;
import ivorius.ivtoolkit.gui.GuiSlider;
import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.cell.TableCellPropertyDefault;
import net.minecraft.util.math.MathHelper;

public class TableCellInteger
extends TableCellPropertyDefault<Integer>
implements GuiControlListener<GuiSlider> {
    private GuiSlider slider;
    private boolean enabled = true;
    private int min;
    private int max;

    public TableCellInteger(String id, int value, int min, int max) {
        super(id, value);
        this.min = min;
        this.max = max;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.slider != null) {
            this.slider.field_146124_l = enabled;
        }
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        if (this.slider == null) {
            this.slider = new GuiSlider(-1, 0, 0, 0, 0, String.valueOf(this.property));
            this.slider.addListener(this);
        }
        this.updateSliderBounds(bounds);
        this.slider.setMinValue(this.min);
        this.slider.setMaxValue(this.max);
        this.slider.field_146124_l = this.enabled;
        this.slider.setValue(((Integer)this.property).intValue());
        this.slider.field_146125_m = !this.isHidden();
        screen.addButton(this, 0, this.slider);
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.slider != null) {
            this.slider.field_146125_m = !hidden;
        }
    }

    @Override
    public void valueChanged(GuiSlider gui) {
        this.property = MathHelper.func_76141_d((float)(gui.getValue() + 0.5f));
        gui.setValue(((Integer)this.property).intValue());
        gui.field_146126_j = String.valueOf(this.property);
        this.alertListenersOfChange();
    }

    protected void updateSliderBounds(Bounds bounds) {
        Bounds.set(this.slider, Bounds.fromSize(bounds.getMinX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, bounds.getWidth(), 20));
    }

    @Override
    public void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.slider != null) {
            this.updateSliderBounds(bounds);
        }
    }

    @Override
    public void setPropertyValue(Integer value) {
        super.setPropertyValue(value);
        if (this.slider != null) {
            this.slider.setValue(value.intValue());
            this.slider.field_146126_j = String.valueOf(this.property);
        }
    }
}

