/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table.cell;

import ivorius.reccomplex.gui.GuiTexturedButton;
import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.cell.TableCellActionListener;
import ivorius.reccomplex.gui.table.cell.TableCellDefault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class TableCellButton
extends TableCellDefault {
    protected GuiTexturedButton button = null;
    public String actionID;
    public String title;
    public List<String> tooltip;
    public boolean enabled = true;
    public ResourceLocation texture;
    private List<TableCellActionListener> listeners = new ArrayList<TableCellActionListener>();

    public TableCellButton(String id, String actionID, String title, List<String> tooltip, boolean enabled) {
        super(id);
        this.actionID = actionID;
        this.title = title;
        this.tooltip = tooltip;
        this.enabled = enabled;
    }

    public TableCellButton(String id, String actionID, String title, List<String> tooltip) {
        super(id);
        this.actionID = actionID;
        this.title = title;
        this.tooltip = tooltip;
    }

    public TableCellButton(String id, String actionID, String title, boolean enabled) {
        super(id);
        this.actionID = actionID;
        this.title = title;
        this.enabled = enabled;
    }

    public TableCellButton(String id, String actionID, String title) {
        super(id);
        this.actionID = actionID;
        this.title = title;
    }

    public void addListener(TableCellActionListener listener) {
        this.listeners.add(listener);
    }

    public TableCellActionListener addAction(Runnable runnable) {
        TableCellActionListener listener = (cell, action) -> runnable.run();
        this.listeners.add(listener);
        return listener;
    }

    public void removeListener(TableCellActionListener listener) {
        this.listeners.remove(listener);
    }

    public List<TableCellActionListener> listeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.button != null) {
            this.button.field_146124_l = enabled;
        }
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void setTexture(ResourceLocation texture) {
        this.texture = texture;
        if (this.button != null) {
            this.button.setTexture(texture);
        }
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        Bounds bounds = this.bounds();
        this.button = new GuiTexturedButton(-1, bounds.getMinX(), bounds.getMinY() + (bounds.getHeight() - 20) / 2, bounds.getWidth(), 20, this.title);
        this.button.setTexture(this.texture);
        this.button.field_146125_m = !this.isHidden();
        this.button.field_146124_l = this.enabled;
        screen.addButton(this, 0, this.button);
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        if (this.button != null) {
            this.button.field_146125_m = !hidden;
        }
    }

    @Override
    public void buttonClicked(int buttonID) {
        super.buttonClicked(buttonID);
        for (TableCellActionListener listener : this.listeners) {
            listener.actionPerformed(this, this.actionID);
        }
    }

    @Override
    public void drawFloating(GuiTable screen, int mouseX, int mouseY, float partialTicks) {
        super.drawFloating(screen, mouseX, mouseY, partialTicks);
        if (this.tooltip != null && this.button != null) {
            screen.drawTooltipRect(this.tooltip, Bounds.fromButton(this.button), mouseX, mouseY, this.getFontRenderer());
        }
    }
}

