/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.nbt;

import ivorius.reccomplex.gui.nbt.TableDataSourceNBT;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellMulti;
import ivorius.reccomplex.gui.table.cell.TableCellPresetAction;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.world.gen.feature.structure.generic.WeightedBlockState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public class TableDataSourceNBTTagCompound
extends TableDataSourceSegmented {
    protected TableDelegate delegate;
    protected TableNavigator navigator;
    protected NBTTagCompound nbt;
    protected final List<String> sortedKeys = new ArrayList<String>();

    public TableDataSourceNBTTagCompound(TableDelegate delegate, TableNavigator navigator, NBTTagCompound nbt) {
        this.delegate = delegate;
        this.navigator = navigator;
        this.nbt = nbt;
        this.resetSortedKeys();
    }

    protected void resetSortedKeys() {
        this.sortedKeys.clear();
        this.sortedKeys.addAll(this.nbt.func_150296_c());
        this.sortedKeys.sort(String::compareToIgnoreCase);
    }

    public NBTTagCompound getNbt() {
        return this.nbt;
    }

    public void setNbt(NBTTagCompound nbt) {
        this.nbt = nbt;
    }

    @Override
    @Nonnull
    public String title() {
        return "NBT Compound";
    }

    @Override
    public int numberOfSegments() {
        return 4;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 2 ? this.nbt.func_150296_c().size() : 1;
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            TableCellButton load = new TableCellButton(null, "toString", "->", Collections.singletonList("Convert to String (slightly lossy)"), true);
            TableCellButton perform = new TableCellButton(null, "fromString", "O", Collections.singletonList("Load from String"), false);
            TableCellString cell = new TableCellString("tileEntityInfo", "");
            cell.addPropertyConsumer(val -> perform.setEnabled(WeightedBlockState.tryParse(val) != null));
            cell.setMaxStringLength(32500);
            load.addAction(() -> {
                cell.setPropertyValue(this.nbt.toString());
                perform.setEnabled(true);
            });
            perform.addAction(() -> {
                NBTTagCompound other = WeightedBlockState.tryParse((String)cell.getPropertyValue());
                if (other != null) {
                    this.nbt.func_150296_c().clear();
                    other.func_150296_c().forEach(s -> this.nbt.func_74782_a(s, other.func_74781_a(s)));
                    this.resetSortedKeys();
                    this.delegate.reloadData();
                }
            });
            TableCellMulti multi = new TableCellMulti(load, cell, perform);
            multi.setSize(0, 0.1f);
            multi.setSize(2, 0.1f);
            return new TitledCell("As String", multi);
        }
        if (segment == 1 || segment == 3) {
            return new TableCellPresetAction(null, IntStream.range(0, 12).mapToObj(id -> TableDataSourceNBT.addButton(id, n -> {
                this.nbt.func_74782_a("", n);
                this.sortedKeys.removeIf(s -> s.equals(""));
                this.sortedKeys.add(segment == 1 ? 0 : this.sortedKeys.size(), "");
                this.delegate.reloadData();
            })).collect(Collectors.toList()));
        }
        String key = this.sortedKeys.get(index);
        String[] nextKey = new String[]{key};
        NBTBase cellNBT = this.nbt.func_74781_a(key);
        TableCell nbtCell = TableDataSourceNBT.cell(cellNBT, this.delegate, this.navigator);
        TableCellString keyCell = new TableCellString(null, key);
        TableCellButton setKeyCell = new TableCellButton(null, "setKey", "O", Collections.singletonList("Set Key"), false);
        setKeyCell.addAction(() -> {
            this.sortedKeys.set(index, nextKey[0]);
            this.sortedKeys.subList(index + 1, this.sortedKeys.size()).remove(nextKey[0]);
            this.sortedKeys.subList(0, index).remove(nextKey[0]);
            this.nbt.func_82580_o(key);
            this.nbt.func_74782_a(nextKey[0], cellNBT);
            this.delegate.reloadData();
        });
        keyCell.addPropertyConsumer(value -> {
            nextKey[0] = value;
            setKeyCell.setEnabled(true);
        });
        TableCellButton deleteCell = new TableCellButton(null, null, TextFormatting.RED + "-");
        deleteCell.addAction(() -> {
            this.sortedKeys.remove(key);
            this.nbt.func_82580_o(key);
            this.delegate.reloadData();
        });
        TableCellMulti multi = new TableCellMulti(keyCell, setKeyCell, nbtCell, deleteCell);
        multi.setSize(1, 0.2f);
        multi.setSize(3, 0.2f);
        return multi;
    }
}

