/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.transformers;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.GuiValidityStateIndicator;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellMulti;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.world.gen.feature.structure.Structures;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.Transformer;
import javax.annotation.Nonnull;

public class TableDataSourceTransformer
extends TableDataSourceSegmented {
    public Transformer transformer;
    public TableDelegate delegate;

    public TableDataSourceTransformer(Transformer transformer, TableDelegate delegate, TableNavigator navigator) {
        this.transformer = transformer;
        this.delegate = delegate;
    }

    @Override
    public int numberOfSegments() {
        return 1;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 0 ? 1 : super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            TableCellString idCell = new TableCellString("transformerID", this.transformer.id());
            idCell.setShowsValidityState(true);
            idCell.setValidityState(this.currentIDState());
            idCell.addPropertyConsumer(val -> {
                this.transformer.setID((String)val);
                idCell.setValidityState(this.currentIDState());
            });
            TableCellButton randomizeCell = new TableCellButton(null, null, IvTranslations.get("reccomplex.gui.randomize.short"), IvTranslations.getLines("reccomplex.gui.randomize"));
            randomizeCell.addAction(() -> {
                this.transformer.setID(Transformer.randomID(this.transformer.getClass()));
                this.delegate.reloadData();
            });
            TableCellMulti cell = new TableCellMulti(idCell, randomizeCell);
            cell.setSize(1, 0.1f);
            return new TitledCell(IvTranslations.get("reccomplex.transformer.id"), cell).withTitleTooltip(IvTranslations.formatLines("reccomplex.transformer.id.tooltip", new Object[0]));
        }
        return super.cellForIndexInSegment(table, index, segment);
    }

    protected GuiValidityStateIndicator.State currentIDState() {
        return Structures.isSimpleIDState(this.transformer.id());
    }

    @Override
    @Nonnull
    public String title() {
        return this.transformer.getDisplayString();
    }
}

