/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.transformers;

import ivorius.ivtoolkit.gui.FloatRange;
import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.TableDirections;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceTransformer;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellBoolean;
import ivorius.reccomplex.gui.table.cell.TableCellEnum;
import ivorius.reccomplex.gui.table.cell.TableCellFloat;
import ivorius.reccomplex.gui.table.cell.TableCellFloatRange;
import ivorius.reccomplex.gui.table.cell.TableCellTitle;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.utils.scale.Scales;
import ivorius.reccomplex.world.gen.feature.structure.generic.transformers.TransformerRuins;
import net.minecraft.util.EnumFacing;

public class TableDataSourceBTRuins
extends TableDataSourceSegmented {
    private TransformerRuins transformer;

    public TableDataSourceBTRuins(TransformerRuins transformer, TableNavigator navigator, TableDelegate delegate) {
        this.transformer = transformer;
        this.addManagedSegment(0, new TableDataSourceTransformer(transformer, delegate, navigator));
    }

    public TransformerRuins getTransformer() {
        return this.transformer;
    }

    public void setTransformer(TransformerRuins transformer) {
        this.transformer = transformer;
    }

    @Override
    public int numberOfSegments() {
        return 3;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 1: {
                return 5;
            }
            case 2: {
                return 5;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 1: {
                switch (index) {
                    case 0: {
                        return new TitledCell(new TableCellTitle("decayTitle", IvTranslations.get("reccomplex.transformer.ruins.decay.title")));
                    }
                    case 1: {
                        TableCellFloatRange cell = new TableCellFloatRange("decay", new FloatRange(this.transformer.minDecay, this.transformer.maxDecay), 0.0f, 1.0f, "%.4f");
                        cell.setScale(Scales.pow(5.0f));
                        cell.addPropertyConsumer(val -> {
                            this.transformer.minDecay = val.getMin();
                            this.transformer.maxDecay = val.getMax();
                        });
                        return new TitledCell(IvTranslations.get("reccomplex.transformer.ruins.decay.base"), cell).withTitleTooltip(IvTranslations.formatLines("reccomplex.transformer.ruins.decay.base.tooltip", new Object[0]));
                    }
                    case 2: {
                        TableCellFloat cell = new TableCellFloat("decayChaos", this.transformer.decayChaos, 0.0f, 1.0f);
                        cell.setScale(Scales.pow(3.0f));
                        cell.addPropertyConsumer(val -> {
                            this.transformer.decayChaos = val.floatValue();
                        });
                        return new TitledCell(IvTranslations.get("reccomplex.transformer.ruins.decay.chaos"), cell).withTitleTooltip(IvTranslations.formatLines("reccomplex.transformer.ruins.decay.chaos.tooltip", new Object[0]));
                    }
                    case 3: {
                        TableCellFloat cell = new TableCellFloat("decayValueDensity", this.transformer.decayValueDensity, 0.0f, 1.0f);
                        cell.setScale(Scales.pow(3.0f));
                        cell.addPropertyConsumer(val -> {
                            this.transformer.decayValueDensity = val.floatValue();
                        });
                        return new TitledCell(IvTranslations.get("reccomplex.transformer.ruins.decay.density"), cell).withTitleTooltip(IvTranslations.formatLines("reccomplex.transformer.ruins.decay.density.tooltip", new Object[0]));
                    }
                    case 4: {
                        TableCellEnum<EnumFacing> cell = new TableCellEnum<EnumFacing>("decaySide", this.transformer.decayDirection, TableDirections.getDirectionOptions(EnumFacing.field_82609_l));
                        cell.addPropertyConsumer(val -> {
                            this.transformer.decayDirection = val;
                        });
                        return new TitledCell(IvTranslations.get("reccomplex.transformer.ruins.decay.direction"), cell).withTitleTooltip(IvTranslations.formatLines("reccomplex.transformer.ruins.decay.direction.tooltip", new Object[0]));
                    }
                }
                break;
            }
            case 2: {
                switch (index) {
                    case 0: {
                        return new TitledCell(new TableCellTitle("otherTitle", IvTranslations.get("reccomplex.transformer.ruins.other.title")));
                    }
                    case 1: {
                        TableCellFloat cell = new TableCellFloat("erosion", this.transformer.blockErosion, 0.0f, 1.0f);
                        cell.setScale(Scales.pow(3.0f));
                        cell.addPropertyConsumer(val -> {
                            this.transformer.blockErosion = val.floatValue();
                        });
                        return new TitledCell(IvTranslations.get("reccomplex.transformer.ruins.erosion"), cell).withTitleTooltip(IvTranslations.formatLines("reccomplex.transformer.ruins.erosion.tooltip", new Object[0]));
                    }
                    case 2: {
                        TableCellFloat cell = new TableCellFloat("vines", this.transformer.vineGrowth, 0.0f, 1.0f);
                        cell.setScale(Scales.pow(3.0f));
                        cell.addPropertyConsumer(val -> {
                            this.transformer.vineGrowth = val.floatValue();
                        });
                        return new TitledCell(IvTranslations.get("reccomplex.transformer.ruins.vines"), cell).withTitleTooltip(IvTranslations.formatLines("reccomplex.transformer.ruins.vines.tooltip", new Object[0]));
                    }
                    case 3: {
                        TableCellFloat cell = new TableCellFloat("cobwebs", this.transformer.cobwebGrowth, 0.0f, 1.0f);
                        cell.setScale(Scales.pow(3.0f));
                        cell.addPropertyConsumer(val -> {
                            this.transformer.cobwebGrowth = val.floatValue();
                        });
                        return new TitledCell(IvTranslations.get("reccomplex.transformer.ruins.cobwebs"), cell).withTitleTooltip(IvTranslations.formatLines("reccomplex.transformer.ruins.cobwebs.tooltip", new Object[0]));
                    }
                    case 4: {
                        TableCellBoolean cell = new TableCellBoolean("gravity", this.transformer.gravity);
                        cell.addPropertyConsumer(val -> {
                            this.transformer.gravity = val;
                        });
                        return new TitledCell(IvTranslations.get("reccomplex.transformer.ruins.gravity"), cell).withTitleTooltip(IvTranslations.formatLines("reccomplex.transformer.ruins.gravity.tooltip", new Object[0]));
                    }
                }
            }
        }
        return super.cellForIndexInSegment(table, index, segment);
    }
}

