/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.pattern;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.TableDataSourceExpression;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellBoolean;
import ivorius.reccomplex.gui.table.cell.TableCellString;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.world.gen.feature.structure.generic.BlockPattern;
import javax.annotation.Nonnull;

public class TableDataSourceBlockPatternIngredient
extends TableDataSourceSegmented {
    private BlockPattern.Ingredient ingredient;
    private TableDelegate tableDelegate;

    public TableDataSourceBlockPatternIngredient(BlockPattern.Ingredient ingredient, TableDelegate tableDelegate) {
        this.ingredient = ingredient;
        this.tableDelegate = tableDelegate;
        this.addManagedSegment(1, TableDataSourceExpression.constructDefault(IvTranslations.get("reccomplex.gui.blocks"), ingredient.matcher, null));
    }

    @Override
    @Nonnull
    public String title() {
        return "Ingredient";
    }

    @Override
    public int numberOfSegments() {
        return 3;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 0 || segment == 2 ? 1 : super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 0) {
            TableCellString cell = new TableCellString("", this.ingredient.identifier);
            cell.addPropertyConsumer(s -> {
                this.ingredient.identifier = s;
            });
            return new TitledCell(IvTranslations.get("reccomplex.blockpattern.ingredient.identifier"), cell);
        }
        if (segment == 2) {
            TableCellBoolean cell = new TableCellBoolean("", this.ingredient.delete);
            cell.addPropertyConsumer(d -> {
                this.ingredient.delete = d;
            });
            return new TitledCell(IvTranslations.get("reccomplex.blockpattern.ingredient.delete"), cell);
        }
        return super.cellForIndexInSegment(table, index, segment);
    }
}

