/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.gentypes.staticgen;

import ivorius.ivtoolkit.tools.IvTranslations;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.cell.TableCell;
import ivorius.reccomplex.gui.table.cell.TableCellInteger;
import ivorius.reccomplex.gui.table.cell.TableCellStringInt;
import ivorius.reccomplex.gui.table.cell.TitledCell;
import ivorius.reccomplex.gui.table.datasource.TableDataSourceSegmented;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.StaticGeneration;
import javax.annotation.Nonnull;

public class TableDataSourceStaticPattern
extends TableDataSourceSegmented {
    private StaticGeneration.Pattern pattern;
    private TableDelegate tableDelegate;

    public TableDataSourceStaticPattern(StaticGeneration.Pattern pattern, TableDelegate tableDelegate) {
        this.pattern = pattern;
        this.tableDelegate = tableDelegate;
    }

    @Override
    @Nonnull
    public String title() {
        return "Static Pattern";
    }

    @Override
    public int numberOfSegments() {
        return 2;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 0: 
            case 1: {
                return 2;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableCell cellForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 0: {
                if (index == 0) {
                    TableCellStringInt cell = new TableCellStringInt("repeatX", this.pattern.repeatX);
                    cell.addPropertyConsumer(val -> {
                        this.pattern.repeatX = val;
                    });
                    return new TitledCell(IvTranslations.get("reccomplex.generationInfo.static.pattern.repeat.x"), cell).withTitleTooltip(IvTranslations.getLines("reccomplex.generationInfo.static.pattern.repeat.tooltip"));
                }
                if (index == 1) {
                    TableCellStringInt cell = new TableCellStringInt("repeatZ", this.pattern.repeatZ);
                    cell.addPropertyConsumer(val -> {
                        this.pattern.repeatZ = val;
                    });
                    return new TitledCell(IvTranslations.get("reccomplex.generationInfo.static.pattern.repeat.z"), cell).withTitleTooltip(IvTranslations.getLines("reccomplex.generationInfo.static.pattern.repeat.tooltip"));
                }
            }
            case 1: {
                if (index == 0) {
                    TableCellInteger cell = new TableCellInteger("shiftX", this.pattern.randomShiftX, 0, 10);
                    cell.addPropertyConsumer(val -> {
                        this.pattern.randomShiftX = val;
                    });
                    return new TitledCell(IvTranslations.get("reccomplex.generationInfo.static.pattern.rshift.x"), cell).withTitleTooltip(IvTranslations.getLines("reccomplex.generationInfo.static.pattern.rshift.tooltip"));
                }
                if (index != 1) break;
                TableCellInteger cell = new TableCellInteger("shiftZ", this.pattern.randomShiftZ, 0, 10);
                cell.addPropertyConsumer(val -> {
                    this.pattern.randomShiftZ = val;
                });
                return new TitledCell(IvTranslations.get("reccomplex.generationInfo.static.pattern.rshift.z"), cell).withTitleTooltip(IvTranslations.getLines("reccomplex.generationInfo.static.pattern.rshift.tooltip"));
            }
        }
        return super.cellForIndexInSegment(table, index, segment);
    }
}

